/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.google;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfoplus;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.google.MyAuthorizationCodeInstalledApp;

public class Utils {
    private static final GsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static HttpTransport httpTransport;
    private static final Log log;

    private static File getDriveDataDirectory() {
        return new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + "authentication" + File.separator + "drive");
    }

    private static File getGmailDataDirectory() {
        return new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + "authentication" + File.separator + "gmail");
    }

    public static Userinfoplus getUserInfo(Credential credentials) throws IOException {
        Oauth2 userInfoService = new Oauth2.Builder(httpTransport, (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)credentials).setApplicationName("JStock").build();
        Userinfoplus userInfo = (Userinfoplus)userInfoService.userinfo().get().execute();
        return userInfo;
    }

    public static String loadEmail(File dataStoreDirectory) {
        File file = new File(dataStoreDirectory, "email");
        try {
            return new String(Files.readAllBytes(Paths.get(file.toURI())), "UTF-8");
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveEmail(File dataStoreDirectory, String email) {
        File file = new File(dataStoreDirectory, "email");
        try {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                writer.write(email);
            }
            return true;
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return false;
        }
    }

    public static void logoutDrive() {
        File credential = new File(Utils.getDriveDataDirectory(), "StoredCredential");
        File email = new File(Utils.getDriveDataDirectory(), "email");
        credential.delete();
        email.delete();
    }

    public static void logoutGmail() {
        File credential = new File(Utils.getGmailDataDirectory(), "StoredCredential");
        File email = new File(Utils.getGmailDataDirectory(), "email");
        credential.delete();
        email.delete();
    }

    public static Pair<Credential, String> authorizeGmailOffline() throws Exception {
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("email");
        scopes.add("https://www.googleapis.com/auth/gmail.send");
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(Utils.class.getResourceAsStream("/assets/authentication/gmail/client_secrets.json")));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(httpTransport, (JsonFactory)JSON_FACTORY, clientSecrets, scopes).setDataStoreFactory((DataStoreFactory)new FileDataStoreFactory(Utils.getGmailDataDirectory())).build();
        Credential credential = flow.loadCredential("user");
        if (credential != null && credential.getRefreshToken() != null) {
            boolean success = false;
            if (credential.getExpiresInSeconds() <= 60L) {
                if (credential.refreshToken()) {
                    success = true;
                }
            } else {
                success = true;
            }
            if (success) {
                FileDataStoreFactory fileDataStoreFactory = (FileDataStoreFactory)flow.getCredentialDataStore().getDataStoreFactory();
                String email = Utils.loadEmail(fileDataStoreFactory.getDataDirectory());
                if (email == null) {
                    Userinfoplus userinfoplus = Utils.getUserInfo(credential);
                    email = userinfoplus.getEmail();
                }
                return new Pair<Credential, String>(credential, email);
            }
        }
        return null;
    }

    public static Pair<Pair<Credential, String>, Boolean> authorizeGmail() throws Exception {
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("email");
        scopes.add("https://www.googleapis.com/auth/gmail.send");
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(Utils.class.getResourceAsStream("/assets/authentication/gmail/client_secrets.json")));
        return Utils.authorize(clientSecrets, scopes, Utils.getGmailDataDirectory());
    }

    public static Pair<Pair<Credential, String>, Boolean> authorizeDrive() throws Exception {
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("email");
        scopes.add("https://www.googleapis.com/auth/drive.appdata");
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(Utils.class.getResourceAsStream("/assets/authentication/drive/client_secrets.json")));
        return Utils.authorize(clientSecrets, scopes, Utils.getDriveDataDirectory());
    }

    private static Pair<Pair<Credential, String>, Boolean> authorize(GoogleClientSecrets clientSecrets, Set<String> scopes, File dataStoreDirectory) throws Exception {
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(httpTransport, (JsonFactory)JSON_FACTORY, clientSecrets, scopes).setDataStoreFactory((DataStoreFactory)new FileDataStoreFactory(dataStoreDirectory)).build();
        return new MyAuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new LocalServerReceiver()).authorize("user");
    }

    public static Drive getDrive(Credential credential) {
        Drive service = new Drive.Builder(httpTransport, (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName("JStock").build();
        return service;
    }

    public static Gmail getGmail(Credential credential) {
        Gmail service = new Gmail.Builder(httpTransport, (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName("JStock").build();
        return service;
    }

    static {
        log = LogFactory.getLog(Utils.class);
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (GeneralSecurityException ex) {
            log.error(null, (Throwable)ex);
        }
    }
}

