/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.gui.AutoUpdateNewsJDialog;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.Utils;

public class OptionsUpdateJPanel
extends JPanel
implements JStockOptionsObserver {
    private static final Log log = LogFactory.getLog(OptionsUpdateJPanel.class);
    private volatile SwingWorker latestNewsTaskSwingWorker = null;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JXHeader jXHeader1;

    public OptionsUpdateJPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jButton1 = new JButton();
        this.jLabel7 = new JLabel();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("OptionsUpdateJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/epiphany-download.png")));
        this.jXHeader1.setTitle(bundle.getString("OptionsUpdateJPanel_Update"));
        this.add((Component)this.jXHeader1, "North");
        this.jCheckBox1.setText(bundle.getString("OptionsUpdateJPanel_InformMe"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsUpdateJPanel.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        this.jButton1.setText(bundle.getString("OptionsUpdateJPanel_ShowLastUpdateNews"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsUpdateJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addComponent(this.jCheckBox1)).addContainerGap(145, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1).addComponent(this.jLabel7)).addContainerGap(179, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.latestNewsTaskSwingWorker = this.getLatestNewsTaskSwingWorker();
        this.updateGUIState();
        this.jButton1.requestFocus();
        this.latestNewsTaskSwingWorker.execute();
    }

    private SwingWorker getLatestNewsTaskSwingWorker() {
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                String status = null;
                try {
                    status = (String)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (CancellationException ex) {
                    log.error(null, (Throwable)ex);
                }
                OptionsUpdateJPanel.this.updateGUIState();
                if (status == null) {
                    JOptionPane.showMessageDialog(OptionsUpdateJPanel.this, MessagesBundle.getString("error_message_error_in_getting_latest_news"), MessagesBundle.getString("error_title_error_in_getting_latest_news"), 0);
                } else {
                    AutoUpdateNewsJDialog dialog = new AutoUpdateNewsJDialog((Frame)JStock.instance(), true);
                    dialog.setNews(status);
                    dialog.setVisible(true);
                }
            }

            @Override
            protected String doInBackground() {
                if (!this.isCancelled()) {
                    Map<String, String> map = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.NEWS_INFORMATION_TXT));
                    String location = map.get("news_url");
                    if (location == null) {
                        return null;
                    }
                    String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
                    if (respond == null) {
                        return null;
                    }
                    if (respond.indexOf(Utils.getJStockUUID()) < 0) {
                        return null;
                    }
                    return respond;
                }
                return null;
            }
        };
        return worker;
    }

    private void updateGUIState() {
        boolean isLatestNewsTaskDone = this.latestNewsTaskSwingWorker == null || this.latestNewsTaskSwingWorker.isDone();
        this.jLabel7.setVisible(!isLatestNewsTaskDone);
        this.jCheckBox1.setEnabled(isLatestNewsTaskDone);
        this.jButton1.setEnabled(this.jCheckBox1.isSelected() && isLatestNewsTaskDone);
    }

    public void cancel() {
        if (this.latestNewsTaskSwingWorker != null) {
            this.latestNewsTaskSwingWorker.cancel(true);
        }
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        this.jCheckBox1.setSelected(jStockOptions.isAutoUpdateNewsEnabled());
        this.updateGUIState();
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        jStockOptions.setAutoUpdateNewsEnabled(this.jCheckBox1.isSelected());
        JStock.instance().initLatestNewsTask();
        return true;
    }
}

