/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.yccheok.jstock.gui.ToolElement;

public class ToolsSAXParser
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ToolsSAXParser.class);
    protected List<ToolElement> elements;

    public ToolsSAXParser(InputStream xmlFile) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(xmlFile, (DefaultHandler)this);
        }
        catch (Throwable t) {
            log.error((Object)"Problem while parsing the XML document with the SAXParser", t);
        }
    }

    @Override
    public void startElement(String name, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        ToolElement te = new ToolElement(eName);
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                te.setParam(aName, attrs.getValue(i));
            }
            log.debug((Object)("<" + eName + "/>"));
        }
        this.elements.add(te);
    }

    public List<ToolElement> getElements() {
        return this.elements;
    }

    @Override
    public void startDocument() throws SAXException {
        this.elements = new ArrayList<ToolElement>();
    }
}

