/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.charting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.yccheok.jstock.charting.ChartData;
import org.yccheok.jstock.charting.MACD;
import org.yccheok.jstock.charting.TechnicalAnalysis;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockNameDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.ChartJDialogOptions;
import org.yccheok.jstock.gui.charting.ChartLayerUI;
import org.yccheok.jstock.gui.charting.HyperlinkLikedJLabel;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.Utils;

public class ChartJDialog
extends JFrame
implements WindowListener {
    private Interval currentInverval = null;
    private Type currentType = null;
    private final StockHistoryServer stockHistoryServer;
    private List<ChartData> chartDatas;
    private final ChartPanel chartPanel;
    private final Map<Integer, TimeSeries> time_series_moving_average_map = new HashMap<Integer, TimeSeries>();
    private final Map<Integer, TimeSeries> time_series_exponential_moving_average_map = new HashMap<Integer, TimeSeries>();
    private final Map<TAEx, Integer> xydata_index_map = new HashMap<TAEx, Integer>();
    private final List<TAEx> activeTAExs = new ArrayList<TAEx>();
    private static final int MAX_MAP_SIZE = 20;
    private final Map<TAEx, XYPlot> price_volume_ta_map = new HashMap<TAEx, XYPlot>();
    private final Map<TAEx, XYPlot> candlestick_ta_map = new HashMap<TAEx, XYPlot>();
    private XYDataset priceDataset;
    private XYDataset volumeDataset;
    private TimeSeries priceTimeSeries;
    private OHLCDataset priceOHLCDataset;
    private JFreeChart priceVolumeChart;
    private JFreeChart candlestickChart;
    private final Executor updateHighLowLabelsPool = Executors.newFixedThreadPool(1);
    private final ChartLayerUI<ChartPanel> chartLayerUI;
    private final Frame parent;
    private static final Log log = LogFactory.getLog(ChartJDialog.class);
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu8;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JRadioButtonMenuItem jRadioButtonMenuItem1;
    private JRadioButtonMenuItem jRadioButtonMenuItem2;
    private JRadioButtonMenuItem jRadioButtonMenuItem3;
    private JRadioButtonMenuItem jRadioButtonMenuItem4;

    private Interval getCurrentInterval() {
        return this.currentInverval;
    }

    private Type getCurrentType() {
        return this.currentType;
    }

    public ChartJDialog(Frame parent, String title, boolean modalNotUsed, StockHistoryServer stockHistoryServer) {
        super(title);
        this.parent = parent;
        this.parent.addWindowListener(this);
        this.setIconImage(parent.getIconImage());
        this.initComponents();
        this.initKeyBindings();
        this.chartPanel = new ChartPanel(null, true, true, true, true, true);
        this.stockHistoryServer = stockHistoryServer;
        ChartJDialogOptions chartJDialogOptions = JStock.instance().getChartJDialogOptions();
        this.changeInterval(chartJDialogOptions.getInterval());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.chartPanel.setMaximumDrawWidth((int)Math.round(dimension.getWidth()));
        this.chartPanel.setMaximumDrawHeight((int)Math.round(dimension.getHeight()));
        this.chartPanel.setFocusable(true);
        this.chartPanel.requestFocus();
        JXLayer layer = new JXLayer((Component)this.chartPanel);
        this.chartLayerUI = new ChartLayerUI(this);
        layer.setUI(this.chartLayerUI);
        this.changeType(chartJDialogOptions.getType());
        this.getContentPane().add((Component)layer, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChartJDialog.this.chartLayerUI.updateTraceInfos();
            }
        });
        if (JStock.instance().getJStockOptions().getChartTheme() == JStockOptions.ChartTheme.Light) {
            this.jRadioButtonMenuItem3.setSelected(true);
        } else {
            this.jRadioButtonMenuItem4.setSelected(true);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.toFront();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.setAlwaysOnTop(false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.setVisible(true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void buildTAMenuItems() {
        int i;
        final int[] days = new int[]{14, 28, 50, 100, 200};
        final MACD.Period[] macd_periods = new MACD.Period[]{MACD.Period.newInstance(12, 26, 9)};
        String[] day_keys = new String[]{"ChartJDialog_14Days", "ChartJDialog_28Days", "ChartJDialog_50Days", "ChartJDialog_100Days", "ChartJDialog_200Days"};
        String[] week_keys = new String[]{"ChartJDialog_14Weeks", "ChartJDialog_28Weeks", "ChartJDialog_50Weeks", "ChartJDialog_100Weeks", "ChartJDialog_200Weeks"};
        String[] month_keys = new String[]{"ChartJDialog_14Months", "ChartJDialog_28Months", "ChartJDialog_50Months", "ChartJDialog_100Months", "ChartJDialog_200Months"};
        assert (days.length == day_keys.length);
        assert (days.length == week_keys.length);
        assert (days.length == week_keys.length);
        String[] macd_day_keys = new String[]{"ChartJDialog_12_26_9Days"};
        String[] macd_week_keys = new String[]{"ChartJDialog_12_26_9Weeks"};
        String[] macd_month_keys = new String[]{"ChartJDialog_12_26_9Months"};
        assert (macd_periods.length == macd_day_keys.length);
        assert (macd_periods.length == macd_week_keys.length);
        assert (macd_periods.length == macd_month_keys.length);
        String[] keys = null;
        String[] macd_keys = null;
        if (this.getCurrentInterval() == Interval.Daily) {
            keys = day_keys;
            macd_keys = macd_day_keys;
        } else if (this.getCurrentInterval() == Interval.Weekly) {
            keys = week_keys;
            macd_keys = macd_week_keys;
        } else if (this.getCurrentInterval() == Interval.Monthly) {
            keys = month_keys;
            macd_keys = macd_month_keys;
        } else assert (false);
        TA[] tas = TA.values();
        String[] ta_keys = new String[]{"ChartJDialog_SMA", "ChartJDialog_EMA", "ChartJDialog_MACD", "ChartJDialog_RSI", "ChartJDialog_MFI", "ChartJDialog_CCI"};
        String[] ta_tip_keys = new String[]{"ChartJDialog_SimpleMovingAverage", "ChartJDialog_ExponentialMovingAverage", "ChartJDialog_MovingAverageConvergenceDivergence", "ChartJDialog_RelativeStrengthIndex", "ChartJDialog_MoneyFlowIndex", "ChartJDialog_CommodityChannelIndex"};
        final String[] custom_message_keys = new String[]{"info_message_please_enter_number_of_days_for_SMA", "info_message_please_enter_number_of_days_for_EMA", "dummy", "info_message_please_enter_number_of_days_for_RSI", "info_message_please_enter_number_of_days_for_MFI", "info_message_please_enter_number_of_days_for_CCI"};
        EnumMap m = new EnumMap(TA.class);
        int taExSize = JStock.instance().getChartJDialogOptions().getTAExSize();
        for (i = 0; i < taExSize; ++i) {
            TAEx taEx = JStock.instance().getChartJDialogOptions().getTAEx(i);
            if (!m.containsKey((Object)taEx.getTA())) {
                m.put(taEx.getTA(), new HashSet());
            }
            ((Set)m.get((Object)taEx.getTA())).add(taEx.getParameter());
        }
        int length = tas.length;
        for (i = 0; i < length; ++i) {
            JCheckBoxMenuItem item;
            int _j;
            int j;
            int length2;
            final TA ta = tas[i];
            JMenu menu = new JMenu();
            menu.setText(GUIBundle.getString(ta_keys[i]));
            menu.setToolTipText(GUIBundle.getString(ta_tip_keys[i]));
            if (ta == TA.MACD) {
                length2 = macd_periods.length;
                for (j = 0; j < length2; ++j) {
                    _j = j;
                    item = new JCheckBoxMenuItem();
                    item.setText(GUIBundle.getString(macd_keys[j]));
                    if (m.containsKey((Object)ta) && ((Set)m.get((Object)ta)).contains(macd_periods[_j])) {
                        item.setSelected(true);
                    }
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            if (ta == TA.MACD) {
                                ChartJDialog.this.updateMACD(macd_periods[_j], item.isSelected());
                            }
                        }
                    });
                    menu.add(item);
                }
            } else {
                length2 = days.length;
                for (j = 0; j < length2; ++j) {
                    _j = j;
                    item = new JCheckBoxMenuItem();
                    item.setText(GUIBundle.getString(keys[j]));
                    if (m.containsKey((Object)ta) && ((Set)m.get((Object)ta)).contains(days[_j])) {
                        item.setSelected(true);
                    }
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            if (ta == TA.SMA) {
                                ChartJDialog.this.updateSMA(days[_j], item.isSelected());
                            } else if (ta == TA.EMA) {
                                ChartJDialog.this.updateEMA(days[_j], item.isSelected());
                            } else if (ta == TA.MFI) {
                                ChartJDialog.this.updateMFI(days[_j], item.isSelected());
                            } else if (ta == TA.RSI) {
                                ChartJDialog.this.updateRSI(days[_j], item.isSelected());
                            } else if (ta == TA.CCI) {
                                ChartJDialog.this.updateCCI(days[_j], item.isSelected());
                            }
                        }
                    });
                    menu.add(item);
                }
            }
            menu.add(new JSeparator());
            JMenuItem item2 = new JMenuItem();
            item2.setText(GUIBundle.getString("ChartJDialog_Custom..."));
            final int _i = i;
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ta != TA.MACD) {
                        while (true) {
                            String days_string;
                            if ((days_string = JOptionPane.showInputDialog(ChartJDialog.this, (Object)MessagesBundle.getString(custom_message_keys[_i]))) == null) {
                                return;
                            }
                            try {
                                int days = Integer.parseInt(days_string);
                                if (days <= 0) {
                                    JOptionPane.showMessageDialog(ChartJDialog.this, MessagesBundle.getString("info_message_number_of_days_required"), MessagesBundle.getString("info_title_number_of_days_required"), 2);
                                    continue;
                                }
                                ChartJDialog.this.updateTA(ta, days, true);
                                return;
                            }
                            catch (NumberFormatException exp) {
                                log.error(null, (Throwable)exp);
                                JOptionPane.showMessageDialog(ChartJDialog.this, MessagesBundle.getString("info_message_number_of_days_required"), MessagesBundle.getString("info_title_number_of_days_required"), 2);
                                continue;
                            }
                            break;
                        }
                    }
                    ChartJDialog.this.showMACDCustomDialog();
                }
            });
            menu.add(item2);
            if (ta == TA.MACD) continue;
            this.jMenu2.add(menu);
        }
        this.jMenu2.add(new JSeparator());
        JMenuItem item = new JMenuItem();
        item.setText(GUIBundle.getString("ChartJDialog_ClearAll"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.clearAll();
            }
        });
        this.jMenu2.add(item);
    }

    private void updateTA(TA ta, int days, boolean show) {
        if (ta == TA.SMA) {
            this.updateSMA(days, show);
        } else if (ta == TA.EMA) {
            this.updateEMA(days, show);
        } else if (ta == TA.MFI) {
            this.updateMFI(days, show);
        } else if (ta == TA.RSI) {
            this.updateRSI(days, show);
        } else if (ta == TA.CCI) {
            this.updateCCI(days, show);
        }
    }

    private void loadChartJDialogOptions() {
        ChartJDialogOptions chartJDialogOptions = JStock.instance().getChartJDialogOptions();
        this.zoom(chartJDialogOptions.getZoom());
        int TAExSize = chartJDialogOptions.getTAExSize();
        for (int i = 0; i < TAExSize; ++i) {
            TAEx taEx = chartJDialogOptions.getTAEx(i);
            TA ta = taEx.getTA();
            if (ta == TA.MACD) {
                MACD.Period period = (MACD.Period)taEx.getParameter();
                this.updateMACD(period, true);
                continue;
            }
            Integer day = (Integer)taEx.getParameter();
            this.updateTA(ta, day, true);
        }
    }

    public List<ChartData> getChartDatas() {
        return Collections.unmodifiableList(this.chartDatas);
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel4 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPanel6 = new JPanel();
        this.jLabel9 = new HyperlinkLikedJLabel();
        this.jLabel10 = new HyperlinkLikedJLabel();
        this.jLabel11 = new HyperlinkLikedJLabel();
        this.jLabel12 = new HyperlinkLikedJLabel();
        this.jLabel13 = new HyperlinkLikedJLabel();
        this.jLabel5 = new HyperlinkLikedJLabel();
        this.jLabel6 = new HyperlinkLikedJLabel();
        this.jLabel14 = new HyperlinkLikedJLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenu3 = new JMenu();
        this.jRadioButtonMenuItem1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
        this.jMenu4 = new JMenu();
        this.jRadioButtonMenuItem3 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem4 = new JRadioButtonMenuItem();
        this.jMenu8 = new JMenu();
        this.jMenuItem7 = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setAutoRequestFocus(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ChartJDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        this.jPanel4.setLayout(new BorderLayout(5, 5));
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 160));
        this.jPanel2.setPreferredSize(new Dimension(120, 33));
        this.jPanel1.setLayout(new GridLayout(2, 1, 0, 5));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jLabel1.setText(bundle.getString("ChartJDialog_High"));
        this.jPanel1.add(this.jLabel1);
        this.jLabel3.setText(bundle.getString("ChartJDialog_Low"));
        this.jPanel1.add(this.jLabel3);
        this.jPanel3.setLayout(new GridLayout(2, 1, 0, 5));
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1));
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setForeground(JStockOptions.DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR);
        this.jPanel3.add(this.jLabel2);
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setForeground(JStockOptions.DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR);
        this.jPanel3.add(this.jLabel4);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -2, 71, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 34, -2).addComponent(this.jPanel3, -2, 34, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.add((Component)this.jPanel2, "West");
        this.jComboBox1.setModel(this.getComboBoxModel());
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jComboBox1);
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel6.setLayout(new FlowLayout(1, 10, 10));
        this.jLabel9.setText(bundle.getString("ChartJDialog_7Days"));
        this.jLabel9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel9MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel9);
        this.jLabel10.setText(bundle.getString("ChartJDialog_1Month"));
        this.jLabel10.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel10MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel10);
        this.jLabel11.setText(bundle.getString("ChartJDialog_3Months"));
        this.jLabel11.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel11MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel11);
        this.jLabel12.setText(bundle.getString("ChartJDialog_6Months"));
        this.jLabel12.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel12MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel12);
        this.jLabel13.setText(bundle.getString("ChartJDialog_1Year"));
        this.jLabel13.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel13MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel13);
        this.jLabel5.setText(bundle.getString("ChartJDialog_5Years"));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel5MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel5);
        this.jLabel6.setText(bundle.getString("ChartJDialog_10Years"));
        this.jLabel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel6MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel6);
        this.jLabel14.setText(bundle.getString("ChartJDialog_All"));
        this.jLabel14.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJDialog.this.jLabel14MouseClicked(evt);
            }
        });
        this.jPanel6.add(this.jLabel14);
        this.jPanel4.add((Component)this.jPanel6, "Center");
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jMenu1.setText(bundle.getString("ChartJDialog_File"));
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filesave.png")));
        this.jMenuItem1.setText(bundle.getString("ChartJDialog_SaveAs..."));
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText(bundle.getString("ChartJDialog_TechnicalAnalysis"));
        this.jMenu2.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ChartJDialog.this.jMenu2MenuSelected(evt);
            }
        });
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText(bundle.getString("ChartJDialog_Type"));
        this.buttonGroup1.add(this.jRadioButtonMenuItem1);
        this.jRadioButtonMenuItem1.setSelected(true);
        this.jRadioButtonMenuItem1.setText(bundle.getString("ChartJDialog_PriceVolume"));
        this.jRadioButtonMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.jRadioButtonMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItem1);
        this.buttonGroup1.add(this.jRadioButtonMenuItem2);
        this.jRadioButtonMenuItem2.setText(bundle.getString("ChartJDialog_Candlestick"));
        this.jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.jRadioButtonMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItem2);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu4.setText(bundle.getString("ChartJDialog_Theme"));
        this.buttonGroup2.add(this.jRadioButtonMenuItem3);
        this.jRadioButtonMenuItem3.setSelected(true);
        this.jRadioButtonMenuItem3.setText(bundle.getString("ChartJDialog_Light"));
        this.jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.jRadioButtonMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItem3);
        this.buttonGroup2.add(this.jRadioButtonMenuItem4);
        this.jRadioButtonMenuItem4.setText(bundle.getString("ChartJDialog_Dark"));
        this.jRadioButtonMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.jRadioButtonMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItem4);
        this.jMenuBar1.add(this.jMenu4);
        this.jMenu8.setText(bundle.getString("ChartJDialog_Help"));
        this.jMenuItem7.setText(bundle.getString("ChartJDialog_TechnicalAnalysisTutorial"));
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartJDialog.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu8.add(this.jMenuItem7);
        this.jMenuBar1.add(this.jMenu8);
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(750, 600));
        this.setLocationRelativeTo(null);
    }

    private void initKeyBindings() {
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartJDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private ComboBoxModel getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{GUIBundle.getString("ChartJDialog_Daily"), GUIBundle.getString("ChartJDialog_Weekly"), GUIBundle.getString("ChartJDialog_Monthly")});
    }

    private void changeInterval(Interval interval) {
        if (interval == this.getCurrentInterval()) {
            return;
        }
        if (interval == Interval.Weekly) {
            this.chartDatas = org.yccheok.jstock.charting.Utils.getWeeklyChartData(this.stockHistoryServer);
        } else if (interval == Interval.Monthly) {
            this.chartDatas = org.yccheok.jstock.charting.Utils.getMonthlyChartData(this.stockHistoryServer);
        } else {
            assert (interval == Interval.Daily);
            this.chartDatas = org.yccheok.jstock.charting.Utils.getDailyChartData(this.stockHistoryServer);
        }
        this.priceTimeSeries = this.getPriceTimeSeries(this.chartDatas);
        this.priceDataset = new TimeSeriesCollection(this.priceTimeSeries);
        this.priceOHLCDataset = this.getOHLCDataset(this.chartDatas);
        this.volumeDataset = this.getVolumeDataset(this.chartDatas);
        this.priceVolumeChart = null;
        this.candlestickChart = null;
        this.changeType(JStock.instance().getChartJDialogOptions().getType());
        this.time_series_moving_average_map.clear();
        this.time_series_exponential_moving_average_map.clear();
        this.xydata_index_map.clear();
        this.activeTAExs.clear();
        this.price_volume_ta_map.clear();
        this.candlestick_ta_map.clear();
        this.jMenu2.removeAll();
        JStock.instance().getChartJDialogOptions().setInterval(interval);
        this.currentInverval = interval;
        if (interval == Interval.Daily) {
            this.jComboBox1.setSelectedItem(GUIBundle.getString("ChartJDialog_Daily"));
        } else if (interval == Interval.Weekly) {
            this.jComboBox1.setSelectedItem(GUIBundle.getString("ChartJDialog_Weekly"));
        } else if (interval == Interval.Monthly) {
            this.jComboBox1.setSelectedItem(GUIBundle.getString("ChartJDialog_Monthly"));
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChartJDialog.this.loadChartJDialogOptions();
                    }
                });
            }
        }).start();
    }

    private void changeType(Type type) {
        if (!(type != this.getCurrentType() || this.priceVolumeChart == null && type == Type.PriceVolume || this.candlestickChart == null && type == Type.Candlestick)) {
            return;
        }
        if (type == Type.PriceVolume) {
            if (this.priceVolumeChart == null) {
                this.priceVolumeChart = this.createPriceVolumeChart(this.priceDataset, this.volumeDataset);
            }
            this.chartPanel.setChart(this.priceVolumeChart);
            this.chartPanel.requestFocus();
            if (this.chartLayerUI != null) {
                this.chartLayerUI.updateTraceInfos();
            }
        } else if (type == Type.Candlestick) {
            if (this.candlestickChart == null) {
                this.candlestickChart = this.createCandlestickChart(this.priceOHLCDataset);
            }
            this.chartPanel.setChart(this.candlestickChart);
            this.chartPanel.requestFocus();
            if (this.chartLayerUI != null) {
                this.chartLayerUI.updateTraceInfos();
            }
        }
        JStock.instance().getChartJDialogOptions().setType(type);
        this.currentType = type;
        if (type == Type.PriceVolume) {
            this.jRadioButtonMenuItem1.setSelected(true);
        } else if (type == Type.Candlestick) {
            this.jRadioButtonMenuItem2.setSelected(true);
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        String selected = this.jComboBox1.getSelectedItem().toString();
        Interval interval = Interval.Daily;
        if (selected.equals(GUIBundle.getString("ChartJDialog_Daily"))) {
            interval = Interval.Daily;
        } else if (selected.equals(GUIBundle.getString("ChartJDialog_Weekly"))) {
            interval = Interval.Weekly;
        } else if (selected.equals(GUIBundle.getString("ChartJDialog_Monthly"))) {
            interval = Interval.Monthly;
        }
        this.changeInterval(interval);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        assert (this.stockHistoryServer.size() > 0);
        Stock stock = this.stockHistoryServer.getStock(this.stockHistoryServer.getTimestamp(0));
        File file = Utils.promptSaveCSVAndExcelJFileChooser(stock.code.toString());
        if (file != null) {
            if (Utils.getFileExtension(file).equals("csv")) {
                Statements statements = Statements.newInstanceFromStockHistoryServer(this.stockHistoryServer, false);
                statements.saveAsCSVFile(file);
            } else if (Utils.getFileExtension(file).equals("xls")) {
                Statements statements = Statements.newInstanceFromStockHistoryServer(this.stockHistoryServer, false);
                statements.saveAsExcelFile(file, stock.code.toString());
            } else assert (false);
        }
    }

    private void clearAll() {
        int i;
        for (i = 0; i < this.activeTAExs.size(); ++i) {
            TAEx taEx = this.activeTAExs.get(i);
            if (taEx.ta == TA.SMA) {
                this.updateSMA((Integer)taEx.parameter, false);
                --i;
                continue;
            }
            if (taEx.ta == TA.RSI) {
                this.updateRSI((Integer)taEx.parameter, false);
                --i;
                continue;
            }
            if (taEx.ta == TA.CCI) {
                this.updateCCI((Integer)taEx.parameter, false);
                --i;
                continue;
            }
            if (taEx.ta == TA.EMA) {
                this.updateEMA((Integer)taEx.parameter, false);
                --i;
                continue;
            }
            if (taEx.ta == TA.MFI) {
                this.updateMFI((Integer)taEx.parameter, false);
                --i;
                continue;
            }
            if (taEx.ta == TA.MACD) {
                this.updateMACD((MACD.Period)taEx.parameter, false);
                --i;
                continue;
            }
            assert (false);
        }
        int count = this.jMenu2.getItemCount();
        for (i = 0; i < count; ++i) {
            JMenuItem item = this.jMenu2.getItem(i);
            if (!(item instanceof JMenu)) continue;
            JMenu m = (JMenu)item;
            int count2 = m.getItemCount();
            for (int j = 0; j < count2; ++j) {
                JMenuItem item2 = m.getItem(j);
                if (!(item2 instanceof JCheckBoxMenuItem)) continue;
                m.getItem(j).setSelected(false);
            }
        }
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.MA_INDICATOR_HTML));
    }

    private void jLabel9MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.Days7);
    }

    private void _updateHighLowJLabels() {
        TimeSeriesDataItem item;
        long time;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChartJDialog.this.jLabel2.setText("");
                ChartJDialog.this.jLabel4.setText("");
            }
        });
        ValueAxis valueAxis = this.getPlot().getDomainAxis();
        Range range = valueAxis.getRange();
        long lowerBound = (long)range.getLowerBound();
        long upperBound = (long)range.getUpperBound();
        int low = 0;
        int high = this.priceTimeSeries.getItemCount() - 1;
        long best_dist = Long.MAX_VALUE;
        int best_mid = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Day day = (Day)this.priceTimeSeries.getDataItem(mid).getPeriod();
            long v = day.getFirstMillisecond();
            if (v > upperBound) {
                high = mid - 1;
                continue;
            }
            if (v < upperBound) {
                low = mid + 1;
                long dist = upperBound - v;
                if (dist >= best_dist) continue;
                best_dist = dist;
                best_mid = mid;
                continue;
            }
            best_dist = 0L;
            best_mid = mid;
            break;
        }
        if (best_mid < 0) {
            return;
        }
        double high_price = -1.7976931348623157E308;
        double low_price = Double.MAX_VALUE;
        DefaultHighLowDataset defaultHighLowDataset = (DefaultHighLowDataset)this.priceOHLCDataset;
        for (int i = best_mid; i >= 0 && (time = ((Day)(item = this.priceTimeSeries.getDataItem(i)).getPeriod()).getFirstMillisecond()) >= lowerBound; --i) {
            double _high_price = defaultHighLowDataset.getHighValue(0, i);
            double _low_price = defaultHighLowDataset.getLowValue(0, i);
            double _last_price = defaultHighLowDataset.getCloseValue(0, i);
            high_price = Math.max(high_price, _high_price);
            if (_low_price > 0.0) {
                low_price = Math.min(low_price, _low_price);
                continue;
            }
            if (_high_price > 0.0) {
                low_price = Math.min(low_price, _high_price);
            }
            if (!(_last_price > 0.0)) continue;
            low_price = Math.min(low_price, _last_price);
        }
        final double h = high_price;
        final double l = low_price;
        if (high_price >= low_price) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartJDialog.this.jLabel2.setText(Utils.stockPriceDecimalFormat(h));
                    ChartJDialog.this.jLabel4.setText(Utils.stockPriceDecimalFormat(l));
                }
            });
        }
    }

    private void resetAllDayLabels() {
        JLabel[] labels;
        for (JLabel label : labels = new JLabel[]{this.jLabel9, this.jLabel10, this.jLabel11, this.jLabel12, this.jLabel13, this.jLabel14, this.jLabel5, this.jLabel6}) {
            Font oldFont = label.getFont();
            Font font = oldFont.deriveFont(oldFont.getStyle() & 0xFFFFFFFE);
            label.setFont(font);
        }
    }

    private void updateHighLowJLabels() {
        this.updateHighLowLabelsPool.execute(new Runnable(){

            @Override
            public void run() {
                ChartJDialog.this._updateHighLowJLabels();
            }
        });
    }

    private void zoom(Zoom z) {
        switch (z) {
            case Days7: {
                this._zoom(5, -7);
                this.resetAllDayLabels();
                this.jLabel9.setFont(Utils.getBoldFont(this.jLabel9.getFont()));
                break;
            }
            case Month1: {
                this._zoom(2, -1);
                this.resetAllDayLabels();
                this.jLabel10.setFont(Utils.getBoldFont(this.jLabel10.getFont()));
                break;
            }
            case Months3: {
                this._zoom(2, -3);
                this.resetAllDayLabels();
                this.jLabel11.setFont(Utils.getBoldFont(this.jLabel11.getFont()));
                break;
            }
            case Months6: {
                this._zoom(2, -6);
                this.resetAllDayLabels();
                this.jLabel12.setFont(Utils.getBoldFont(this.jLabel12.getFont()));
                break;
            }
            case Year1: {
                this._zoom(1, -1);
                this.resetAllDayLabels();
                this.jLabel13.setFont(Utils.getBoldFont(this.jLabel13.getFont()));
                break;
            }
            case Year5: {
                this._zoom(1, -5);
                this.resetAllDayLabels();
                this.jLabel5.setFont(Utils.getBoldFont(this.jLabel5.getFont()));
                break;
            }
            case Year10: {
                this._zoom(1, -10);
                this.resetAllDayLabels();
                this.jLabel6.setFont(Utils.getBoldFont(this.jLabel6.getFont()));
                break;
            }
            case All: {
                this.chartPanel.restoreAutoBounds();
                this.resetAllDayLabels();
                this.jLabel14.setFont(Utils.getBoldFont(this.jLabel14.getFont()));
            }
        }
        JStock.instance().getChartJDialogOptions().setZoom(z);
    }

    private void _zoom(int field, int amount) {
        double volumeUpperBound;
        double suggestedVolumneUpperBound;
        TimeSeriesDataItem item;
        Day d;
        this.chartPanel.restoreAutoBounds();
        int itemCount = this.priceTimeSeries.getItemCount();
        Day day = (Day)this.priceTimeSeries.getDataItem(itemCount - 1).getPeriod();
        long end = day.getFirstMillisecond() + (long)(this.getCurrentType() == Type.Candlestick ? 43200000 : 86399999);
        Calendar calendar = Calendar.getInstance();
        calendar.set(day.getYear(), day.getMonth() - 1, day.getDayOfMonth(), 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(field, amount);
        long start = Math.max(0L, calendar.getTimeInMillis() - (long)(this.getCurrentType() == Type.Candlestick ? 43200000 : 0));
        ValueAxis valueAxis = this.getPlot().getDomainAxis();
        if (this.priceTimeSeries.getItemCount() > 0 && start < this.priceTimeSeries.getTimePeriod(0).getFirstMillisecond()) {
            return;
        }
        valueAxis.setRange((double)start, (double)end);
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double max_volume = Double.MIN_VALUE;
        DefaultHighLowDataset defaultHighLowDataset = (DefaultHighLowDataset)this.priceOHLCDataset;
        for (int i = itemCount - 1; i >= 0 && (d = (Day)(item = this.priceTimeSeries.getDataItem(i)).getPeriod()).getFirstMillisecond() >= start; --i) {
            double high = defaultHighLowDataset.getHighValue(0, i);
            double low = defaultHighLowDataset.getLowValue(0, i);
            double volume = defaultHighLowDataset.getVolumeValue(0, i);
            if (max < high) {
                max = high;
            }
            if (min > low) {
                min = low;
            }
            if (!(max_volume < volume)) continue;
            max_volume = volume;
        }
        if (min > max) {
            return;
        }
        ValueAxis rangeAxis = this.getPlot().getRangeAxis();
        Range rangeAxisRange = rangeAxis.getRange();
        double tolerance = 0.01 * (max - min);
        tolerance = Math.min(Math.max(0.01, tolerance), 1.0);
        min = Math.max(rangeAxisRange.getLowerBound(), min - tolerance);
        max = Math.min(rangeAxisRange.getUpperBound(), max + tolerance);
        this.getPlot().getRangeAxis().setRange(min, max);
        if (this.getPlot().getRangeAxisCount() > 1 && (suggestedVolumneUpperBound = max_volume * 4.0) < (volumeUpperBound = this.getPlot().getRangeAxis(1).getRange().getUpperBound())) {
            this.getPlot().getRangeAxis(1).setRange(0.0, suggestedVolumneUpperBound);
        }
    }

    private void jLabel10MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.Month1);
    }

    private void jLabel11MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.Months3);
    }

    private void jLabel12MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.Months6);
    }

    private void jLabel13MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.Year1);
    }

    private void jLabel14MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.All);
    }

    private void jMenu2MenuSelected(MenuEvent evt) {
        if (this.jMenu2.getItemCount() <= 0) {
            this.buildTAMenuItems();
        }
    }

    private void jRadioButtonMenuItem1ActionPerformed(ActionEvent evt) {
        this.changeType(Type.PriceVolume);
        this.zoom(JStock.instance().getChartJDialogOptions().getZoom());
    }

    private void jRadioButtonMenuItem2ActionPerformed(ActionEvent evt) {
        this.changeType(Type.Candlestick);
        this.zoom(JStock.instance().getChartJDialogOptions().getZoom());
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.Year5);
    }

    private void jLabel6MouseClicked(MouseEvent evt) {
        this.zoom(Zoom.Year10);
    }

    private void jRadioButtonMenuItem3ActionPerformed(ActionEvent evt) {
        JStock.instance().getJStockOptions().setChartTheme(JStockOptions.ChartTheme.Light);
        if (this.priceVolumeChart != null) {
            org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.priceVolumeChart);
        }
        if (this.candlestickChart != null) {
            org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.candlestickChart);
        }
    }

    private void jRadioButtonMenuItem4ActionPerformed(ActionEvent evt) {
        JStock.instance().getJStockOptions().setChartTheme(JStockOptions.ChartTheme.Dark);
        if (this.priceVolumeChart != null) {
            org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.priceVolumeChart);
        }
        if (this.candlestickChart != null) {
            org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.candlestickChart);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.parent.removeWindowListener(this);
        this.dispose();
    }

    private JFreeChart createPriceVolumeChart(XYDataset priceDataset, XYDataset volumeDataset) {
        String title = this.getBestStockName();
        DateAxis timeAxis = new DateAxis(GUIBundle.getString("ChartJDialog_Date"));
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis rangeAxis1 = new NumberAxis(GUIBundle.getString("ChartJDialog_Price"));
        rangeAxis1.setAutoRangeIncludesZero(false);
        rangeAxis1.setLowerMargin(0.4);
        DecimalFormat format = new DecimalFormat("0.00#");
        rangeAxis1.setNumberFormatOverride((NumberFormat)format);
        XYPlot plot = new XYPlot(priceDataset, (ValueAxis)timeAxis, (ValueAxis)rangeAxis1, null);
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
        renderer1.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00#")));
        plot.setRenderer(0, (XYItemRenderer)renderer1);
        NumberAxis rangeAxis2 = new NumberAxis("Volume");
        rangeAxis2.setUpperMargin(1.0);
        plot.setRangeAxis(1, (ValueAxis)rangeAxis2);
        plot.setDataset(1, volumeDataset);
        plot.mapDatasetToRangeAxis(1, 1);
        XYBarRenderer renderer2 = new XYBarRenderer(0.2);
        renderer2.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0,000.00")));
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        CombinedDomainXYPlot cplot = new CombinedDomainXYPlot((ValueAxis)timeAxis);
        cplot.add(plot, 1);
        cplot.setGap(8.0);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)cplot, true);
        org.yccheok.jstock.charting.Utils.applyChartThemeEx(chart);
        org.yccheok.jstock.charting.Utils.setPriceSeriesPaint((XYItemRenderer)renderer1);
        org.yccheok.jstock.charting.Utils.setVolumeSeriesPaint((XYItemRenderer)renderer2);
        chart.addChangeListener(this.getChartChangeListner());
        return chart;
    }

    private TimeSeries getPriceTimeSeries(List<ChartData> chartDatas) {
        TimeSeries series1 = new TimeSeries((Comparable)((Object)GUIBundle.getString("ChartJDialog_Price")));
        for (ChartData chartData : chartDatas) {
            series1.add((RegularTimePeriod)new Day(new Date(chartData.timestamp)), chartData.lastPrice);
        }
        return series1;
    }

    private XYDataset getVolumeDataset(List<ChartData> chartDatas) {
        TimeSeries series1 = new TimeSeries((Comparable)((Object)GUIBundle.getString("ChartJDialog_Volume")));
        for (ChartData chartData : chartDatas) {
            series1.add((RegularTimePeriod)new Day(new Date(chartData.timestamp)), (double)chartData.volume);
        }
        return new TimeSeriesCollection(series1);
    }

    private String getBestStockName() {
        String name;
        StockNameDatabase stockNameDatabase;
        int num = this.stockHistoryServer.size();
        Stock stock = this.stockHistoryServer.getStock(this.stockHistoryServer.getTimestamp(num - 1));
        if (org.yccheok.jstock.engine.Utils.isNameImmutable() && (stockNameDatabase = JStock.instance().getStockNameDatabase()) != null && (name = stockNameDatabase.codeToName(stock.code)) != null) {
            return name;
        }
        String name2 = stock.getName();
        if (name2.isEmpty()) {
            Symbol s;
            Symbol symbol = stock.symbol;
            if (!symbol.toString().isEmpty()) {
                return symbol.toString();
            }
            StockInfoDatabase stockInfoDatabase = JStock.instance().getStockInfoDatabase();
            if (stockInfoDatabase != null && (s = stockInfoDatabase.codeToSymbol(stock.code)) != null) {
                return s.toString();
            }
            return stock.code.toString();
        }
        return name2;
    }

    private JFreeChart createCandlestickChart(OHLCDataset priceOHLCDataset) {
        String title = this.getBestStockName();
        DateAxis timeAxis = new DateAxis(GUIBundle.getString("ChartJDialog_Date"));
        NumberAxis valueAxis = new NumberAxis(GUIBundle.getString("ChartJDialog_Price"));
        valueAxis.setAutoRangeIncludesZero(false);
        valueAxis.setUpperMargin(0.0);
        valueAxis.setLowerMargin(0.0);
        XYPlot plot = new XYPlot((XYDataset)priceOHLCDataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        CandlestickRenderer candlestickRenderer = new CandlestickRenderer();
        plot.setRenderer((XYItemRenderer)candlestickRenderer);
        ((CandlestickRenderer)plot.getRenderer()).setAutoWidthMethod(1);
        CombinedDomainXYPlot cplot = new CombinedDomainXYPlot((ValueAxis)timeAxis);
        cplot.add(plot, 3);
        cplot.setGap(8.0);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)cplot, true);
        org.yccheok.jstock.charting.Utils.applyChartThemeEx(chart);
        chart.addChangeListener(this.getChartChangeListner());
        return chart;
    }

    private OHLCDataset getOHLCDataset(List<ChartData> chartDatas) {
        int size = chartDatas.size();
        Date[] date = new Date[size];
        double[] high = new double[size];
        double[] low = new double[size];
        double[] open = new double[size];
        double[] close = new double[size];
        double[] volume = new double[size];
        int i = 0;
        for (ChartData chartData : chartDatas) {
            date[i] = new Date(chartData.timestamp);
            high[i] = chartData.highPrice;
            low[i] = chartData.lowPrice;
            open[i] = chartData.openPrice;
            close[i] = chartData.lastPrice;
            volume[i] = chartData.volume;
            ++i;
        }
        return new DefaultHighLowDataset((Comparable)((Object)GUIBundle.getString("ChartJDialog_Price")), date, high, low, open, close, volume);
    }

    private int getIndex(TAEx taEx, Map<TAEx, Integer> map) {
        if (map.containsKey(taEx)) {
            return map.get(taEx);
        }
        int max = 0;
        for (Integer index : map.values()) {
            if (index <= max) continue;
            max = index;
        }
        return max + 1;
    }

    private String getEMAKey(int days) {
        Interval interval = this.getCurrentInterval();
        String c = "d";
        if (interval == Interval.Weekly) {
            c = "w";
        } else if (interval == Interval.Monthly) {
            c = "m";
        }
        return days + c + " EMA";
    }

    private String getSMAKey(int days) {
        Interval interval = this.getCurrentInterval();
        String c = "d";
        if (interval == Interval.Weekly) {
            c = "w";
        } else if (interval == Interval.Monthly) {
            c = "m";
        }
        return days + c + " SMA";
    }

    private String getRSIKey(int days) {
        Interval interval = this.getCurrentInterval();
        String c = "d";
        if (interval == Interval.Weekly) {
            c = "w";
        } else if (interval == Interval.Monthly) {
            c = "m";
        }
        return days + c + " RSI";
    }

    private String getMACDKey(MACD.Period period) {
        Interval interval = this.getCurrentInterval();
        String c = "d";
        if (interval == Interval.Weekly) {
            c = "w";
        } else if (interval == Interval.Monthly) {
            c = "m";
        }
        return "(" + period.fastPeriod + "," + period.slowPeriod + "," + period.period + ")";
    }

    private String getCCIKey(int days) {
        Interval interval = this.getCurrentInterval();
        String c = "d";
        if (interval == Interval.Weekly) {
            c = "w";
        } else if (interval == Interval.Monthly) {
            c = "m";
        }
        return days + c + " CCI";
    }

    private String getMFIKey(int days) {
        Interval interval = this.getCurrentInterval();
        String c = "d";
        if (interval == Interval.Weekly) {
            c = "w";
        } else if (interval == Interval.Monthly) {
            c = "m";
        }
        return days + c + " MFI";
    }

    private void updateCCI(int days, boolean show) {
        if (this.priceVolumeChart == null) {
            this.priceVolumeChart = this.createPriceVolumeChart(this.priceDataset, this.volumeDataset);
        }
        if (this.candlestickChart == null) {
            this.candlestickChart = this.createCandlestickChart(this.priceOHLCDataset);
        }
        TAEx taEx = TAEx.newInstance(TA.CCI, new Integer(days));
        if (show) {
            if (!this.price_volume_ta_map.containsKey(taEx)) {
                XYDataset dataset = TechnicalAnalysis.createCCI(this.chartDatas, this.getCCIKey(days), days);
                NumberAxis rangeAxis1 = new NumberAxis(GUIBundle.getString("ChartJDialog_CCI"));
                rangeAxis1.setAutoRangeIncludesZero(false);
                rangeAxis1.setLowerMargin(0.4);
                DecimalFormat format = new DecimalFormat("0");
                rangeAxis1.setNumberFormatOverride((NumberFormat)format);
                DateAxis timeAxis = new DateAxis(GUIBundle.getString("ChartJDialog_Date"));
                timeAxis.setLowerMargin(0.02);
                timeAxis.setUpperMargin(0.02);
                XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)rangeAxis1, null);
                XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
                renderer1.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00#")));
                plot.setRenderer(0, (XYItemRenderer)renderer1);
                org.yccheok.jstock.charting.Utils.setPriceSeriesPaint((XYItemRenderer)renderer1);
                this.price_volume_ta_map.put(taEx, plot);
            }
            if (!this.candlestick_ta_map.containsKey(taEx)) {
                try {
                    this.candlestick_ta_map.put(taEx, (XYPlot)this.price_volume_ta_map.get(taEx).clone());
                }
                catch (CloneNotSupportedException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            if (!this.activeTAExs.contains(taEx)) {
                XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
                XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
                CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
                CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
                if (price_volume_ta != null) {
                    cplot0.add(price_volume_ta, 1);
                }
                if (candlestick_ta != null) {
                    cplot1.add(candlestick_ta, 1);
                }
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.priceVolumeChart);
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.candlestickChart);
            }
        } else {
            CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
            CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
            XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
            XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
            if (price_volume_ta != null) {
                cplot0.remove(price_volume_ta);
            }
            if (candlestick_ta != null) {
                cplot1.remove(candlestick_ta);
            }
        }
        if (show && !this.activeTAExs.contains(taEx)) {
            this.activeTAExs.add(taEx);
            JStock.instance().getChartJDialogOptions().add(taEx);
        } else if (!show) {
            this.activeTAExs.remove(taEx);
            JStock.instance().getChartJDialogOptions().remove(taEx);
        }
    }

    private void updateMFI(int days, boolean show) {
        if (this.priceVolumeChart == null) {
            this.priceVolumeChart = this.createPriceVolumeChart(this.priceDataset, this.volumeDataset);
        }
        if (this.candlestickChart == null) {
            this.candlestickChart = this.createCandlestickChart(this.priceOHLCDataset);
        }
        TAEx taEx = TAEx.newInstance(TA.MFI, new Integer(days));
        if (show) {
            if (!this.price_volume_ta_map.containsKey(taEx)) {
                XYDataset dataset = TechnicalAnalysis.createMFI(this.chartDatas, this.getMFIKey(days), days);
                NumberAxis rangeAxis1 = new NumberAxis(GUIBundle.getString("ChartJDialog_MFI"));
                rangeAxis1.setAutoRangeIncludesZero(false);
                rangeAxis1.setLowerMargin(0.4);
                DecimalFormat format = new DecimalFormat("0");
                rangeAxis1.setNumberFormatOverride((NumberFormat)format);
                DateAxis timeAxis = new DateAxis(GUIBundle.getString("ChartJDialog_Date"));
                timeAxis.setLowerMargin(0.02);
                timeAxis.setUpperMargin(0.02);
                XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)rangeAxis1, null);
                XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
                renderer1.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00#")));
                plot.setRenderer(0, (XYItemRenderer)renderer1);
                this.price_volume_ta_map.put(taEx, plot);
            }
            if (!this.candlestick_ta_map.containsKey(taEx)) {
                try {
                    this.candlestick_ta_map.put(taEx, (XYPlot)this.price_volume_ta_map.get(taEx).clone());
                }
                catch (CloneNotSupportedException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            if (!this.activeTAExs.contains(taEx)) {
                XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
                XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
                CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
                CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
                if (price_volume_ta != null) {
                    cplot0.add(price_volume_ta, 1);
                }
                if (candlestick_ta != null) {
                    cplot1.add(candlestick_ta, 1);
                }
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.priceVolumeChart);
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.candlestickChart);
            }
        } else {
            CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
            CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
            XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
            XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
            if (price_volume_ta != null) {
                cplot0.remove(price_volume_ta);
            }
            if (candlestick_ta != null) {
                cplot1.remove(candlestick_ta);
            }
        }
        if (show && !this.activeTAExs.contains(taEx)) {
            this.activeTAExs.add(taEx);
            JStock.instance().getChartJDialogOptions().add(taEx);
        } else if (!show) {
            this.activeTAExs.remove(taEx);
            JStock.instance().getChartJDialogOptions().remove(taEx);
        }
    }

    private void updateRSI(int days, boolean show) {
        if (this.priceVolumeChart == null) {
            this.priceVolumeChart = this.createPriceVolumeChart(this.priceDataset, this.volumeDataset);
        }
        if (this.candlestickChart == null) {
            this.candlestickChart = this.createCandlestickChart(this.priceOHLCDataset);
        }
        TAEx taEx = TAEx.newInstance(TA.RSI, new Integer(days));
        if (show) {
            if (!this.price_volume_ta_map.containsKey(taEx)) {
                XYDataset dataset = TechnicalAnalysis.createRSI(this.chartDatas, this.getRSIKey(days), days);
                NumberAxis rangeAxis1 = new NumberAxis(GUIBundle.getString("ChartJDialog_RSI"));
                rangeAxis1.setAutoRangeIncludesZero(false);
                rangeAxis1.setLowerMargin(0.4);
                DecimalFormat format = new DecimalFormat("0");
                rangeAxis1.setNumberFormatOverride((NumberFormat)format);
                DateAxis timeAxis = new DateAxis(GUIBundle.getString("ChartJDialog_Date"));
                timeAxis.setLowerMargin(0.02);
                timeAxis.setUpperMargin(0.02);
                XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)rangeAxis1, null);
                XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
                renderer1.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00#")));
                plot.setRenderer(0, (XYItemRenderer)renderer1);
                this.price_volume_ta_map.put(taEx, plot);
            }
            if (!this.candlestick_ta_map.containsKey(taEx)) {
                try {
                    this.candlestick_ta_map.put(taEx, (XYPlot)this.price_volume_ta_map.get(taEx).clone());
                }
                catch (CloneNotSupportedException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            if (!this.activeTAExs.contains(taEx)) {
                XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
                XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
                CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
                CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
                if (price_volume_ta != null) {
                    cplot0.add(price_volume_ta, 1);
                }
                if (candlestick_ta != null) {
                    cplot1.add(candlestick_ta, 1);
                }
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.priceVolumeChart);
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.candlestickChart);
            }
        } else {
            CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
            CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
            XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
            XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
            if (price_volume_ta != null) {
                cplot0.remove(price_volume_ta);
            }
            if (candlestick_ta != null) {
                cplot1.remove(candlestick_ta);
            }
        }
        if (show && !this.activeTAExs.contains(taEx)) {
            this.activeTAExs.add(taEx);
            JStock.instance().getChartJDialogOptions().add(taEx);
        } else if (!show) {
            this.activeTAExs.remove(taEx);
            JStock.instance().getChartJDialogOptions().remove(taEx);
        }
    }

    private void showMACDCustomDialog() {
        System.out.println("showMACDCustomDialog");
    }

    private void updateMACD(MACD.Period period, boolean show) {
        if (this.priceVolumeChart == null) {
            this.priceVolumeChart = this.createPriceVolumeChart(this.priceDataset, this.volumeDataset);
        }
        if (this.candlestickChart == null) {
            this.candlestickChart = this.createCandlestickChart(this.priceOHLCDataset);
        }
        TAEx taEx = TAEx.newInstance(TA.MACD, period);
        if (show) {
            if (!this.price_volume_ta_map.containsKey(taEx)) {
                MACD.ChartResult macdChartResult = TechnicalAnalysis.createMACD(this.chartDatas, this.getMACDKey(period), period);
                NumberAxis rangeAxis1 = new NumberAxis(GUIBundle.getString("ChartJDialog_MACD"));
                rangeAxis1.setAutoRangeIncludesZero(false);
                rangeAxis1.setLowerMargin(0.4);
                DecimalFormat format = new DecimalFormat("0.00#");
                rangeAxis1.setNumberFormatOverride((NumberFormat)format);
                DateAxis timeAxis = new DateAxis(GUIBundle.getString("ChartJDialog_Date"));
                timeAxis.setLowerMargin(0.02);
                timeAxis.setUpperMargin(0.02);
                XYPlot plot = new XYPlot(macdChartResult.outMACD, (ValueAxis)timeAxis, (ValueAxis)rangeAxis1, null);
                XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
                renderer1.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00#")));
                plot.setRenderer(0, (XYItemRenderer)renderer1);
                org.yccheok.jstock.charting.Utils.setPriceSeriesPaint((XYItemRenderer)renderer1);
                plot.setDataset(1, macdChartResult.outMACDSignal);
                XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(true, false);
                renderer2.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00#")));
                plot.setRenderer(1, (XYItemRenderer)renderer2);
                plot.setDataset(2, macdChartResult.outMACDHist);
                XYBarRenderer renderer3 = new XYBarRenderer(0.2);
                renderer3.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0,000.00")));
                plot.setRenderer(2, (XYItemRenderer)renderer3);
                this.price_volume_ta_map.put(taEx, plot);
            }
            if (!this.candlestick_ta_map.containsKey(taEx)) {
                try {
                    this.candlestick_ta_map.put(taEx, (XYPlot)this.price_volume_ta_map.get(taEx).clone());
                }
                catch (CloneNotSupportedException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            if (!this.activeTAExs.contains(taEx)) {
                XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
                XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
                CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
                CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
                if (price_volume_ta != null) {
                    cplot0.add(price_volume_ta, 1);
                }
                if (candlestick_ta != null) {
                    cplot1.add(candlestick_ta, 1);
                }
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.priceVolumeChart);
                org.yccheok.jstock.charting.Utils.applyChartThemeEx(this.candlestickChart);
            }
        } else {
            CombinedDomainXYPlot cplot0 = (CombinedDomainXYPlot)this.priceVolumeChart.getPlot();
            CombinedDomainXYPlot cplot1 = (CombinedDomainXYPlot)this.candlestickChart.getPlot();
            XYPlot price_volume_ta = this.price_volume_ta_map.get(taEx);
            XYPlot candlestick_ta = this.candlestick_ta_map.get(taEx);
            if (price_volume_ta != null) {
                cplot0.remove(price_volume_ta);
            }
            if (candlestick_ta != null) {
                cplot1.remove(candlestick_ta);
            }
        }
        if (show && !this.activeTAExs.contains(taEx)) {
            this.activeTAExs.add(taEx);
            JStock.instance().getChartJDialogOptions().add(taEx);
        } else if (!show) {
            this.activeTAExs.remove(taEx);
            JStock.instance().getChartJDialogOptions().remove(taEx);
        }
    }

    private void updateEMA(int days, boolean show) {
        if (this.priceVolumeChart == null) {
            this.priceVolumeChart = this.createPriceVolumeChart(this.priceDataset, this.volumeDataset);
        }
        if (this.candlestickChart == null) {
            this.candlestickChart = this.createCandlestickChart(this.priceOHLCDataset);
        }
        TAEx taEx = TAEx.newInstance(TA.EMA, new Integer(days));
        if (show) {
            TimeSeries timeSeries = null;
            TimeSeriesCollection dataSet = null;
            Integer days_integer = days;
            if (!this.time_series_exponential_moving_average_map.containsKey(days_integer)) {
                timeSeries = TechnicalAnalysis.createEMA(this.chartDatas, this.getEMAKey(days), days);
                dataSet = new TimeSeriesCollection(timeSeries);
                if (this.time_series_exponential_moving_average_map.size() < 20) {
                    this.time_series_exponential_moving_average_map.put(days_integer, timeSeries);
                }
            } else {
                timeSeries = this.time_series_exponential_moving_average_map.get(days_integer);
                dataSet = new TimeSeriesCollection(timeSeries);
            }
            if (!this.activeTAExs.contains(taEx)) {
                ((TimeSeriesCollection)this.priceDataset).addSeries(timeSeries);
            }
            if (!this.activeTAExs.contains(taEx)) {
                Plot main_plot = (Plot)((CombinedDomainXYPlot)this.candlestickChart.getPlot()).getSubplots().get(0);
                XYPlot plot = (XYPlot)main_plot;
                int index = this.getIndex(taEx, this.xydata_index_map);
                this.xydata_index_map.put(taEx, index);
                plot.setDataset(index, (XYDataset)dataSet);
                plot.setRenderer(index, (XYItemRenderer)new StandardXYItemRenderer());
            }
        } else {
            TimeSeries ts = ((TimeSeriesCollection)this.priceDataset).getSeries((Comparable)((Object)this.getEMAKey(days)));
            if (ts != null) {
                ((TimeSeriesCollection)this.priceDataset).removeSeries(ts);
            }
            Plot main_plot = (Plot)((CombinedDomainXYPlot)this.candlestickChart.getPlot()).getSubplots().get(0);
            XYPlot plot = (XYPlot)main_plot;
            Integer integer = this.xydata_index_map.get(taEx);
            if (integer != null) {
                int index = integer;
                plot.setDataset(index, null);
            }
        }
        if (show && !this.activeTAExs.contains(taEx)) {
            this.activeTAExs.add(taEx);
            JStock.instance().getChartJDialogOptions().add(taEx);
        } else if (!show) {
            this.activeTAExs.remove(taEx);
            JStock.instance().getChartJDialogOptions().remove(taEx);
        }
    }

    private ChartChangeListener getChartChangeListner() {
        return new ChartChangeListener(){

            public void chartChanged(ChartChangeEvent event) {
                if (event.getType() == ChartChangeEventType.GENERAL) {
                    ChartJDialog.this.chartLayerUI.updateTraceInfos();
                    ChartJDialog.this.updateHighLowJLabels();
                }
            }
        };
    }

    public XYPlot getPlot() {
        JFreeChart chart = this.chartPanel.getChart();
        CombinedDomainXYPlot cplot = (CombinedDomainXYPlot)chart.getPlot();
        XYPlot plot = (XYPlot)cplot.getSubplots().get(0);
        return plot;
    }

    public XYPlot getPlot(int index) {
        JFreeChart chart = this.chartPanel.getChart();
        CombinedDomainXYPlot cplot = (CombinedDomainXYPlot)chart.getPlot();
        XYPlot plot = (XYPlot)cplot.getSubplots().get(index);
        return plot;
    }

    public int getPlotSize() {
        JFreeChart chart = this.chartPanel.getChart();
        CombinedDomainXYPlot cplot = (CombinedDomainXYPlot)chart.getPlot();
        return cplot.getSubplots().size();
    }

    private void updateSMA(int days, boolean show) {
        if (this.priceVolumeChart == null) {
            this.priceVolumeChart = this.createPriceVolumeChart(this.priceDataset, this.volumeDataset);
        }
        if (this.candlestickChart == null) {
            this.candlestickChart = this.createCandlestickChart(this.priceOHLCDataset);
        }
        TAEx taEx = TAEx.newInstance(TA.SMA, new Integer(days));
        if (show) {
            TimeSeries timeSeries = null;
            TimeSeriesCollection dataSet = null;
            Integer days_integer = days;
            if (!this.time_series_moving_average_map.containsKey(days_integer)) {
                timeSeries = TechnicalAnalysis.createSMA(this.chartDatas, this.getSMAKey(days), days);
                dataSet = new TimeSeriesCollection(timeSeries);
                if (this.time_series_moving_average_map.size() < 20) {
                    this.time_series_moving_average_map.put(days_integer, timeSeries);
                }
            } else {
                timeSeries = this.time_series_moving_average_map.get(days_integer);
                dataSet = new TimeSeriesCollection(timeSeries);
            }
            if (!this.activeTAExs.contains(taEx)) {
                ((TimeSeriesCollection)this.priceDataset).addSeries(timeSeries);
            }
            if (!this.activeTAExs.contains(taEx)) {
                Plot main_plot = (Plot)((CombinedDomainXYPlot)this.candlestickChart.getPlot()).getSubplots().get(0);
                XYPlot plot = (XYPlot)main_plot;
                int index = this.getIndex(taEx, this.xydata_index_map);
                this.xydata_index_map.put(taEx, index);
                plot.setDataset(index, (XYDataset)dataSet);
                plot.setRenderer(index, (XYItemRenderer)new StandardXYItemRenderer());
            }
        } else {
            TimeSeries ts = ((TimeSeriesCollection)this.priceDataset).getSeries((Comparable)((Object)this.getSMAKey(days)));
            if (ts != null) {
                ((TimeSeriesCollection)this.priceDataset).removeSeries(ts);
            }
            Plot main_plot = (Plot)((CombinedDomainXYPlot)this.candlestickChart.getPlot()).getSubplots().get(0);
            XYPlot plot = (XYPlot)main_plot;
            Integer integer = this.xydata_index_map.get(taEx);
            if (integer != null) {
                int index = integer;
                plot.setDataset(index, null);
            }
        }
        if (show && !this.activeTAExs.contains(taEx)) {
            this.activeTAExs.add(taEx);
            JStock.instance().getChartJDialogOptions().add(taEx);
        } else if (!show) {
            this.activeTAExs.remove(taEx);
            JStock.instance().getChartJDialogOptions().remove(taEx);
        }
    }

    public static class TAEx {
        private final TA ta;
        private final Object parameter;

        private TAEx(TA ta, Object parameter) {
            if (ta == null || parameter == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.ta = ta;
            this.parameter = parameter;
        }

        public static TAEx newInstance(TA ta, Object parameter) {
            return new TAEx(ta, parameter);
        }

        public TA getTA() {
            return this.ta;
        }

        public Object getParameter() {
            return this.parameter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TAEx)) {
                return false;
            }
            TAEx taEx = (TAEx)o;
            return (this.ta == null ? taEx.ta == null : this.ta.equals((Object)taEx.ta)) && (this.parameter == null ? taEx.parameter == null : this.parameter.equals(taEx.parameter));
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + (this.ta != null ? this.ta.hashCode() : 0);
            hash = 53 * hash + (this.parameter != null ? this.parameter.hashCode() : 0);
            return hash;
        }
    }

    public static enum Zoom {
        Days7,
        Month1,
        Months3,
        Months6,
        Year1,
        Year5,
        Year10,
        All;

    }

    public static enum Interval {
        Daily,
        Weekly,
        Monthly;

    }

    public static enum Type {
        PriceVolume,
        Candlestick;

    }

    public static enum TA {
        SMA,
        EMA,
        MACD,
        RSI,
        MFI,
        CCI;

    }
}

