/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.news;

import it.sauronsoftware.feed4j.bean.FeedItem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.gui.news.StockNewsContent;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.news.NewsServer;
import org.yccheok.jstock.news.NewsServerFactory;

public class StockNewsJFrame
extends JFrame
implements WindowListener {
    private static final ThreadLocal<SimpleDateFormat> formatterWithYear = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("MMM dd, yyyy");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("MMM dd");
        }
    };
    public StockNewsContent stockNewsContent;
    private final StockInfo stockInfo;
    private final List<NewsServer> newsServers;
    private final Rectangle fullSize;
    private final double sceneWidth;
    private final double sceneHeight;
    private final JFXPanel jfxPanel = new JFXPanel();
    private SplitPane splitPane;
    private Scene scene;
    private final StackPane stackPane = new StackPane();
    private final ProgressIndicator progressIn = new ProgressIndicator();
    private ObservableList<FeedItem> messages_o;
    private ListView<FeedItem> newsListView;
    private NewsTask newsTask;
    private Frame parent;
    private double splitPaneWidth;
    private double splitPaneHeight;
    private String jFrameTitle;
    private final Log log = LogFactory.getLog(StockNewsJFrame.class);

    public StockNewsJFrame(Frame parent, StockInfo stockInfo, String title) {
        super(title);
        this.parent = parent;
        this.parent.addWindowListener(this);
        this.setIconImage(parent.getIconImage());
        this.stockInfo = stockInfo;
        Country country = Utils.toCountry(this.stockInfo.code);
        this.newsServers = NewsServerFactory.getNewsServers(country);
        this.fullSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.sceneWidth = this.fullSize.width / 2;
        this.sceneHeight = this.fullSize.height;
        this.setSize((int)this.sceneWidth, (int)this.sceneHeight);
        this.initComponents();
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.toFront();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.setAlwaysOnTop(false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.setVisible(true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void formWindowClosing(WindowEvent evt) {
        NewsTask task = this.newsTask;
        if (task != null) {
            task.cancel(true);
        }
        this.parent.removeWindowListener(this);
        this.dispose();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setAutoRequestFocus(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StockNewsJFrame.this.formWindowClosing(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                NewsTask task = StockNewsJFrame.this.newsTask;
                if (task != null) {
                    task.cancel(true);
                }
            }

            @Override
            public void windowDeiconified(WindowEvent evt) {
            }

            @Override
            public void windowIconified(WindowEvent evt) {
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                StockNewsJFrame.this.splitPane = new SplitPane();
                StockNewsJFrame.this.scene = new Scene((Parent)StockNewsJFrame.this.splitPane);
                StockNewsJFrame.this.scene.getStylesheets().add((Object)StockNewsJFrame.class.getResource("StockNewsJFrame.css").toExternalForm());
                StockNewsJFrame.this.jfxPanel.setScene(StockNewsJFrame.this.scene);
                StockNewsJFrame.this.messages_o = FXCollections.observableArrayList();
                StockNewsJFrame.this.newsListView = new ListView(StockNewsJFrame.this.messages_o);
                StockNewsJFrame.this.newsListView.setId("news-listview");
                StockNewsJFrame.this.stackPane.setId("parent-stackPane");
                StockNewsJFrame.this.stackPane.getChildren().addAll((Object[])new Node[]{StockNewsJFrame.this.newsListView, StockNewsJFrame.this.progressIn});
                StockNewsJFrame.this.splitPane.getItems().add((Object)StockNewsJFrame.this.stackPane);
                SplitPane.setResizableWithParent((Node)StockNewsJFrame.this.stackPane, (Boolean)Boolean.FALSE);
                StockNewsJFrame.this.progressIn.setMaxWidth(100.0);
                StockNewsJFrame.this.progressIn.setMaxHeight(100.0);
                StockNewsJFrame.this.progressIn.setVisible(true);
                StockNewsJFrame.this.newsListView.setVisible(true);
                StockNewsJFrame.this.newsListView.setCellFactory((Callback)new Callback<ListView<FeedItem>, ListCell<FeedItem>>(){

                    public ListCell<FeedItem> call(ListView<FeedItem> list) {
                        return new DisplayNewsCard();
                    }
                });
                StockNewsJFrame.this.newsListView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        if (event.getClickCount() >= 1) {
                            FeedItem msg = (FeedItem)StockNewsJFrame.this.newsListView.getSelectionModel().getSelectedItem();
                            if (msg == null) {
                                return;
                            }
                            URL link = msg.getLink();
                            if (link == null || link.getHost() == null) {
                                return;
                            }
                            if (StockNewsJFrame.this.stockNewsContent == null) {
                                StockNewsJFrame.this.stackPane.setPrefWidth(StockNewsJFrame.this.stackPane.getWidth());
                                StockNewsJFrame.this.stackPane.setMaxWidth(StockNewsJFrame.this.stackPane.getWidth());
                                StockNewsJFrame.this.stackPane.setMinWidth(StockNewsJFrame.this.stackPane.getWidth() / 5.0);
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            StockNewsJFrame.this.setSize(((StockNewsJFrame)StockNewsJFrame.this).fullSize.width, ((StockNewsJFrame)StockNewsJFrame.this).fullSize.height);
                                            Insets in = StockNewsJFrame.this.getInsets();
                                            StockNewsJFrame.this.jfxPanel.setSize(StockNewsJFrame.this.getWidth() - in.left - in.right, StockNewsJFrame.this.jfxPanel.getHeight());
                                            Insets in2 = StockNewsJFrame.this.jfxPanel.getInsets();
                                            StockNewsJFrame.this.splitPaneWidth = StockNewsJFrame.this.jfxPanel.getWidth() - in2.left - in2.right;
                                            StockNewsJFrame.this.splitPaneHeight = StockNewsJFrame.this.jfxPanel.getHeight() - in2.top - in2.bottom;
                                        }
                                    });
                                }
                                catch (InterruptedException | InvocationTargetException ex) {
                                    StockNewsJFrame.this.log.error(null, (Throwable)ex);
                                }
                                StockNewsJFrame.this.splitPane.resize(StockNewsJFrame.this.splitPaneWidth, StockNewsJFrame.this.splitPaneHeight);
                                StockNewsJFrame.this.stockNewsContent = new StockNewsContent();
                                StockNewsJFrame.this.splitPane.getItems().add((Object)StockNewsJFrame.this.stockNewsContent.tabPane);
                                StockNewsJFrame.this.splitPane.setDividerPositions(new double[]{0.5});
                                StockNewsJFrame.this.stockNewsContent.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

                                    public void changed(ObservableValue<? extends Tab> observable, Tab oldTab, Tab newTab) {
                                        int i = StockNewsJFrame.this.stockNewsContent.tabPane.getSelectionModel().getSelectedIndex();
                                        if (i < 0) {
                                            return;
                                        }
                                        StockNewsJFrame.this.jFrameTitle = (String)StockNewsJFrame.this.stockNewsContent.tabsInfo.get((int)i).second;
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                StockNewsJFrame.this.setTitle(StockNewsJFrame.this.jFrameTitle);
                                            }
                                        });
                                    }
                                });
                            }
                            StockNewsJFrame.this.stockNewsContent.addNewsTab(link, StringEscapeUtils.unescapeHtml((String)msg.getTitle()));
                        }
                    }
                });
                StockNewsJFrame.this.retrieveNewsInBackground();
            }
        });
        this.add((Component)this.jfxPanel, "Center");
        this.setVisible(true);
    }

    public void retrieveNewsInBackground() {
        if (this.newsServers == null) {
            return;
        }
        if (this.newsTask != null) {
            throw new RuntimeException("Being called more than once");
        }
        this.newsTask = new NewsTask(this.newsServers);
        this.newsTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                List allMessages = (List)StockNewsJFrame.this.newsTask.getValue();
                StockNewsJFrame.this.messages_o.addAll((Collection)allMessages);
                StockNewsJFrame.this.stackPane.getChildren().remove((Object)StockNewsJFrame.this.progressIn);
            }
        });
        new Thread((Runnable)((Object)this.newsTask)).start();
    }

    private boolean isSameDay(Date date0, Date date1) {
        return date0.getDate() == date1.getDate() && date0.getMonth() == date1.getMonth() && date0.getYear() == date1.getYear();
    }

    private boolean isSameYear(Date date0, Date date1) {
        return date0.getYear() == date1.getYear();
    }

    private String toHumanReadableDate(Date date) {
        Date today = new Date();
        if (this.isSameDay(today, date)) {
            long timestampDiff = today.getTime() - date.getTime();
            if (timestampDiff <= 0L) {
                return GUIBundle.getString("StockNewsJFrame_Now");
            }
            if (timestampDiff < 3600000L) {
                int minutesAgo = (int)((double)timestampDiff / 60.0 / 1000.0);
                if (minutesAgo > 1) {
                    return MessageFormat.format(GUIBundle.getString("StockNewsJFrame_MinutesAgo_template"), minutesAgo);
                }
                return MessageFormat.format(GUIBundle.getString("StockNewsJFrame_MinuteAgo_template"), minutesAgo);
            }
            if (timestampDiff < 86400000L) {
                int hoursAgo = (int)((double)timestampDiff / 60.0 / 60.0 / 1000.0);
                if (hoursAgo > 1) {
                    return MessageFormat.format(GUIBundle.getString("StockNewsJFrame_HoursAgo_template"), hoursAgo);
                }
                return MessageFormat.format(GUIBundle.getString("StockNewsJFrame_HourAgo_template"), hoursAgo);
            }
        } else if (this.isSameYear(today, date)) {
            return formatter.get().format(date);
        }
        return formatterWithYear.get().format(date);
    }

    private class NewsTask
    extends Task<List<FeedItem>> {
        private final List<NewsServer> newsServers;

        public NewsTask(List<NewsServer> servers) {
            this.newsServers = servers;
        }

        protected List<FeedItem> call() {
            ArrayList<FeedItem> allMessages = new ArrayList<FeedItem>();
            int serverCnt = 0;
            while (serverCnt < this.newsServers.size()) {
                List<FeedItem> newMessages = this.newsServers.get(serverCnt++).getMessages(StockNewsJFrame.this.stockInfo);
                if (this.isCancelled()) {
                    return null;
                }
                if (newMessages.isEmpty()) continue;
                allMessages.addAll(newMessages);
            }
            if (this.isCancelled()) {
                return null;
            }
            Collections.sort(allMessages, new Comparator<FeedItem>(){

                @Override
                public int compare(FeedItem lhs, FeedItem rhs) {
                    return -lhs.getPubDate().compareTo(rhs.getPubDate());
                }
            });
            return allMessages;
        }
    }

    private class DisplayNewsCard
    extends ListCell<FeedItem> {
        private DisplayNewsCard() {
        }

        public void updateItem(FeedItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                BorderPane newsBox = new BorderPane();
                newsBox.setMaxWidth(StockNewsJFrame.this.sceneWidth - 20.0);
                newsBox.getStyleClass().add((Object)"item-border-pane");
                String msgTitle = StringEscapeUtils.unescapeHtml((String)item.getTitle());
                Text firstText = new Text(msgTitle.substring(0, 1));
                Text secondText = new Text(msgTitle.substring(1));
                firstText.getStyleClass().add((Object)"item-title-text-1");
                secondText.getStyleClass().add((Object)"item-title-text-2");
                TextFlow titleTextFlow = new TextFlow(new Node[]{firstText, secondText});
                titleTextFlow.setMaxWidth(StockNewsJFrame.this.sceneWidth - 60.0);
                newsBox.setTop((Node)titleTextFlow);
                if (item.getDescriptionAsText() != null) {
                    Text descText = new Text(item.getDescriptionAsText());
                    descText.setWrappingWidth(StockNewsJFrame.this.sceneWidth - 60.0);
                    descText.getStyleClass().add((Object)"item-desc-text");
                    BorderPane.setMargin((Node)descText, (javafx.geometry.Insets)new javafx.geometry.Insets(10.0, 0.0, 0.0, 0.0));
                    BorderPane.setAlignment((Node)descText, (Pos)Pos.CENTER_LEFT);
                    newsBox.setCenter((Node)descText);
                }
                String pubDateDiff = StockNewsJFrame.this.toHumanReadableDate(item.getPubDate());
                Label pubDate = new Label(pubDateDiff);
                pubDate.getStyleClass().add((Object)"item-date-label");
                newsBox.setBottom((Node)pubDate);
                BorderPane.setAlignment((Node)pubDate, (Pos)Pos.BOTTOM_RIGHT);
                this.setGraphic((Node)newsBox);
            }
        }
    }
}

