/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.news;

import it.sauronsoftware.feed4j.bean.FeedItem;
import it.sauronsoftware.feed4j.bean.RawElement;
import it.sauronsoftware.feed4j.bean.RawNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.news.GoogleFinanceNewsServer;
import org.yccheok.jstock.news.GoogleSearchNewsServer;
import org.yccheok.jstock.news.NewsServer;
import org.yccheok.jstock.news.NewsServerFactory;
import org.yccheok.jstock.news.NewsSource;
import org.yccheok.jstock.news.YahooFinanceNewsServer;

public class Utils {
    private static final Map<Country, NewsSource> defaultNewsSources = new EnumMap<Country, NewsSource>(Country.class);
    private static final Map<Class<? extends NewsServer>, NewsSource> classToNewsSourceMap = new HashMap<Class<? extends NewsServer>, NewsSource>();
    private static final List<String> paidNewsUrls = new ArrayList<String>();
    private static final ThreadLocal<SimpleDateFormat> FORMATTER;
    private static final Log log;

    private Utils() {
    }

    public static List<String> getPaidNewsUrls() {
        return paidNewsUrls;
    }

    public static NewsSource getDefaultNewsSource(Country country) {
        assert (defaultNewsSources.containsKey((Object)country));
        return defaultNewsSources.get((Object)country);
    }

    public static Set<NewsSource> getSupportedNewsSources(Country country) {
        List<NewsServer> newsServers = NewsServerFactory.getNewsServers(country);
        EnumSet<NewsSource> set = EnumSet.noneOf(NewsSource.class);
        for (NewsServer newsServer : newsServers) {
            NewsSource newsSource = classToNewsSourceMap.get(newsServer.getClass());
            if (newsSource == null) continue;
            set.add(newsSource);
        }
        return set;
    }

    public static Date getProperPubDate(FeedItem message) {
        int ej = message.getNodeCount();
        for (int j = 0; j < ej; ++j) {
            RawNode node = message.getNode(j);
            if (!(node instanceof RawElement)) continue;
            RawElement element = (RawElement)node;
            String name = element.getName();
            String value = element.getValue();
            if (value == null || !name.equals("pubDate")) continue;
            try {
                return FORMATTER.get().parse(value);
            }
            catch (ParseException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        return null;
    }

    static {
        defaultNewsSources.put(Country.Argentina, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Australia, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Austria, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Belgium, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Brazil, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Canada, NewsSource.Yahoo);
        defaultNewsSources.put(Country.China, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Denmark, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Finland, NewsSource.Google);
        defaultNewsSources.put(Country.France, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Germany, NewsSource.Yahoo);
        defaultNewsSources.put(Country.HongKong, NewsSource.Yahoo);
        defaultNewsSources.put(Country.India, NewsSource.Google);
        defaultNewsSources.put(Country.Indonesia, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Israel, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Italy, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Japan, NewsSource.Google);
        defaultNewsSources.put(Country.Korea, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Malaysia, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Netherlands, NewsSource.Yahoo);
        defaultNewsSources.put(Country.NewZealand, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Norway, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Portugal, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Russia, NewsSource.Google);
        defaultNewsSources.put(Country.SaudiArabia, NewsSource.Google);
        defaultNewsSources.put(Country.Singapore, NewsSource.Yahoo);
        defaultNewsSources.put(Country.SouthAfrica, NewsSource.Google);
        defaultNewsSources.put(Country.Spain, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Sweden, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Switzerland, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Taiwan, NewsSource.Yahoo);
        defaultNewsSources.put(Country.Thailand, NewsSource.Google);
        defaultNewsSources.put(Country.Turkey, NewsSource.Google);
        defaultNewsSources.put(Country.UnitedKingdom, NewsSource.Yahoo);
        defaultNewsSources.put(Country.UnitedState, NewsSource.Yahoo);
        classToNewsSourceMap.put(GoogleFinanceNewsServer.class, NewsSource.Google);
        classToNewsSourceMap.put(GoogleSearchNewsServer.class, NewsSource.GoogleSearch);
        classToNewsSourceMap.put(YahooFinanceNewsServer.class, NewsSource.Yahoo);
        paidNewsUrls.add("www.ft.com");
        FORMATTER = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
            }
        };
        log = LogFactory.getLog(Utils.class);
    }
}

