/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.yccheok.jstock.engine.Country;

public class PortfolioInfo {
    public final Country country;
    public final String name;
    public final int size;

    private PortfolioInfo(Country country, String name, int size) {
        this.country = country;
        this.name = name;
        this.size = size;
    }

    public static PortfolioInfo newInstance(Country country, String name, int size) {
        return new PortfolioInfo(country, name, size);
    }

    public PortfolioInfo setCountry(Country country) {
        return new PortfolioInfo(country, this.name, this.size);
    }

    public PortfolioInfo setName(String name) {
        return new PortfolioInfo(this.country, name, this.size);
    }

    public PortfolioInfo setSize(int size) {
        return new PortfolioInfo(this.country, this.name, size);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.country.hashCode();
        result = 31 * result + this.name.toLowerCase().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PortfolioInfo)) {
            return false;
        }
        PortfolioInfo portfolioInfo = (PortfolioInfo)o;
        return this.country.equals((Object)portfolioInfo.country) && this.name.toLowerCase().equals(portfolioInfo.name.toLowerCase());
    }

    public String toString() {
        return PortfolioInfo.class.getSimpleName() + "[" + (Object)((Object)this.country) + ", " + this.name + ", " + this.size + "]";
    }
}

