/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.yccheok.jstock.trading.api.Country;

public class CountryUtils {
    private final Map<String, String> countryMap = new HashMap<String, String>();
    private static final CountryUtils INSTANCE = new CountryUtils();

    private CountryUtils() {
        String[] codes;
        String jstockLang = Locale.getDefault().getISO3Language();
        for (String code2letter : codes = Locale.getISOCountries()) {
            Locale locale = new Locale(jstockLang, code2letter);
            String code3letter = locale.getISO3Country().toUpperCase();
            String translatedName = locale.getDisplayCountry();
            this.countryMap.put(code3letter, translatedName);
        }
    }

    public static CountryUtils getInstance() {
        return INSTANCE;
    }

    public String getTranslatedName(String code3Letter) {
        if (this.countryMap.containsKey(code3Letter)) {
            return this.countryMap.get(code3Letter);
        }
        return "";
    }

    public List<Country> getCountryList() {
        ArrayList<Country> countries = new ArrayList<Country>();
        for (Map.Entry<String, String> entry : this.countryMap.entrySet()) {
            String code3Letter = entry.getKey();
            String translatedName = entry.getValue();
            Country country = new Country(code3Letter, translatedName);
            countries.add(country);
        }
        Collections.sort(countries);
        return countries;
    }
}

