/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.SessionManager;

public class InstrumentManager {
    private static final Log log = LogFactory.getLog(InstrumentManager.class);

    private InstrumentManager() {
    }

    public static List<Instrument> searchByPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return null;
        }
        String url_params = "symbol=" + pattern + "&name=" + pattern;
        return InstrumentManager.search(url_params);
    }

    public static List<Instrument> searchExactSymbol(String symbol) {
        if (symbol == null || symbol.isEmpty()) {
            return null;
        }
        String url_params = "symbols=" + symbol;
        return InstrumentManager.search(url_params);
    }

    public static List<Instrument> search(String url_params) {
        String url = "instruments?";
        ArrayList<String> INPUT_FIELDS = new ArrayList<String>(Arrays.asList("symbol", "symbols", "name", "tag"));
        ArrayList<String> OUTPUT_FIELDS = new ArrayList<String>(Arrays.asList("instrumentID", "name", "category", "currencyID", "exchangeID", "limitStatus", "instrumentTypeID", "isLongOnly", "marginCurrencyID", "orderSizeMax", "orderSizeMin", "orderSizeStep", "rateAsk", "rateBid", "rateHigh", "rateLow", "rateOpen", "ratePrecision", "symbol", "tags", "tradeStatus", "tradingHours", "uom", "urlImage", "urlInvestor", "sector", "longOnly", "lastTrade", "priorClose", "close"));
        HttpRespond respond = Http.get(url = url.concat(url_params), SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"Search Instrument error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            Map result = (Map)new Gson().fromJson(body, HashMap.class);
            ApiError error = ApiError.getError(result);
            log.error((Object)("Search Instrument error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        ArrayList<Instrument> instrumentList = new ArrayList<Instrument>();
        List result = (List)new Gson().fromJson(body, ArrayList.class);
        for (Map ins : result) {
            Instrument instrument = new Instrument(ins);
            instrumentList.add(instrument);
        }
        return instrumentList;
    }

    public static List<Map<String, String>> listAllInstruments() {
        HttpRespond respond = Http.get("instruments?tradeStatus=1", SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        List result = (List)new Gson().fromJson(body, ArrayList.class);
        return result;
    }
}

