/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.MarketData;

public class MarketDataManager {
    private static final Log log = LogFactory.getLog(MarketDataManager.class);

    private MarketDataManager() {
    }

    public static List<MarketData> getMarketData(ArrayList<String> symbolList, boolean lastTradeOnly) {
        HttpRespond respond;
        ArrayList<String> OUTPUT_FIELDS = new ArrayList<String>(Arrays.asList("symbol", "bid", "ask", "lastTrade"));
        String symbols = String.join((CharSequence)",", symbolList);
        String url = "quotes?symbols=" + symbols;
        if (lastTradeOnly) {
            url = url + "&lastTrade=true";
        }
        if ((respond = Http.get(url, null)) == null) {
            log.error((Object)"Get Market Data error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            Map result = (Map)new Gson().fromJson(body, HashMap.class);
            ApiError error = ApiError.getError(result);
            log.error((Object)("Get Market Data error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        ArrayList<MarketData> marketDataList = new ArrayList<MarketData>();
        List result = (List)new Gson().fromJson(body, ArrayList.class);
        for (Map data : result) {
            marketDataList.add(new MarketData(data));
        }
        return marketDataList;
    }

    public static Map<String, Object> getMarketDataAsText(ArrayList<String> symbolList, boolean lastTradeOnly) {
        HttpRespond respond;
        if (symbolList == null || symbolList.isEmpty()) {
            return null;
        }
        String symbols = String.join((CharSequence)",", symbolList);
        String url = "quotes?symbols=" + symbols;
        if (lastTradeOnly) {
            url = url + "&lastTrade=true";
        }
        if ((respond = Http.getPlainText(url)) == null) {
            log.error((Object)"Get Market Data (Text) error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            log.error((Object)("Get Market Data (Text) error, code: " + statusCode));
            return null;
        }
        String[] data = body.split("\\|");
        if (data.length < 11) {
            log.error((Object)("Get Market Data (Text) response error: " + body));
            return null;
        }
        String timestamp = data[0];
        String marketOpen = data[1];
        MarketState marketState = marketOpen.equals(MarketState.OPEN.value) ? MarketState.OPEN : MarketState.CLOSED;
        ArrayList<MarketData> marketDataList = new ArrayList<MarketData>();
        for (int i = 10; i < data.length; ++i) {
            MarketData marketData;
            String symbol;
            String stock = data[i];
            String[] item = stock.split("\\,");
            int size = item.length;
            if (lastTradeOnly) {
                if (size < 2) {
                    log.warn((Object)("Get Market Data (Text) - lastTradeOnly, wrong format: " + stock));
                    continue;
                }
                symbol = item[0];
                Double last = Double.parseDouble(item[1]);
                marketData = new MarketData(symbol, last);
            } else {
                if (size < 3) {
                    log.warn((Object)("Get Market Data (Text) - Bid + Ask, wrong format: " + stock));
                    continue;
                }
                symbol = item[0];
                Double bid = Double.parseDouble(item[1]);
                Double ask = Double.parseDouble(item[2]);
                marketData = new MarketData(symbol, bid, ask);
            }
            marketDataList.add(marketData);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("marketState", (Object)marketState);
        result.put("timestamp", timestamp);
        result.put("data", marketDataList);
        return result;
    }

    public static enum MarketState {
        OPEN("1"),
        CLOSED("2");

        public final String value;

        private MarketState(String value) {
            this.value = value;
        }
    }
}

