/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.trading.api.Account;
import org.yccheok.jstock.trading.api.AccountManager;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.User;
import org.yccheok.jstock.trading.api.UserManager;

public class SessionManager {
    private static final Log log = LogFactory.getLog(SessionManager.class);
    private User user = null;
    private String sessionKey = null;
    private String username;
    private String password;
    private static final SessionManager INSTANCE = new SessionManager();

    private SessionManager() {
    }

    public static SessionManager getInstance() {
        return INSTANCE;
    }

    public User getUser() {
        return this.user;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public Pair<String, String> getUsernamePassword() {
        return new Pair<String, String>(this.username, this.password);
    }

    private Pair<String, String> _login(String username, String password) {
        Pair<Map<String, Object>, String> result = SessionManager.createSession(username, password);
        Map sessionMap = (Map)result.first;
        String error = (String)result.second;
        if (error != null) {
            this.sessionKey = null;
            return new Pair<Object, String>(null, error);
        }
        this.sessionKey = sessionMap.get("sessionKey").toString();
        Map<String, Object> userMap = UserManager.getUser(sessionMap.get("userID").toString());
        if (userMap == null) {
            return new Pair<Object, String>(null, ApiError.commonMsg());
        }
        this.user = new User(sessionMap, userMap);
        return new Pair<String, Object>(this.sessionKey, null);
    }

    public Pair<String, String> login(String username, String password, String activeAccID) {
        this.username = username;
        this.password = password;
        Pair<String, String> loginPair = this._login(username, password);
        String error = (String)loginPair.second;
        if (error != null) {
            return loginPair;
        }
        if (activeAccID == null || activeAccID.isEmpty()) {
            this.setDefaultActiveAcc();
        } else {
            this.setActiveAcc(activeAccID);
        }
        return new Pair<String, Object>(this.sessionKey, null);
    }

    public Pair<String, String> relogin(String activeAccID) {
        return this.login(this.username, this.password, activeAccID);
    }

    public boolean loginFromSession(String sessionKey) {
        Map<String, Object> sessionMap = SessionManager.getSession(sessionKey);
        if (sessionMap == null) {
            return false;
        }
        this.sessionKey = sessionMap.get("sessionKey").toString();
        Map<String, Object> userMap = UserManager.getUser(sessionMap.get("userID").toString());
        if (userMap == null) {
            return false;
        }
        this.user = new User(sessionMap, userMap);
        this.setDefaultActiveAcc();
        return true;
    }

    private void setDefaultActiveAcc() {
        Account active = null;
        if (!this.user.getLiveAccounts().isEmpty()) {
            active = this.user.getLiveAccounts().get(0);
        } else if (!this.user.getPracticeAccounts().isEmpty()) {
            active = this.user.getPracticeAccounts().get(0);
        }
        if (active != null) {
            this.user.setActiveAccount(active);
        }
    }

    private void setActiveAcc(String accID) {
        Account active = null;
        for (Account acc : this.user.getAccounts()) {
            if (!acc.accountID.equals(accID)) continue;
            active = acc;
            break;
        }
        if (active != null) {
            this.user.setActiveAccount(active);
        }
    }

    public String createPracticeAccIfNotExist() {
        if (this.user.getPracticeAccounts().isEmpty()) {
            return AccountManager.createPracticeAccFromUser(this.user.userID);
        }
        return null;
    }

    public static Pair<Map<String, Object>, String> createSession(String userName, String password) {
        String url = "userSessions";
        ArrayList<String> INPUT_FIELDS = new ArrayList<String>(Arrays.asList("username", "password", "appTypeID", "appVersion", "languageID", "osType", "osVersion", "scrRes", "ipAddress"));
        ArrayList<String> OUTPUT_FIELDS = new ArrayList<String>(Arrays.asList("appTypeID", "commissionRate", "loginState", "referralCode", "sessionKey", "userID", "wlpID", "accounts", "instruments"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", userName);
        params.put("password", password);
        params.put("appTypeID", "26");
        params.put("appVersion", "0.1");
        params.put("languageID", "en_US");
        params.put("osType", "iOS");
        params.put("osVersion", "iOS 9.1");
        params.put("scrRes", "1920x1080");
        params.put("ipAddress", "1.1.1.1");
        HttpRespond respond = Http.post(url, params, null);
        if (respond == null) {
            log.error((Object)"Create Session error - Http");
            return new Pair<Object, String>(null, ApiError.commonMsg());
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Create Session error, code: " + error.code + ", message: " + error.message));
            return new Pair<Object, String>(null, error.getMsg());
        }
        return new Pair<Map, Object>(result, null);
    }

    public static Map<String, Object> getSession(String sessionKey) {
        HttpRespond respond = Http.get("userSessions/" + sessionKey, sessionKey);
        if (respond == null) {
            log.error((Object)"Get Session error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Get Session error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        double loginState = (Double)result.get("loginState");
        if (Double.compare(loginState, 1.0) != 0) {
            log.error((Object)("Get Session error -- not loggedIn, loginState : " + loginState));
            return null;
        }
        return result;
    }

    public static Boolean cancelSession() {
        String sessionKey = SessionManager.getInstance().getSessionKey();
        HttpRespond respond = Http.delete("userSessions/" + sessionKey, sessionKey);
        if (respond == null) {
            log.error((Object)"Cancel Session error - Http");
            return false;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Cancel Session error, code: " + error.code + ", message: " + error.message));
            return false;
        }
        return true;
    }

    public static enum AccStatus {
        PENDING(1.0, "Pending"),
        OPEN(2.0, "Open"),
        OPEN_NO_NEW_TRADES(3.0, "Open no new trades"),
        CLOSED(9.0, "Closed");

        public final Double value;
        public final String code;

        private AccStatus(Double value, String code) {
            this.value = value;
            this.code = code;
        }
    }

    public static enum AccType {
        PRACTICE(1.0, "practice"),
        LIVE(2.0, "live");

        public final Double value;
        public final String code;

        private AccType(Double value, String code) {
            this.value = value;
            this.code = code;
        }
    }
}

