/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.SessionManager;

public class SettingManager {
    private static final Log log = LogFactory.getLog(SettingManager.class);

    private SettingManager() {
    }

    public static Map<String, Object> getSetting(String key) {
        String url = "users/" + SessionManager.getInstance().getUser().userID + "/settings/" + key;
        HttpRespond respond = Http.get(url, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        return result;
    }

    public static List<Map<String, Object>> listAllSettings() {
        String url = "users/" + SessionManager.getInstance().getUser().userID + "/settings";
        HttpRespond respond = Http.get(url, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        List result = (List)new Gson().fromJson(body, ArrayList.class);
        return result;
    }

    public static Map<String, Object> createSetting(Map<String, String> args) {
        String userID = SessionManager.getInstance().getUser().userID;
        String url = "users/" + userID + "/settings";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userID", userID);
        params.put("key", args.get("key"));
        params.put("value", args.get("value"));
        HttpRespond respond = Http.post(url, params, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        return result;
    }

    public static Boolean deleteSetting(String key) {
        String url = "users/" + SessionManager.getInstance().getUser().userID + "/settings/";
        HttpRespond respond = Http.delete(url + key, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        return respond.statusCode == 200;
    }
}

