/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.SessionManager;

public class UserManager {
    private static final Log log = LogFactory.getLog(UserManager.class);

    private UserManager() {
    }

    public static Map<String, Object> getUser(String userID) {
        ArrayList<String> OUTPUT_FIELDS = new ArrayList<String>(Arrays.asList("commissionRate", "emailAddress1", "languageID", "referralCode", "sessionKey", "username", "wlpID", "status", "lastLoginWhen", "ackSignedWhen", "addressLine1", "avatarUrl", "city", "coinBalance", "countryID", "displayName", "firstName", "lastName", "gender", "phoneHome", "stateProvince", "userID", "zipPostalCode", "usCitizen", "updatedWhen", "rebateCfdValue", "rebateEquityValue", "rebateFxValue", "brandAmbassador", "employerBusiness", "employmentStatus", "statementPrint", "confirmPrint", "citizenship", "createdWhen", "addressProofReviewWhen", "approvedWhen", "approvedBy", "kycWhen", "pictureReviewBy", "pictureReviewWhen", "annualIncome", "userAttributes"));
        HttpRespond respond = Http.get("users/" + userID, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"Get User error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Get User error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        return result;
    }

    public static Boolean updateUser(String userID, Map<String, Object> args) {
        ArrayList<String> updateUserFields = new ArrayList<String>(Arrays.asList("emailAddress1", "addressLine1", "addressLine2", "city", "countryID", "firstName", "lastName", "languageID", "phoneHome", "phoneWork", "phoneMobile", "stateProvince", "zipPostalCode"));
        for (String k : updateUserFields) {
            ArrayList<String> languages;
            if (!args.containsKey(k)) continue;
            String v = args.get(k).toString();
            if (!k.equals("languageID") || (languages = new ArrayList<String>(Arrays.asList("en_US", "zh_CN", "es_ES", "pt_BR", "ja_JP"))).contains(v)) continue;
            log.warn((Object)("Update User - invalid language: " + v + ", default to en_US"));
            v = "en_US";
            args.put("languageID", v);
        }
        HttpRespond respond = Http.put("users/" + userID, args, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"Update User error - Http");
            return null;
        }
        return respond.statusCode == 200;
    }

    public static VerificationStatus userStatus(String userID) {
        ArrayList<String> OUTPUT_FIELDS = new ArrayList<String>(Arrays.asList("accountStatus", "accountReasonID", "accountReason", "accountApprovedWhen", "addressProofReviewWhen", "addressProofStatus", "addressProofReasonID", "addressProofReason", "idReviewWhen", "idStatus", "idReasonID", "idReason", "kycWhen", "kycStatus"));
        HttpRespond respond = Http.get("users/" + userID + "/status", SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"User Status error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("User Status error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        double accStatus = (Double)result.get("accountStatus");
        double addressProofStatus = (Double)result.get("addressProofStatus");
        double idStatus = (Double)result.get("idStatus");
        double kycStatus = (Double)result.get("kycStatus");
        VerificationStatus status = null;
        if (addressProofStatus == VerificationStatus.NOT_SUBMITTED.value || idStatus == VerificationStatus.NOT_SUBMITTED.value || addressProofStatus == VerificationStatus.REJECTED.value || idStatus == VerificationStatus.REJECTED.value) {
            status = VerificationStatus.NOT_SUBMITTED;
        } else if (accStatus == VerificationStatus.PENDING.value) {
            status = VerificationStatus.PENDING;
        } else if (accStatus == VerificationStatus.APPROVED.value) {
            status = VerificationStatus.APPROVED;
        } else if (accStatus == VerificationStatus.REJECTED.value) {
            status = VerificationStatus.REJECTED;
        } else if (accStatus == VerificationStatus.REVOKED.value) {
            status = VerificationStatus.REVOKED;
        } else if (accStatus == VerificationStatus.CLOSED.value) {
            status = VerificationStatus.CLOSED;
        }
        log.info((Object)("User Status -   accountStatus: " + accStatus + ", addressProofStatus: " + addressProofStatus + ", idStatus: " + idStatus + ", kycStatus: " + kycStatus + ", verification status: " + (status == null ? "" : status)));
        return status;
    }

    public static String forgotPassword(String username) {
        String url = "users/passwords";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", username);
        HttpRespond respond = Http.post(url, params, null);
        if (respond == null) {
            log.error((Object)"Forgot Password error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Forgot Password error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        String resetID = result.get("passwordResetID").toString();
        log.info((Object)("Forgot password, passwordResetID: " + resetID));
        return resetID;
    }

    public static Boolean resetPassword(String resetID, String code, String password) {
        String url = "users/passwords/" + resetID;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("passwordResetID", resetID);
        params.put("code", code);
        params.put("password", password);
        HttpRespond respond = Http.put(url, params, null);
        if (respond == null) {
            log.error((Object)"Reset Password error - Http");
            return false;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Reset Password error, code: " + error.code + ", message: " + error.message));
            return false;
        }
        return true;
    }

    public static Boolean checkUsernameAvailability(String username) {
        HttpRespond respond = Http.get("users?username=" + username, null);
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        return statusCode == 404;
    }

    public static enum VerificationStatus {
        NOT_SUBMITTED(0.0),
        PENDING(1.0),
        APPROVED(2.0),
        REJECTED(3.0),
        REVOKED(4.0),
        CLOSED(5.0);

        public final Double value;

        private VerificationStatus(Double value) {
            this.value = value;
        }
    }
}

