/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j.html;

import it.sauronsoftware.feed4j.html.HTMLEntities;
import java.io.StringReader;
import org.apache.html.dom.HTMLDocumentImpl;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HTMLOptimizer {
    private static final Tag[] TAGS = new Tag[]{new Tag("strong", new Attribute[0]), new Tag("cite", new Attribute[0]), new Tag("em", new Attribute[0]), new Tag("p", new Attribute[0]), new Tag("div", new Attribute[0]), new Tag("br", new Attribute[0]), new Tag("ul", new Attribute[0]), new Tag("ol", new Attribute[0]), new Tag("li", new Attribute[0]), new Tag("table", new Attribute[0]), new Tag("tr", new Attribute[0]), new Tag("td", new Attribute[0]), new Tag("th", new Attribute[0]), new Tag("img", new Attribute[]{new Attribute("src", true), new Attribute("width", false), new Attribute("height", false), new Attribute("alt", false), new Attribute("title", false)}), new Tag("a", new Attribute[]{new Attribute("href", true), new Attribute("title", false)})};

    public static String optimize(String html) {
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocumentImpl document = new HTMLDocumentImpl();
        DocumentFragment fragment = document.createDocumentFragment();
        try {
            parser.parse(new InputSource(new StringReader(html)), fragment);
        }
        catch (Exception e) {
            return null;
        }
        String ret = HTMLOptimizer.fromNodeToString(fragment).toString();
        return ret;
    }

    private static StringBuffer fromNodeToString(Node node) {
        StringBuffer buffer = new StringBuffer();
        if (node instanceof Element) {
            Element element = (Element)node;
            buffer.append(HTMLOptimizer.internal(element));
        } else if (node instanceof Text) {
            Text text = (Text)node;
            buffer.append(HTMLEntities.encode(text.getNodeValue()));
        } else {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node current = list.item(i);
                buffer.append(HTMLOptimizer.fromNodeToString(current));
                ++i;
            }
        }
        return buffer;
    }

    private static StringBuffer internal(Element el) {
        StringBuffer buffer = new StringBuffer();
        String tagname = el.getNodeName().toLowerCase();
        Tag tag = HTMLOptimizer.recognizeTag(tagname, el.getAttributes());
        if (tag != null) {
            buffer.append('<');
            buffer.append(tagname);
            buffer.append(HTMLOptimizer.recognizeAttributes(el, tag));
        }
        StringBuffer buffer2 = new StringBuffer();
        NodeList list = el.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            buffer2.append(HTMLOptimizer.fromNodeToString(list.item(i)));
            ++i;
        }
        if (tag != null) {
            if (buffer2.length() == 0) {
                buffer.append(' ');
                buffer.append('/');
                buffer.append('>');
            } else {
                buffer.append('>');
                buffer.append(buffer2);
                buffer.append('<');
                buffer.append('/');
                buffer.append(tagname);
                buffer.append('>');
            }
        } else if (buffer2.length() > 0) {
            buffer.append(buffer2);
        }
        return buffer;
    }

    private static Tag recognizeTag(String tagName, NamedNodeMap attrs) {
        int i = 0;
        while (i < TAGS.length) {
            if (HTMLOptimizer.TAGS[i].name.equals(tagName)) {
                Attribute[] aux = HTMLOptimizer.TAGS[i].attributes;
                int j = 0;
                while (j < aux.length) {
                    if (aux[j].required) {
                        boolean found = false;
                        int k = 0;
                        while (k < attrs.getLength()) {
                            Node aux2 = attrs.item(k);
                            String name = aux2.getNodeName().toLowerCase();
                            String value = aux2.getNodeValue();
                            if (name.equalsIgnoreCase(aux[j].name) && value != null && value.length() > 0) {
                                found = true;
                                break;
                            }
                            ++k;
                        }
                        if (!found) {
                            return null;
                        }
                    }
                    ++j;
                }
                return TAGS[i];
            }
            ++i;
        }
        return null;
    }

    private static StringBuffer recognizeAttributes(Element element, Tag tag) {
        StringBuffer buffer = new StringBuffer();
        NamedNodeMap attrs = element.getAttributes();
        int k = 0;
        while (k < attrs.getLength()) {
            Node attr = attrs.item(k);
            String attrName = attr.getNodeName().toLowerCase();
            String attrValue = attr.getNodeValue();
            boolean found = false;
            int w = 0;
            while (w < tag.attributes.length) {
                if (attrName.equals(tag.attributes[w].name)) {
                    found = true;
                    break;
                }
                ++w;
            }
            if (found && attrValue != null && attrValue.length() > 0) {
                buffer.append(' ');
                buffer.append(attrName);
                buffer.append('=');
                buffer.append('\"');
                buffer.append(HTMLEntities.encode(attrValue));
                buffer.append('\"');
            }
            ++k;
        }
        return buffer;
    }

    private static class Attribute {
        public String name;
        public boolean required;

        public Attribute(String name, boolean required) {
            this.name = name;
            this.required = required;
        }
    }

    private static class Tag {
        public String name;
        public Attribute[] attributes;

        public Tag(String name, Attribute[] attributes) {
            this.name = name;
            this.attributes = attributes;
        }
    }
}

