/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class BlankRecord
extends Record
implements CellValueRecordInterface {
    public static final short sid = 513;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf;

    public BlankRecord() {
    }

    public BlankRecord(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readShort();
        this.field_3_xf = in.readShort();
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public void setColumn(short col) {
        this.field_2_col = col;
    }

    public short getSid() {
        return 513;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[BLANK]\n");
        sb.append("    row= ").append(HexDump.shortToHex(this.getRow())).append("\n");
        sb.append("    col= ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        sb.append("    xf = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        sb.append("[/BLANK]\n");
        return sb.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putUShort(data, 0 + offset, 513);
        LittleEndian.putUShort(data, 2 + offset, 6);
        LittleEndian.putUShort(data, 4 + offset, this.getRow());
        LittleEndian.putUShort(data, 6 + offset, this.getColumn());
        LittleEndian.putUShort(data, 8 + offset, this.getXFIndex());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public Object clone() {
        BlankRecord rec = new BlankRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_col = this.field_2_col;
        rec.field_3_xf = this.field_3_xf;
        return rec;
    }
}

