/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

abstract class CalendarHeaderHandler {
    JXMonthView monthView;
    protected JComponent calendarHeader;
    private Icon monthDownImage;
    private Icon monthUpImage;

    CalendarHeaderHandler() {
    }

    public void install(JXMonthView monthView) {
        this.monthView = monthView;
        this.calendarHeader = this.createCalendarHeader();
        this.calendarHeader.setFont(this.getAsNotUIResource(this.createDerivedFont()));
        this.calendarHeader.setBackground(this.getAsNotUIResource(monthView.getMonthStringBackground()));
        this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
        this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        this.installZoomActions();
    }

    public void uninstall(JXMonthView monthView) {
        monthView.remove(this.getHeaderComponent());
    }

    public JComponent getHeaderComponent() {
        return this.calendarHeader;
    }

    protected abstract JComponent createCalendarHeader();

    private void installZoomActions() {
        ZoomOutAction zoomOutAction = new ZoomOutAction();
        zoomOutAction.setTarget(this.monthView);
        this.monthView.getActionMap().put("zoomOut", zoomOutAction);
        AbstractActionExt prev = new AbstractActionExt(null, this.monthDownImage){

            public void actionPerformed(ActionEvent e) {
                CalendarHeaderHandler.this.previousMonth();
            }
        };
        this.monthView.getActionMap().put("scrollToPreviousMonth", prev);
        AbstractActionExt next = new AbstractActionExt(null, this.monthUpImage){

            public void actionPerformed(ActionEvent e) {
                CalendarHeaderHandler.this.nextMonth();
            }
        };
        this.monthView.getActionMap().put("scrollToNextMonth", next);
    }

    private void nextMonth() {
        Date upperBound = this.monthView.getUpperBound();
        if (upperBound == null || upperBound.after(this.monthView.getLastDisplayedDay())) {
            Calendar cal = this.monthView.getCalendar();
            cal.add(2, 1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }

    private void previousMonth() {
        Date lowerBound = this.monthView.getLowerBound();
        if (lowerBound == null || lowerBound.before(this.monthView.getFirstDisplayedDay())) {
            Calendar cal = this.monthView.getCalendar();
            cal.add(2, -1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }

    private Font getAsNotUIResource(Font font) {
        if (!(font instanceof UIResource)) {
            return font;
        }
        return font.deriveFont(font.getAttributes());
    }

    private Color getAsNotUIResource(Color color) {
        if (!(color instanceof UIResource)) {
            return color;
        }
        float[] rgb = color.getRGBComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
    }

    @Deprecated
    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ZoomOutAction
    extends AbstractHyperlinkAction<JXMonthView> {
        private PropertyChangeListener linkListener;
        private String[] monthNames;
        private StringValue tsv = new StringValue(){

            public String getString(Object value) {
                if (value instanceof Calendar) {
                    String month = ZoomOutAction.this.monthNames[((Calendar)value).get(2)];
                    return month + " " + ((Calendar)value).get(1);
                }
                return StringValues.TO_STRING.getString(value);
            }
        };

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        protected void installTarget() {
            if (this.getTarget() != null) {
                ((JXMonthView)this.getTarget()).addPropertyChangeListener(this.getTargetListener());
            }
            this.updateLocale();
            this.updateFromTarget();
        }

        private void updateLocale() {
            Locale current = this.getTarget() != null ? ((JXMonthView)this.getTarget()).getLocale() : Locale.getDefault();
            this.monthNames = new DateFormatSymbols(current).getMonths();
        }

        @Override
        protected void uninstallTarget() {
            if (this.getTarget() == null) {
                return;
            }
            ((JXMonthView)this.getTarget()).removePropertyChangeListener(this.getTargetListener());
        }

        protected void updateFromTarget() {
            if (this.tsv == null) {
                return;
            }
            Calendar calendar = this.getTarget() != null ? ((JXMonthView)this.getTarget()).getCalendar() : null;
            this.setName(this.tsv.getString(calendar));
        }

        private PropertyChangeListener getTargetListener() {
            if (this.linkListener == null) {
                this.linkListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("firstDisplayedDay".equals(evt.getPropertyName())) {
                            ZoomOutAction.this.updateFromTarget();
                        } else if ("locale".equals(evt.getPropertyName())) {
                            ZoomOutAction.this.updateLocale();
                            ZoomOutAction.this.updateFromTarget();
                        }
                    }
                };
            }
            return this.linkListener;
        }
    }
}

