/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;

public class NavigationItemFigure
extends Figure {
    private static final double MIN_SCALE = 0.7142857142857143;
    private static final double MAX_SCALE = 1.0;
    private Image image = null;
    private String text = null;
    private double state = 0.0;
    private int alpha = 0;

    public NavigationItemFigure() {
        this.setBorder((Border)new MaskBorder());
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.white);
        this.updateState();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (image == this.image) {
            return;
        }
        this.image = image;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == this.text || text != null && text.equals(this.text)) {
            return;
        }
        this.text = text;
        this.repaint();
    }

    public double getState() {
        return this.state;
    }

    public void setState(double state) {
        if (state == this.state) {
            return;
        }
        this.state = state;
        this.updateState();
        this.revalidate();
    }

    private void updateState() {
        int s = (int)NavigationItemFigure.seg(50.0, 70.0, this.state);
        this.setPreferredSize(s, s);
        this.alpha = (int)NavigationItemFigure.seg(40.0, 0.0, this.state);
    }

    public void paint(Graphics graphics) {
        graphics.setAdvanced(true);
        graphics.setAntialias(1);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        org.eclipse.draw2d.geometry.Rectangle b = this.getBounds();
        float cx = (float)b.x + (float)b.width / 2.0f;
        float cy = (float)b.y + (float)b.height / 2.0f;
        double scale = NavigationItemFigure.seg(0.7142857142857143, 1.0, this.state);
        org.eclipse.draw2d.geometry.Rectangle r = this.getClientArea(org.eclipse.draw2d.geometry.Rectangle.SINGLETON);
        float x = (float)r.x - (70.0f - (float)b.width) / 2.0f - cx;
        float y = (float)r.y - (70.0f - (float)b.height) / 2.0f - cy;
        float w = r.width + (70 - b.width);
        float h = r.height + (70 - b.height);
        graphics.pushState();
        try {
            graphics.translate(cx, cy);
            graphics.scale(scale);
            if (this.image != null) {
                this.paintImage(graphics, x, y, w, h);
            } else if (this.text != null) {
                this.paintText(graphics, x, y, w, h);
            }
        }
        finally {
            graphics.restoreState();
            graphics.popState();
        }
    }

    private void paintImage(Graphics graphics, float x, float y, float w, float h) {
        Rectangle ir = this.image.getBounds();
        float iw = ir.width;
        float ih = ir.height;
        float tw = iw;
        float th = ih;
        if (tw > w) {
            th = th * w / tw;
            tw = w;
        }
        if (th > h) {
            tw = tw * h / th;
            th = h;
        }
        float tx = x + (w - tw) / 2.0f;
        float ty = y + (h - th) / 2.0f;
        graphics.drawImage(this.image, 0, 0, (int)iw, (int)ih, (int)tx, (int)ty, (int)tw, (int)th);
    }

    private void paintText(Graphics graphics, float x, float y, float w, float h) {
        float m = w * 0.05f;
        x += m;
        y += m;
        w -= m + m;
        h -= m + m;
        Dimension s = GraphicsUtils.getAdvanced().getTextSize(this.text, graphics.getFont());
        float tw = s.width;
        float th = s.height;
        double ts = 1.0;
        if (tw > w) {
            th = th * w / tw;
            ts = ts * (double)w / (double)tw;
            tw = w;
        }
        if (th > h) {
            tw = tw * h / th;
            ts = ts * (double)h / (double)th;
            th = h;
        }
        float tx = x + (w - tw) / 2.0f;
        float ty = y + (h - th) / 2.0f;
        if (ts == 1.0) {
            graphics.drawText(this.text, (int)tx, (int)ty);
        } else {
            graphics.scale(ts);
            graphics.drawText(this.text, (int)((double)tx / ts), (int)((double)ty / ts));
        }
    }

    private static double seg(double min, double max, double ratio) {
        return min + (max - min) * ratio;
    }

    private class MaskBorder
    extends LineBorder {
        public MaskBorder() {
            super(ColorConstants.lightGray, 1);
        }

        public Insets getInsets(IFigure figure) {
            return NO_INSETS;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (NavigationItemFigure.this.alpha > 0) {
                tempRect.setBounds(MaskBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
                graphics.setAlpha(NavigationItemFigure.this.alpha);
                graphics.setBackgroundColor(ColorConstants.black);
                graphics.fillRectangle(tempRect);
            } else {
                super.paint(figure, graphics, insets);
            }
        }
    }
}

