/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.xmind.core.IAccount;
import net.xmind.core.IAuthenticationListener;
import net.xmind.core.IAuthenticationListener2;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.xmind.core.Core;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.SeawindClient;
import org.xmind.ui.internal.seawind.JobRunner;
import org.xmind.ui.internal.seawind.MockedSeawindClient;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindSyncer;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.resources.FontUtils;

public class SeawindStartup
implements IStartup,
IWorkbenchListener,
IAuthenticationListener,
IAuthenticationListener2 {
    private IWorkbench workbench = null;
    private SeawindLibrary library = null;
    private IAccount account = null;
    private SeawindSyncer syncer;

    public void earlyStartup() {
        boolean debugJobs;
        SeawindClient client;
        this.workbench = PlatformUI.getWorkbench();
        this.workbench.addWorkbenchListener((IWorkbenchListener)this);
        this.library = SeawindUIPlugin.getSeawindLibrary();
        boolean mocked = SeawindUIPlugin.isDebugging("/debug/mock", false);
        String mockPath = SeawindUIPlugin.getDebugOption("/debug/mock/repoPath", null);
        if (mocked && mockPath != null && !"".equals(mockPath)) {
            client = new MockedSeawindClient((IStorage)new DirectoryStorage(new File(mockPath)));
            JSON.DEBUG = true;
            System.out.println("Seawind client is mocked.");
        } else {
            client = new SeawindClient();
            client.setXClientId(this.library.findXClientId());
        }
        if (SeawindUIPlugin.isDebugging("/debug/sync/log/requests", false)) {
            client.debug();
        }
        int jobStyle = (debugJobs = SeawindUIPlugin.isDebugging("/debug/sync/log/jobs", false)) ? 2 : 0;
        JobRunner jobRunner = new JobRunner(jobStyle);
        if (debugJobs) {
            jobRunner.debug();
        }
        this.account = this.findPrimaryAccount();
        Assert.isNotNull((Object)this.account);
        client.setCnUser(this.account.isCnUser());
        this.syncer = new SeawindSyncer(this.library, client, jobRunner);
        this.library.setSyncer(this.syncer);
        this.syncer.startUp(this.account);
        this.account.addAuthenticationListener((IAuthenticationListener)this);
        this.trimBackup();
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
        if (this.account != null) {
            this.account.removeAuthenticationListener((IAuthenticationListener)this);
        }
        this.account = null;
        final ProgressMonitorDialog progress = new ProgressMonitorDialog(null);
        progress.setOpenOnRun(false);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                try {
                    progress.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SeawindStartup.this.syncer.shutDown(monitor);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        });
        this.workbench = null;
    }

    private IAccount findPrimaryAccount() {
        IEvaluationService service = (IEvaluationService)this.workbench.getService(IEvaluationService.class);
        Assert.isNotNull((Object)service);
        IEvaluationContext state = service.getCurrentState();
        return (IAccount)state.getVariable("net.xmind.ui.primaryAccount");
    }

    public void onAuthenticated(IAccount account) {
        this.syncer.onAuthorized(account);
    }

    public void onUnauthenticated(IAccount account) {
        this.library.setStatus(1);
        this.library.setActive(false);
        this.syncer.onUnauthorized(account);
    }

    public void preUnauthenticate(IProgressMonitor monitor, IAccount account) throws InterruptedException {
        if (!this.library.isActive()) {
            return;
        }
        final ArrayList<IEditorReference> dirtySeawindEditorReferences = new ArrayList<IEditorReference>();
        IWorkbenchWindow workbenchWindow = this.workbench.getWorkbenchWindows()[0];
        if (workbenchWindow != null) {
            IEditorReference[] editorReferences;
            final IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
            if (workbenchPage != null && (editorReferences = workbenchPage.getEditorReferences()) != null && editorReferences.length > 0) {
                IEditorReference[] iEditorReferenceArray = editorReferences;
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editor;
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    if (editorReference != null && (editor = editorReference.getEditor(false)).isDirty() && editor.getAdapter(IWorkbookRef.class) instanceof SeawindWorkbookRef) {
                        dirtySeawindEditorReferences.add(editorReference);
                    }
                    ++n2;
                }
            }
            if (dirtySeawindEditorReferences.size() > 0) {
                this.workbench.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IEditorReference editorReference : dirtySeawindEditorReferences) {
                            IEditorPart editor = editorReference.getEditor(true);
                            workbenchPage.activate((IWorkbenchPart)editor);
                            boolean closed = workbenchPage.closeEditor(editor, true);
                            if (!closed) break;
                        }
                    }
                });
                monitor.setCanceled(true);
                throw new InterruptedException();
            }
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final boolean[] doIt = new boolean[]{false};
        this.workbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SignOutConfirmationDialog dialog = new SignOutConfirmationDialog(null, SeawindMessages.SignOutConfirmationDialog_title, null, SeawindMessages.SignOutConfirmationDialog_mainMessage, SeawindMessages.SignOutConfirmationDialog_subMessage2, 4, new String[]{IDialogConstants.CANCEL_LABEL, SeawindMessages.SignOutConfirmationDialog_DeleteAndSignOutButton_text}, 0);
                if (dialog.open() == 1) {
                    doIt[0] = true;
                }
            }
        });
        if (!doIt[0]) {
            subMonitor.setCanceled(true);
            throw new InterruptedException();
        }
    }

    private void trimBackup() {
        String backupPath = Core.getWorkspace().getAbsolutePath(".sBackup/");
        File backupDir = new File(backupPath);
        FileUtils.ensureDirectory((File)backupDir);
        File[] fileArray = backupDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.exists() && System.currentTimeMillis() - file.lastModified() > 889032704L) {
                file.delete();
            }
            ++n2;
        }
    }

    private static class SignOutConfirmationDialog
    extends MessageDialog {
        private ResourceManager resources;
        private String subMessage;

        public SignOutConfirmationDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String mainMessage, String subMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, mainMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.subMessage = subMessage;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)shell);
        }

        protected Control createMessageArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setBackground(parent.getBackground());
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                this.addAccessibleListeners(this.imageLabel, image);
                GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)this.imageLabel);
            }
            this.createMessagesSection(parent);
            return composite;
        }

        private Composite createMessagesSection(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setBackground(parent.getBackground());
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginBottom = 10;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            if (this.message != null) {
                this.messageLabel = new Label(composite, this.getMessageLabelStyle());
                this.messageLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])this.messageLabel.getFont().getFontData(), (boolean)true))));
                this.messageLabel.setText(this.message);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLabel);
            }
            if (this.subMessage != null) {
                Label messageLabel2 = new Label(composite, this.getMessageLabelStyle());
                messageLabel2.setText(this.subMessage);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel2);
            }
            return composite;
        }

        private void addAccessibleListeners(Label label, final Image image) {
            label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent event) {
                    String accessibleMessage = this.getAccessibleMessageFor(image);
                    if (accessibleMessage == null) {
                        return;
                    }
                    event.result = accessibleMessage;
                }
            });
        }

        private String getAccessibleMessageFor(Image image) {
            if (image.equals((Object)this.getErrorImage())) {
                return JFaceResources.getString((String)"error");
            }
            if (image.equals((Object)this.getWarningImage())) {
                return JFaceResources.getString((String)"warning");
            }
            if (image.equals((Object)this.getInfoImage())) {
                return JFaceResources.getString((String)"info");
            }
            if (image.equals((Object)this.getQuestionImage())) {
                return JFaceResources.getString((String)"question");
            }
            return null;
        }
    }
}

