/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.sharing.general;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.gef.IViewer;
import org.xmind.internal.share.GeneralSharePlugin;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;
import org.xmind.ui.internal.sharing.general.BlogShareItem;
import org.xmind.ui.internal.sharing.general.EmailShareItem;
import org.xmind.ui.internal.sharing.general.FacebookShareItem;
import org.xmind.ui.internal.sharing.general.LinkedInShareItem;
import org.xmind.ui.internal.sharing.general.PrivateShareItem;
import org.xmind.ui.internal.sharing.general.PublicShareItem;
import org.xmind.ui.internal.sharing.general.TwitterShareItem;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.util.Logger;

public class GeneralShareHandler
extends AbstractHandler {
    private static final String COMMAND_ID_FACEBOOK = "org.xmind.ui.command.share.facebook";
    private static final String COMMAND_ID_TWITTER = "org.xmind.ui.command.share.twitter";
    private static final String COMMAND_ID_LINKEDIN = "org.xmind.ui.command.share.linkedin";
    private static final String COMMAND_ID_BLOG = "org.xmind.ui.command.share.blog";
    private static final String COMMAND_ID_PUBLIC = "org.xmind.ui.command.share.public";
    private static final String COMMAND_ID_PRIVATE = "org.xmind.ui.command.share.private";
    private static final String COMMAND_ID_EMAIL = "org.xmind.ui.command.share.email";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        Assert.isLegal((command != null ? 1 : 0) != 0);
        final String commandId = command.getId();
        Assert.isLegal((commandId != null ? 1 : 0) != 0);
        final Shell parentShell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        IEditorPart editor = MindMapHandlerUtil.findContributingEditor((ExecutionEvent)event);
        if (editor == null) {
            throw new ExecutionException("No editor found");
        }
        IViewer viewer = GeneralSharePlugin.getAdapter(editor, IViewer.class);
        if (viewer == null || !(viewer instanceof IMindMapViewer)) {
            Logger.log((String)"No mind map viewer found");
            return null;
        }
        final IMindMapViewer sourceViewer = (IMindMapViewer)viewer;
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                String usageType = null;
                if (GeneralShareHandler.COMMAND_ID_FACEBOOK.equals(commandId)) {
                    usageType = "ShareToFacebookCount";
                    new FacebookShareItem().share(parentShell, sourceViewer);
                } else if (GeneralShareHandler.COMMAND_ID_TWITTER.equals(commandId)) {
                    usageType = "ShareToTwitterCount";
                    new TwitterShareItem().share(parentShell, sourceViewer);
                } else if (GeneralShareHandler.COMMAND_ID_LINKEDIN.equals(commandId)) {
                    usageType = "ShareToLinkedInCount";
                    new LinkedInShareItem().share(parentShell, sourceViewer);
                } else if (GeneralShareHandler.COMMAND_ID_BLOG.equals(commandId)) {
                    usageType = "ShareToBlogCount";
                    new BlogShareItem().share(parentShell, sourceViewer);
                } else if (GeneralShareHandler.COMMAND_ID_PUBLIC.equals(commandId)) {
                    usageType = "SharePublicLinkCount";
                    new PublicShareItem().share(parentShell, sourceViewer);
                } else if (GeneralShareHandler.COMMAND_ID_PRIVATE.equals(commandId)) {
                    usageType = "SharePrivateLinkCount";
                    new PrivateShareItem().share(parentShell, sourceViewer);
                } else if (GeneralShareHandler.COMMAND_ID_EMAIL.equals(commandId)) {
                    usageType = "ShareToEmailCount";
                    new EmailShareItem().share(parentShell, sourceViewer);
                }
                if (usageType != null) {
                    GeneralSharePlugin.getDefault().getUsageDataCollector().increase(usageType);
                }
            }
        });
        return null;
    }
}

