/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.internal.search.SearchPlugin;
import org.xmind.ui.internal.search.web.SearchEngineDescriptor;
import org.xmind.ui.internal.search.web.SearchEnginePref;
import org.xmind.ui.search.IFormData;
import org.xmind.ui.search.ISearchEngineDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEngineRegistry {
    private static final String BROWSER_ID = "org.xmind.ui.search";
    private static final SearchEngineRegistry instance = new SearchEngineRegistry();
    private static final Comparator<ISearchEngineDescriptor> SearchEngineComparator = new Comparator<ISearchEngineDescriptor>(){

        @Override
        public int compare(ISearchEngineDescriptor o1, ISearchEngineDescriptor o2) {
            return o1.getId().compareToIgnoreCase(o2.getId());
        }
    };
    private static final String SEARCH_TERMS = "\\{searchTerms\\}";
    private Map<String, ISearchEngineDescriptor> engineMap;
    private List<ISearchEngineDescriptor> engineList;
    private List<ISearchEngineDescriptor> visibleEngies;
    private ISearchEngineDescriptor defaultEngine;

    private SearchEngineRegistry() {
    }

    public void search(String terms) {
        this.search(this.getDefaultEngine(), null, terms);
    }

    public void search(String engineId, String terms) {
        this.search(this.getEngine(engineId), null, terms);
    }

    public void search(String engineId, String browserClientId, String terms) {
        this.search(this.getEngine(engineId), browserClientId, terms);
    }

    protected void search(ISearchEngineDescriptor descriptor, String terms) {
        this.search(descriptor, null, terms);
    }

    protected void search(final ISearchEngineDescriptor descriptor, final String browserClientId, final String terms) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IBrowser browser = browserClientId == null ? BrowserSupport.getInstance().createBrowser(SearchEngineRegistry.BROWSER_ID) : BrowserSupport.getInstance().createBrowser(browserClientId);
                if (descriptor.getUrl() == null) {
                    browser.setText(SearchEngineRegistry.this.generateText(descriptor, terms));
                } else {
                    browser.openURL(SearchEngineRegistry.this.generateURL(descriptor, terms));
                }
            }
        });
    }

    private String generateURL(ISearchEngineDescriptor descriptor, String terms) {
        return descriptor.getUrl().replaceAll(SEARCH_TERMS, SearchEngineRegistry.escape(this.getEncodedTerms(descriptor, terms)));
    }

    private String getEncodedTerms(ISearchEngineDescriptor descriptor, String terms) {
        try {
            return URLEncoder.encode(terms, descriptor.getInputEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return terms;
        }
    }

    private String generateText(ISearchEngineDescriptor descriptor, String terms) {
        terms = SearchEngineRegistry.getEncodedTerms2(descriptor, terms);
        StringBuffer ret = new StringBuffer();
        IFormData fd = descriptor.getFormData();
        if (fd != null) {
            ret.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
            ret.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; " + descriptor.getInputEncoding() + "\" /></head>");
            ret.append("<body><h3>Loading...</h3><form id='generatedByBrainy' method='" + fd.getFormMethod() + "' action='" + fd.getFormAction() + "'>");
            for (Map.Entry<String, String> e : fd.getFormParams().entrySet()) {
                String key = e.getKey().replaceAll(SEARCH_TERMS, SearchEngineRegistry.escape(terms));
                String value = e.getValue().replaceAll(SEARCH_TERMS, SearchEngineRegistry.escape(terms));
                ret.append("<input type='hidden' name='" + key + "' value='" + value + "' />");
            }
            ret.append("</form><script type=\"text/javascript\">document.getElementById(\"generatedByBrainy\").submit();</script></body></html>");
        }
        return ret.toString();
    }

    private static String getEncodedTerms2(ISearchEngineDescriptor descriptor, String terms) {
        return terms.replaceAll(" ", "+");
    }

    public ISearchEngineDescriptor getEngine(String id) {
        this.ensureLoaded();
        return this.engineMap.get(id);
    }

    public List<ISearchEngineDescriptor> getAllEngines() {
        this.ensureLoaded();
        return this.engineList;
    }

    public List<ISearchEngineDescriptor> getVisibleEngines() {
        this.ensureLoaded();
        return this.visibleEngies;
    }

    private void ensureLoaded() {
        if (this.engineList != null && this.engineMap != null && this.visibleEngies != null) {
            return;
        }
        this.lazyLoad();
        if (this.engineList == null) {
            this.engineList = Collections.emptyList();
        }
        if (this.engineMap == null) {
            this.engineMap = Collections.emptyMap();
        }
        if (this.visibleEngies == null) {
            this.visibleEngies = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        URL resource = FileLocator.find((Bundle)SearchPlugin.getDefault().getBundle(), (IPath)new Path("searchEngines.xml"), null);
        if (resource != null) {
            try {
                this.readFrom(resource.openStream());
            }
            catch (Throwable throwable) {}
        }
    }

    private void readFrom(InputStream is) throws IOException {
        Document document = DOMUtils.loadDocument((InputStream)is);
        Element docEle = document.getDocumentElement();
        if (docEle == null) {
            return;
        }
        Iterator it = DOMUtils.childElementIterByTag((Node)docEle, (String)"SearchEngine");
        while (it.hasNext()) {
            Element searchEngineImplementation = (Element)it.next();
            SearchEngineDescriptor descriptor = new SearchEngineDescriptor(searchEngineImplementation);
            this.registerDescriptor(descriptor);
        }
        if (this.engineList != null) {
            Collections.sort(this.engineList, SearchEngineComparator);
            this.visibleEngies = new ArrayList<ISearchEngineDescriptor>(this.engineList);
            Iterator<ISearchEngineDescriptor> it2 = this.visibleEngies.iterator();
            while (it2.hasNext()) {
                if (it2.next().isVisible()) continue;
                it2.remove();
            }
        }
    }

    private void registerDescriptor(ISearchEngineDescriptor descriptor) {
        if (this.engineList == null) {
            this.engineList = new ArrayList<ISearchEngineDescriptor>();
        }
        this.engineList.add(descriptor);
        if (this.engineMap == null) {
            this.engineMap = new HashMap<String, ISearchEngineDescriptor>();
        }
        this.engineMap.put(descriptor.getId(), descriptor);
    }

    public void refresh() {
        this.engineList = null;
        this.engineMap = null;
        this.visibleEngies = null;
        this.refreshDefaultEngine();
        this.ensureLoaded();
    }

    public void refreshDefaultEngine() {
        this.defaultEngine = null;
    }

    private ISearchEngineDescriptor getDefaultEngine() {
        if (this.defaultEngine == null) {
            List<ISearchEngineDescriptor> engines;
            String id = SearchEnginePref.getDefaultEngineId();
            if (id != null && !"".equals(id)) {
                this.defaultEngine = this.getEngine(id);
            }
            if (this.defaultEngine == null && !(engines = this.getVisibleEngines()).isEmpty()) {
                this.defaultEngine = engines.get(0);
            }
        }
        return this.defaultEngine;
    }

    public static SearchEngineRegistry getInstance() {
        return instance;
    }

    private static String escape(String name) {
        return name.replaceAll("\\$", "\\\\\\$").replaceAll("\\\\", "\\\\\\\\");
    }
}

