/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.index.resource;

import java.util.List;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.index.resource.IIndexResource;

public abstract class AbstractIndexResource
implements IIndexResource {
    protected void collectResourceForWorkbook(IWorkbook workbook) {
        if (workbook == null) {
            return;
        }
        List sheets = workbook.getSheets();
        for (ISheet sheet : sheets) {
            this.collectResourceForSheet(sheet);
        }
    }

    protected void collectResourceForSheet(ISheet sheet) {
        ITopic rootTopic = sheet.getRootTopic();
        this.collectResourceForTopic(rootTopic);
        this.collectResourceForParentTopic(rootTopic);
    }

    protected void collectResourceForParentTopic(ITopic parentTopic) {
        for (ITopic child : parentTopic.getAllChildren()) {
            this.collectResourceForTopic(child);
            this.collectResourceForParentTopic(child);
        }
    }

    protected abstract void collectResourceForTopic(ITopic var1);
}

