/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.edam.notestore;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.ClientUsageMetrics;
import com.evernote.edam.notestore.NoteCollectionCounts;
import com.evernote.edam.notestore.NoteEmailParameters;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.NoteStoreIface;
import com.evernote.edam.notestore.NoteVersionId;
import com.evernote.edam.notestore.NotesMetadataList;
import com.evernote.edam.notestore.NotesMetadataResultSpec;
import com.evernote.edam.notestore.RelatedQuery;
import com.evernote.edam.notestore.RelatedResult;
import com.evernote.edam.notestore.RelatedResultSpec;
import com.evernote.edam.notestore.SyncChunk;
import com.evernote.edam.notestore.SyncChunkFilter;
import com.evernote.edam.notestore.SyncState;
import com.evernote.edam.type.LazyMap;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.SharedNotebookRecipientSettings;
import com.evernote.edam.type.Tag;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TApplicationException;
import com.evernote.thrift.TBase;
import com.evernote.thrift.TBaseHelper;
import com.evernote.thrift.TException;
import com.evernote.thrift.TServiceClient;
import com.evernote.thrift.protocol.TField;
import com.evernote.thrift.protocol.TList;
import com.evernote.thrift.protocol.TMessage;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.protocol.TProtocolUtil;
import com.evernote.thrift.protocol.TStruct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NoteStore {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Client
    implements TServiceClient,
    Iface {
        protected TProtocol iprot_;
        protected TProtocol oprot_;
        protected int seqid_;

        public Client(TProtocol prot) {
            this(prot, prot);
        }

        public Client(TProtocol iprot, TProtocol oprot) {
            this.iprot_ = iprot;
            this.oprot_ = oprot;
        }

        @Override
        public TProtocol getInputProtocol() {
            return this.iprot_;
        }

        @Override
        public TProtocol getOutputProtocol() {
            return this.oprot_;
        }

        @Override
        public SyncState getSyncState(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getSyncState(authenticationToken);
            return this.recv_getSyncState();
        }

        public void send_getSyncState(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getSyncState", 1, ++this.seqid_));
            getSyncState_args args = new getSyncState_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SyncState recv_getSyncState() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getSyncState failed: out of sequence response");
            }
            getSyncState_result result = new getSyncState_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getSyncState failed: unknown result");
        }

        @Override
        public SyncState getSyncStateWithMetrics(String authenticationToken, ClientUsageMetrics clientMetrics) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getSyncStateWithMetrics(authenticationToken, clientMetrics);
            return this.recv_getSyncStateWithMetrics();
        }

        public void send_getSyncStateWithMetrics(String authenticationToken, ClientUsageMetrics clientMetrics) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getSyncStateWithMetrics", 1, ++this.seqid_));
            getSyncStateWithMetrics_args args = new getSyncStateWithMetrics_args();
            args.setAuthenticationToken(authenticationToken);
            args.setClientMetrics(clientMetrics);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SyncState recv_getSyncStateWithMetrics() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getSyncStateWithMetrics failed: out of sequence response");
            }
            getSyncStateWithMetrics_result result = new getSyncStateWithMetrics_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getSyncStateWithMetrics failed: unknown result");
        }

        @Override
        public SyncChunk getSyncChunk(String authenticationToken, int afterUSN, int maxEntries, boolean fullSyncOnly) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getSyncChunk(authenticationToken, afterUSN, maxEntries, fullSyncOnly);
            return this.recv_getSyncChunk();
        }

        public void send_getSyncChunk(String authenticationToken, int afterUSN, int maxEntries, boolean fullSyncOnly) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getSyncChunk", 1, ++this.seqid_));
            getSyncChunk_args args = new getSyncChunk_args();
            args.setAuthenticationToken(authenticationToken);
            args.setAfterUSN(afterUSN);
            args.setMaxEntries(maxEntries);
            args.setFullSyncOnly(fullSyncOnly);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SyncChunk recv_getSyncChunk() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getSyncChunk failed: out of sequence response");
            }
            getSyncChunk_result result = new getSyncChunk_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getSyncChunk failed: unknown result");
        }

        @Override
        public SyncChunk getFilteredSyncChunk(String authenticationToken, int afterUSN, int maxEntries, SyncChunkFilter filter) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getFilteredSyncChunk(authenticationToken, afterUSN, maxEntries, filter);
            return this.recv_getFilteredSyncChunk();
        }

        public void send_getFilteredSyncChunk(String authenticationToken, int afterUSN, int maxEntries, SyncChunkFilter filter) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getFilteredSyncChunk", 1, ++this.seqid_));
            getFilteredSyncChunk_args args = new getFilteredSyncChunk_args();
            args.setAuthenticationToken(authenticationToken);
            args.setAfterUSN(afterUSN);
            args.setMaxEntries(maxEntries);
            args.setFilter(filter);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SyncChunk recv_getFilteredSyncChunk() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getFilteredSyncChunk failed: out of sequence response");
            }
            getFilteredSyncChunk_result result = new getFilteredSyncChunk_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getFilteredSyncChunk failed: unknown result");
        }

        @Override
        public SyncState getLinkedNotebookSyncState(String authenticationToken, LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getLinkedNotebookSyncState(authenticationToken, linkedNotebook);
            return this.recv_getLinkedNotebookSyncState();
        }

        public void send_getLinkedNotebookSyncState(String authenticationToken, LinkedNotebook linkedNotebook) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getLinkedNotebookSyncState", 1, ++this.seqid_));
            getLinkedNotebookSyncState_args args = new getLinkedNotebookSyncState_args();
            args.setAuthenticationToken(authenticationToken);
            args.setLinkedNotebook(linkedNotebook);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SyncState recv_getLinkedNotebookSyncState() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getLinkedNotebookSyncState failed: out of sequence response");
            }
            getLinkedNotebookSyncState_result result = new getLinkedNotebookSyncState_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getLinkedNotebookSyncState failed: unknown result");
        }

        @Override
        public SyncChunk getLinkedNotebookSyncChunk(String authenticationToken, LinkedNotebook linkedNotebook, int afterUSN, int maxEntries, boolean fullSyncOnly) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getLinkedNotebookSyncChunk(authenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly);
            return this.recv_getLinkedNotebookSyncChunk();
        }

        public void send_getLinkedNotebookSyncChunk(String authenticationToken, LinkedNotebook linkedNotebook, int afterUSN, int maxEntries, boolean fullSyncOnly) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getLinkedNotebookSyncChunk", 1, ++this.seqid_));
            getLinkedNotebookSyncChunk_args args = new getLinkedNotebookSyncChunk_args();
            args.setAuthenticationToken(authenticationToken);
            args.setLinkedNotebook(linkedNotebook);
            args.setAfterUSN(afterUSN);
            args.setMaxEntries(maxEntries);
            args.setFullSyncOnly(fullSyncOnly);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SyncChunk recv_getLinkedNotebookSyncChunk() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getLinkedNotebookSyncChunk failed: out of sequence response");
            }
            getLinkedNotebookSyncChunk_result result = new getLinkedNotebookSyncChunk_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getLinkedNotebookSyncChunk failed: unknown result");
        }

        @Override
        public List<Notebook> listNotebooks(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_listNotebooks(authenticationToken);
            return this.recv_listNotebooks();
        }

        public void send_listNotebooks(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("listNotebooks", 1, ++this.seqid_));
            listNotebooks_args args = new listNotebooks_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<Notebook> recv_listNotebooks() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "listNotebooks failed: out of sequence response");
            }
            listNotebooks_result result = new listNotebooks_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "listNotebooks failed: unknown result");
        }

        @Override
        public Notebook getNotebook(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNotebook(authenticationToken, guid);
            return this.recv_getNotebook();
        }

        public void send_getNotebook(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNotebook", 1, ++this.seqid_));
            getNotebook_args args = new getNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Notebook recv_getNotebook() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNotebook failed: out of sequence response");
            }
            getNotebook_result result = new getNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNotebook failed: unknown result");
        }

        @Override
        public Notebook getDefaultNotebook(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getDefaultNotebook(authenticationToken);
            return this.recv_getDefaultNotebook();
        }

        public void send_getDefaultNotebook(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getDefaultNotebook", 1, ++this.seqid_));
            getDefaultNotebook_args args = new getDefaultNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Notebook recv_getDefaultNotebook() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getDefaultNotebook failed: out of sequence response");
            }
            getDefaultNotebook_result result = new getDefaultNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getDefaultNotebook failed: unknown result");
        }

        @Override
        public Notebook createNotebook(String authenticationToken, Notebook notebook) throws EDAMUserException, EDAMSystemException, TException {
            this.send_createNotebook(authenticationToken, notebook);
            return this.recv_createNotebook();
        }

        public void send_createNotebook(String authenticationToken, Notebook notebook) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("createNotebook", 1, ++this.seqid_));
            createNotebook_args args = new createNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNotebook(notebook);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Notebook recv_createNotebook() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "createNotebook failed: out of sequence response");
            }
            createNotebook_result result = new createNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "createNotebook failed: unknown result");
        }

        @Override
        public int updateNotebook(String authenticationToken, Notebook notebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_updateNotebook(authenticationToken, notebook);
            return this.recv_updateNotebook();
        }

        public void send_updateNotebook(String authenticationToken, Notebook notebook) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("updateNotebook", 1, ++this.seqid_));
            updateNotebook_args args = new updateNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNotebook(notebook);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_updateNotebook() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "updateNotebook failed: out of sequence response");
            }
            updateNotebook_result result = new updateNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "updateNotebook failed: unknown result");
        }

        @Override
        public int expungeNotebook(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_expungeNotebook(authenticationToken, guid);
            return this.recv_expungeNotebook();
        }

        public void send_expungeNotebook(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeNotebook", 1, ++this.seqid_));
            expungeNotebook_args args = new expungeNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeNotebook() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeNotebook failed: out of sequence response");
            }
            expungeNotebook_result result = new expungeNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "expungeNotebook failed: unknown result");
        }

        @Override
        public List<Tag> listTags(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_listTags(authenticationToken);
            return this.recv_listTags();
        }

        public void send_listTags(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("listTags", 1, ++this.seqid_));
            listTags_args args = new listTags_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<Tag> recv_listTags() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "listTags failed: out of sequence response");
            }
            listTags_result result = new listTags_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "listTags failed: unknown result");
        }

        @Override
        public List<Tag> listTagsByNotebook(String authenticationToken, String notebookGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_listTagsByNotebook(authenticationToken, notebookGuid);
            return this.recv_listTagsByNotebook();
        }

        public void send_listTagsByNotebook(String authenticationToken, String notebookGuid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("listTagsByNotebook", 1, ++this.seqid_));
            listTagsByNotebook_args args = new listTagsByNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNotebookGuid(notebookGuid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<Tag> recv_listTagsByNotebook() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "listTagsByNotebook failed: out of sequence response");
            }
            listTagsByNotebook_result result = new listTagsByNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "listTagsByNotebook failed: unknown result");
        }

        @Override
        public Tag getTag(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getTag(authenticationToken, guid);
            return this.recv_getTag();
        }

        public void send_getTag(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getTag", 1, ++this.seqid_));
            getTag_args args = new getTag_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Tag recv_getTag() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getTag failed: out of sequence response");
            }
            getTag_result result = new getTag_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getTag failed: unknown result");
        }

        @Override
        public Tag createTag(String authenticationToken, Tag tag) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_createTag(authenticationToken, tag);
            return this.recv_createTag();
        }

        public void send_createTag(String authenticationToken, Tag tag) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("createTag", 1, ++this.seqid_));
            createTag_args args = new createTag_args();
            args.setAuthenticationToken(authenticationToken);
            args.setTag(tag);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Tag recv_createTag() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "createTag failed: out of sequence response");
            }
            createTag_result result = new createTag_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "createTag failed: unknown result");
        }

        @Override
        public int updateTag(String authenticationToken, Tag tag) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_updateTag(authenticationToken, tag);
            return this.recv_updateTag();
        }

        public void send_updateTag(String authenticationToken, Tag tag) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("updateTag", 1, ++this.seqid_));
            updateTag_args args = new updateTag_args();
            args.setAuthenticationToken(authenticationToken);
            args.setTag(tag);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_updateTag() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "updateTag failed: out of sequence response");
            }
            updateTag_result result = new updateTag_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "updateTag failed: unknown result");
        }

        @Override
        public void untagAll(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_untagAll(authenticationToken, guid);
            this.recv_untagAll();
        }

        public void send_untagAll(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("untagAll", 1, ++this.seqid_));
            untagAll_args args = new untagAll_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public void recv_untagAll() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "untagAll failed: out of sequence response");
            }
            untagAll_result result = new untagAll_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
        }

        @Override
        public int expungeTag(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_expungeTag(authenticationToken, guid);
            return this.recv_expungeTag();
        }

        public void send_expungeTag(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeTag", 1, ++this.seqid_));
            expungeTag_args args = new expungeTag_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeTag() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeTag failed: out of sequence response");
            }
            expungeTag_result result = new expungeTag_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "expungeTag failed: unknown result");
        }

        @Override
        public List<SavedSearch> listSearches(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_listSearches(authenticationToken);
            return this.recv_listSearches();
        }

        public void send_listSearches(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("listSearches", 1, ++this.seqid_));
            listSearches_args args = new listSearches_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<SavedSearch> recv_listSearches() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "listSearches failed: out of sequence response");
            }
            listSearches_result result = new listSearches_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "listSearches failed: unknown result");
        }

        @Override
        public SavedSearch getSearch(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getSearch(authenticationToken, guid);
            return this.recv_getSearch();
        }

        public void send_getSearch(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getSearch", 1, ++this.seqid_));
            getSearch_args args = new getSearch_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SavedSearch recv_getSearch() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getSearch failed: out of sequence response");
            }
            getSearch_result result = new getSearch_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getSearch failed: unknown result");
        }

        @Override
        public SavedSearch createSearch(String authenticationToken, SavedSearch search) throws EDAMUserException, EDAMSystemException, TException {
            this.send_createSearch(authenticationToken, search);
            return this.recv_createSearch();
        }

        public void send_createSearch(String authenticationToken, SavedSearch search) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("createSearch", 1, ++this.seqid_));
            createSearch_args args = new createSearch_args();
            args.setAuthenticationToken(authenticationToken);
            args.setSearch(search);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SavedSearch recv_createSearch() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "createSearch failed: out of sequence response");
            }
            createSearch_result result = new createSearch_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "createSearch failed: unknown result");
        }

        @Override
        public int updateSearch(String authenticationToken, SavedSearch search) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_updateSearch(authenticationToken, search);
            return this.recv_updateSearch();
        }

        public void send_updateSearch(String authenticationToken, SavedSearch search) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("updateSearch", 1, ++this.seqid_));
            updateSearch_args args = new updateSearch_args();
            args.setAuthenticationToken(authenticationToken);
            args.setSearch(search);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_updateSearch() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "updateSearch failed: out of sequence response");
            }
            updateSearch_result result = new updateSearch_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "updateSearch failed: unknown result");
        }

        @Override
        public int expungeSearch(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_expungeSearch(authenticationToken, guid);
            return this.recv_expungeSearch();
        }

        public void send_expungeSearch(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeSearch", 1, ++this.seqid_));
            expungeSearch_args args = new expungeSearch_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeSearch() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeSearch failed: out of sequence response");
            }
            expungeSearch_result result = new expungeSearch_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "expungeSearch failed: unknown result");
        }

        @Override
        public NoteList findNotes(String authenticationToken, NoteFilter filter, int offset, int maxNotes) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_findNotes(authenticationToken, filter, offset, maxNotes);
            return this.recv_findNotes();
        }

        public void send_findNotes(String authenticationToken, NoteFilter filter, int offset, int maxNotes) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("findNotes", 1, ++this.seqid_));
            findNotes_args args = new findNotes_args();
            args.setAuthenticationToken(authenticationToken);
            args.setFilter(filter);
            args.setOffset(offset);
            args.setMaxNotes(maxNotes);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public NoteList recv_findNotes() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "findNotes failed: out of sequence response");
            }
            findNotes_result result = new findNotes_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "findNotes failed: unknown result");
        }

        @Override
        public int findNoteOffset(String authenticationToken, NoteFilter filter, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_findNoteOffset(authenticationToken, filter, guid);
            return this.recv_findNoteOffset();
        }

        public void send_findNoteOffset(String authenticationToken, NoteFilter filter, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("findNoteOffset", 1, ++this.seqid_));
            findNoteOffset_args args = new findNoteOffset_args();
            args.setAuthenticationToken(authenticationToken);
            args.setFilter(filter);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_findNoteOffset() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "findNoteOffset failed: out of sequence response");
            }
            findNoteOffset_result result = new findNoteOffset_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "findNoteOffset failed: unknown result");
        }

        @Override
        public NotesMetadataList findNotesMetadata(String authenticationToken, NoteFilter filter, int offset, int maxNotes, NotesMetadataResultSpec resultSpec) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_findNotesMetadata(authenticationToken, filter, offset, maxNotes, resultSpec);
            return this.recv_findNotesMetadata();
        }

        public void send_findNotesMetadata(String authenticationToken, NoteFilter filter, int offset, int maxNotes, NotesMetadataResultSpec resultSpec) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("findNotesMetadata", 1, ++this.seqid_));
            findNotesMetadata_args args = new findNotesMetadata_args();
            args.setAuthenticationToken(authenticationToken);
            args.setFilter(filter);
            args.setOffset(offset);
            args.setMaxNotes(maxNotes);
            args.setResultSpec(resultSpec);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public NotesMetadataList recv_findNotesMetadata() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "findNotesMetadata failed: out of sequence response");
            }
            findNotesMetadata_result result = new findNotesMetadata_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "findNotesMetadata failed: unknown result");
        }

        @Override
        public NoteCollectionCounts findNoteCounts(String authenticationToken, NoteFilter filter, boolean withTrash) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_findNoteCounts(authenticationToken, filter, withTrash);
            return this.recv_findNoteCounts();
        }

        public void send_findNoteCounts(String authenticationToken, NoteFilter filter, boolean withTrash) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("findNoteCounts", 1, ++this.seqid_));
            findNoteCounts_args args = new findNoteCounts_args();
            args.setAuthenticationToken(authenticationToken);
            args.setFilter(filter);
            args.setWithTrash(withTrash);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public NoteCollectionCounts recv_findNoteCounts() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "findNoteCounts failed: out of sequence response");
            }
            findNoteCounts_result result = new findNoteCounts_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "findNoteCounts failed: unknown result");
        }

        @Override
        public Note getNote(String authenticationToken, String guid, boolean withContent, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNote(authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
            return this.recv_getNote();
        }

        public void send_getNote(String authenticationToken, String guid, boolean withContent, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNote", 1, ++this.seqid_));
            getNote_args args = new getNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setWithContent(withContent);
            args.setWithResourcesData(withResourcesData);
            args.setWithResourcesRecognition(withResourcesRecognition);
            args.setWithResourcesAlternateData(withResourcesAlternateData);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Note recv_getNote() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNote failed: out of sequence response");
            }
            getNote_result result = new getNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNote failed: unknown result");
        }

        @Override
        public LazyMap getNoteApplicationData(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNoteApplicationData(authenticationToken, guid);
            return this.recv_getNoteApplicationData();
        }

        public void send_getNoteApplicationData(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNoteApplicationData", 1, ++this.seqid_));
            getNoteApplicationData_args args = new getNoteApplicationData_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public LazyMap recv_getNoteApplicationData() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNoteApplicationData failed: out of sequence response");
            }
            getNoteApplicationData_result result = new getNoteApplicationData_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNoteApplicationData failed: unknown result");
        }

        @Override
        public String getNoteApplicationDataEntry(String authenticationToken, String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNoteApplicationDataEntry(authenticationToken, guid, key);
            return this.recv_getNoteApplicationDataEntry();
        }

        public void send_getNoteApplicationDataEntry(String authenticationToken, String guid, String key) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNoteApplicationDataEntry", 1, ++this.seqid_));
            getNoteApplicationDataEntry_args args = new getNoteApplicationDataEntry_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setKey(key);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public String recv_getNoteApplicationDataEntry() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNoteApplicationDataEntry failed: out of sequence response");
            }
            getNoteApplicationDataEntry_result result = new getNoteApplicationDataEntry_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNoteApplicationDataEntry failed: unknown result");
        }

        @Override
        public int setNoteApplicationDataEntry(String authenticationToken, String guid, String key, String value) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_setNoteApplicationDataEntry(authenticationToken, guid, key, value);
            return this.recv_setNoteApplicationDataEntry();
        }

        public void send_setNoteApplicationDataEntry(String authenticationToken, String guid, String key, String value) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("setNoteApplicationDataEntry", 1, ++this.seqid_));
            setNoteApplicationDataEntry_args args = new setNoteApplicationDataEntry_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setKey(key);
            args.setValue(value);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_setNoteApplicationDataEntry() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "setNoteApplicationDataEntry failed: out of sequence response");
            }
            setNoteApplicationDataEntry_result result = new setNoteApplicationDataEntry_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "setNoteApplicationDataEntry failed: unknown result");
        }

        @Override
        public int unsetNoteApplicationDataEntry(String authenticationToken, String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_unsetNoteApplicationDataEntry(authenticationToken, guid, key);
            return this.recv_unsetNoteApplicationDataEntry();
        }

        public void send_unsetNoteApplicationDataEntry(String authenticationToken, String guid, String key) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("unsetNoteApplicationDataEntry", 1, ++this.seqid_));
            unsetNoteApplicationDataEntry_args args = new unsetNoteApplicationDataEntry_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setKey(key);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_unsetNoteApplicationDataEntry() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "unsetNoteApplicationDataEntry failed: out of sequence response");
            }
            unsetNoteApplicationDataEntry_result result = new unsetNoteApplicationDataEntry_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "unsetNoteApplicationDataEntry failed: unknown result");
        }

        @Override
        public String getNoteContent(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNoteContent(authenticationToken, guid);
            return this.recv_getNoteContent();
        }

        public void send_getNoteContent(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNoteContent", 1, ++this.seqid_));
            getNoteContent_args args = new getNoteContent_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public String recv_getNoteContent() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNoteContent failed: out of sequence response");
            }
            getNoteContent_result result = new getNoteContent_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNoteContent failed: unknown result");
        }

        @Override
        public String getNoteSearchText(String authenticationToken, String guid, boolean noteOnly, boolean tokenizeForIndexing) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNoteSearchText(authenticationToken, guid, noteOnly, tokenizeForIndexing);
            return this.recv_getNoteSearchText();
        }

        public void send_getNoteSearchText(String authenticationToken, String guid, boolean noteOnly, boolean tokenizeForIndexing) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNoteSearchText", 1, ++this.seqid_));
            getNoteSearchText_args args = new getNoteSearchText_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setNoteOnly(noteOnly);
            args.setTokenizeForIndexing(tokenizeForIndexing);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public String recv_getNoteSearchText() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNoteSearchText failed: out of sequence response");
            }
            getNoteSearchText_result result = new getNoteSearchText_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNoteSearchText failed: unknown result");
        }

        @Override
        public String getResourceSearchText(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceSearchText(authenticationToken, guid);
            return this.recv_getResourceSearchText();
        }

        public void send_getResourceSearchText(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceSearchText", 1, ++this.seqid_));
            getResourceSearchText_args args = new getResourceSearchText_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public String recv_getResourceSearchText() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceSearchText failed: out of sequence response");
            }
            getResourceSearchText_result result = new getResourceSearchText_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceSearchText failed: unknown result");
        }

        @Override
        public List<String> getNoteTagNames(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNoteTagNames(authenticationToken, guid);
            return this.recv_getNoteTagNames();
        }

        public void send_getNoteTagNames(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNoteTagNames", 1, ++this.seqid_));
            getNoteTagNames_args args = new getNoteTagNames_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<String> recv_getNoteTagNames() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNoteTagNames failed: out of sequence response");
            }
            getNoteTagNames_result result = new getNoteTagNames_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNoteTagNames failed: unknown result");
        }

        @Override
        public Note createNote(String authenticationToken, Note note) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_createNote(authenticationToken, note);
            return this.recv_createNote();
        }

        public void send_createNote(String authenticationToken, Note note) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("createNote", 1, ++this.seqid_));
            createNote_args args = new createNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNote(note);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Note recv_createNote() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "createNote failed: out of sequence response");
            }
            createNote_result result = new createNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "createNote failed: unknown result");
        }

        @Override
        public Note updateNote(String authenticationToken, Note note) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_updateNote(authenticationToken, note);
            return this.recv_updateNote();
        }

        public void send_updateNote(String authenticationToken, Note note) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("updateNote", 1, ++this.seqid_));
            updateNote_args args = new updateNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNote(note);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Note recv_updateNote() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "updateNote failed: out of sequence response");
            }
            updateNote_result result = new updateNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "updateNote failed: unknown result");
        }

        @Override
        public int deleteNote(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_deleteNote(authenticationToken, guid);
            return this.recv_deleteNote();
        }

        public void send_deleteNote(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("deleteNote", 1, ++this.seqid_));
            deleteNote_args args = new deleteNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_deleteNote() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "deleteNote failed: out of sequence response");
            }
            deleteNote_result result = new deleteNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "deleteNote failed: unknown result");
        }

        @Override
        public int expungeNote(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_expungeNote(authenticationToken, guid);
            return this.recv_expungeNote();
        }

        public void send_expungeNote(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeNote", 1, ++this.seqid_));
            expungeNote_args args = new expungeNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeNote() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeNote failed: out of sequence response");
            }
            expungeNote_result result = new expungeNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "expungeNote failed: unknown result");
        }

        @Override
        public int expungeNotes(String authenticationToken, List<String> noteGuids) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_expungeNotes(authenticationToken, noteGuids);
            return this.recv_expungeNotes();
        }

        public void send_expungeNotes(String authenticationToken, List<String> noteGuids) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeNotes", 1, ++this.seqid_));
            expungeNotes_args args = new expungeNotes_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNoteGuids(noteGuids);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeNotes() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeNotes failed: out of sequence response");
            }
            expungeNotes_result result = new expungeNotes_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "expungeNotes failed: unknown result");
        }

        @Override
        public int expungeInactiveNotes(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_expungeInactiveNotes(authenticationToken);
            return this.recv_expungeInactiveNotes();
        }

        public void send_expungeInactiveNotes(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeInactiveNotes", 1, ++this.seqid_));
            expungeInactiveNotes_args args = new expungeInactiveNotes_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeInactiveNotes() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeInactiveNotes failed: out of sequence response");
            }
            expungeInactiveNotes_result result = new expungeInactiveNotes_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "expungeInactiveNotes failed: unknown result");
        }

        @Override
        public Note copyNote(String authenticationToken, String noteGuid, String toNotebookGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_copyNote(authenticationToken, noteGuid, toNotebookGuid);
            return this.recv_copyNote();
        }

        public void send_copyNote(String authenticationToken, String noteGuid, String toNotebookGuid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("copyNote", 1, ++this.seqid_));
            copyNote_args args = new copyNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNoteGuid(noteGuid);
            args.setToNotebookGuid(toNotebookGuid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Note recv_copyNote() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "copyNote failed: out of sequence response");
            }
            copyNote_result result = new copyNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "copyNote failed: unknown result");
        }

        @Override
        public List<NoteVersionId> listNoteVersions(String authenticationToken, String noteGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_listNoteVersions(authenticationToken, noteGuid);
            return this.recv_listNoteVersions();
        }

        public void send_listNoteVersions(String authenticationToken, String noteGuid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("listNoteVersions", 1, ++this.seqid_));
            listNoteVersions_args args = new listNoteVersions_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNoteGuid(noteGuid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<NoteVersionId> recv_listNoteVersions() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "listNoteVersions failed: out of sequence response");
            }
            listNoteVersions_result result = new listNoteVersions_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "listNoteVersions failed: unknown result");
        }

        @Override
        public Note getNoteVersion(String authenticationToken, String noteGuid, int updateSequenceNum, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getNoteVersion(authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
            return this.recv_getNoteVersion();
        }

        public void send_getNoteVersion(String authenticationToken, String noteGuid, int updateSequenceNum, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNoteVersion", 1, ++this.seqid_));
            getNoteVersion_args args = new getNoteVersion_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNoteGuid(noteGuid);
            args.setUpdateSequenceNum(updateSequenceNum);
            args.setWithResourcesData(withResourcesData);
            args.setWithResourcesRecognition(withResourcesRecognition);
            args.setWithResourcesAlternateData(withResourcesAlternateData);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Note recv_getNoteVersion() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNoteVersion failed: out of sequence response");
            }
            getNoteVersion_result result = new getNoteVersion_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getNoteVersion failed: unknown result");
        }

        @Override
        public Resource getResource(String authenticationToken, String guid, boolean withData, boolean withRecognition, boolean withAttributes, boolean withAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResource(authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData);
            return this.recv_getResource();
        }

        public void send_getResource(String authenticationToken, String guid, boolean withData, boolean withRecognition, boolean withAttributes, boolean withAlternateData) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResource", 1, ++this.seqid_));
            getResource_args args = new getResource_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setWithData(withData);
            args.setWithRecognition(withRecognition);
            args.setWithAttributes(withAttributes);
            args.setWithAlternateData(withAlternateData);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Resource recv_getResource() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResource failed: out of sequence response");
            }
            getResource_result result = new getResource_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResource failed: unknown result");
        }

        @Override
        public LazyMap getResourceApplicationData(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceApplicationData(authenticationToken, guid);
            return this.recv_getResourceApplicationData();
        }

        public void send_getResourceApplicationData(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceApplicationData", 1, ++this.seqid_));
            getResourceApplicationData_args args = new getResourceApplicationData_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public LazyMap recv_getResourceApplicationData() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceApplicationData failed: out of sequence response");
            }
            getResourceApplicationData_result result = new getResourceApplicationData_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceApplicationData failed: unknown result");
        }

        @Override
        public String getResourceApplicationDataEntry(String authenticationToken, String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceApplicationDataEntry(authenticationToken, guid, key);
            return this.recv_getResourceApplicationDataEntry();
        }

        public void send_getResourceApplicationDataEntry(String authenticationToken, String guid, String key) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceApplicationDataEntry", 1, ++this.seqid_));
            getResourceApplicationDataEntry_args args = new getResourceApplicationDataEntry_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setKey(key);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public String recv_getResourceApplicationDataEntry() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceApplicationDataEntry failed: out of sequence response");
            }
            getResourceApplicationDataEntry_result result = new getResourceApplicationDataEntry_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceApplicationDataEntry failed: unknown result");
        }

        @Override
        public int setResourceApplicationDataEntry(String authenticationToken, String guid, String key, String value) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_setResourceApplicationDataEntry(authenticationToken, guid, key, value);
            return this.recv_setResourceApplicationDataEntry();
        }

        public void send_setResourceApplicationDataEntry(String authenticationToken, String guid, String key, String value) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("setResourceApplicationDataEntry", 1, ++this.seqid_));
            setResourceApplicationDataEntry_args args = new setResourceApplicationDataEntry_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setKey(key);
            args.setValue(value);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_setResourceApplicationDataEntry() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "setResourceApplicationDataEntry failed: out of sequence response");
            }
            setResourceApplicationDataEntry_result result = new setResourceApplicationDataEntry_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "setResourceApplicationDataEntry failed: unknown result");
        }

        @Override
        public int unsetResourceApplicationDataEntry(String authenticationToken, String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_unsetResourceApplicationDataEntry(authenticationToken, guid, key);
            return this.recv_unsetResourceApplicationDataEntry();
        }

        public void send_unsetResourceApplicationDataEntry(String authenticationToken, String guid, String key) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("unsetResourceApplicationDataEntry", 1, ++this.seqid_));
            unsetResourceApplicationDataEntry_args args = new unsetResourceApplicationDataEntry_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.setKey(key);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_unsetResourceApplicationDataEntry() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "unsetResourceApplicationDataEntry failed: out of sequence response");
            }
            unsetResourceApplicationDataEntry_result result = new unsetResourceApplicationDataEntry_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "unsetResourceApplicationDataEntry failed: unknown result");
        }

        @Override
        public int updateResource(String authenticationToken, Resource resource) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_updateResource(authenticationToken, resource);
            return this.recv_updateResource();
        }

        public void send_updateResource(String authenticationToken, Resource resource) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("updateResource", 1, ++this.seqid_));
            updateResource_args args = new updateResource_args();
            args.setAuthenticationToken(authenticationToken);
            args.setResource(resource);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_updateResource() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "updateResource failed: out of sequence response");
            }
            updateResource_result result = new updateResource_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "updateResource failed: unknown result");
        }

        @Override
        public byte[] getResourceData(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceData(authenticationToken, guid);
            return this.recv_getResourceData();
        }

        public void send_getResourceData(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceData", 1, ++this.seqid_));
            getResourceData_args args = new getResourceData_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public byte[] recv_getResourceData() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceData failed: out of sequence response");
            }
            getResourceData_result result = new getResourceData_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceData failed: unknown result");
        }

        @Override
        public Resource getResourceByHash(String authenticationToken, String noteGuid, byte[] contentHash, boolean withData, boolean withRecognition, boolean withAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceByHash(authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData);
            return this.recv_getResourceByHash();
        }

        public void send_getResourceByHash(String authenticationToken, String noteGuid, byte[] contentHash, boolean withData, boolean withRecognition, boolean withAlternateData) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceByHash", 1, ++this.seqid_));
            getResourceByHash_args args = new getResourceByHash_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNoteGuid(noteGuid);
            args.setContentHash(contentHash);
            args.setWithData(withData);
            args.setWithRecognition(withRecognition);
            args.setWithAlternateData(withAlternateData);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Resource recv_getResourceByHash() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceByHash failed: out of sequence response");
            }
            getResourceByHash_result result = new getResourceByHash_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceByHash failed: unknown result");
        }

        @Override
        public byte[] getResourceRecognition(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceRecognition(authenticationToken, guid);
            return this.recv_getResourceRecognition();
        }

        public void send_getResourceRecognition(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceRecognition", 1, ++this.seqid_));
            getResourceRecognition_args args = new getResourceRecognition_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public byte[] recv_getResourceRecognition() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceRecognition failed: out of sequence response");
            }
            getResourceRecognition_result result = new getResourceRecognition_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceRecognition failed: unknown result");
        }

        @Override
        public byte[] getResourceAlternateData(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceAlternateData(authenticationToken, guid);
            return this.recv_getResourceAlternateData();
        }

        public void send_getResourceAlternateData(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceAlternateData", 1, ++this.seqid_));
            getResourceAlternateData_args args = new getResourceAlternateData_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public byte[] recv_getResourceAlternateData() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceAlternateData failed: out of sequence response");
            }
            getResourceAlternateData_result result = new getResourceAlternateData_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceAlternateData failed: unknown result");
        }

        @Override
        public ResourceAttributes getResourceAttributes(String authenticationToken, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getResourceAttributes(authenticationToken, guid);
            return this.recv_getResourceAttributes();
        }

        public void send_getResourceAttributes(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getResourceAttributes", 1, ++this.seqid_));
            getResourceAttributes_args args = new getResourceAttributes_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public ResourceAttributes recv_getResourceAttributes() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getResourceAttributes failed: out of sequence response");
            }
            getResourceAttributes_result result = new getResourceAttributes_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getResourceAttributes failed: unknown result");
        }

        @Override
        public Notebook getPublicNotebook(int userId, String publicUri) throws EDAMSystemException, EDAMNotFoundException, TException {
            this.send_getPublicNotebook(userId, publicUri);
            return this.recv_getPublicNotebook();
        }

        public void send_getPublicNotebook(int userId, String publicUri) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getPublicNotebook", 1, ++this.seqid_));
            getPublicNotebook_args args = new getPublicNotebook_args();
            args.setUserId(userId);
            args.setPublicUri(publicUri);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public Notebook recv_getPublicNotebook() throws EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getPublicNotebook failed: out of sequence response");
            }
            getPublicNotebook_result result = new getPublicNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "getPublicNotebook failed: unknown result");
        }

        @Override
        public SharedNotebook createSharedNotebook(String authenticationToken, SharedNotebook sharedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_createSharedNotebook(authenticationToken, sharedNotebook);
            return this.recv_createSharedNotebook();
        }

        public void send_createSharedNotebook(String authenticationToken, SharedNotebook sharedNotebook) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("createSharedNotebook", 1, ++this.seqid_));
            createSharedNotebook_args args = new createSharedNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setSharedNotebook(sharedNotebook);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SharedNotebook recv_createSharedNotebook() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "createSharedNotebook failed: out of sequence response");
            }
            createSharedNotebook_result result = new createSharedNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "createSharedNotebook failed: unknown result");
        }

        @Override
        public int updateSharedNotebook(String authenticationToken, SharedNotebook sharedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_updateSharedNotebook(authenticationToken, sharedNotebook);
            return this.recv_updateSharedNotebook();
        }

        public void send_updateSharedNotebook(String authenticationToken, SharedNotebook sharedNotebook) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("updateSharedNotebook", 1, ++this.seqid_));
            updateSharedNotebook_args args = new updateSharedNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setSharedNotebook(sharedNotebook);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_updateSharedNotebook() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "updateSharedNotebook failed: out of sequence response");
            }
            updateSharedNotebook_result result = new updateSharedNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "updateSharedNotebook failed: unknown result");
        }

        @Override
        public int setSharedNotebookRecipientSettings(String authenticationToken, long sharedNotebookId, SharedNotebookRecipientSettings recipientSettings) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_setSharedNotebookRecipientSettings(authenticationToken, sharedNotebookId, recipientSettings);
            return this.recv_setSharedNotebookRecipientSettings();
        }

        public void send_setSharedNotebookRecipientSettings(String authenticationToken, long sharedNotebookId, SharedNotebookRecipientSettings recipientSettings) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("setSharedNotebookRecipientSettings", 1, ++this.seqid_));
            setSharedNotebookRecipientSettings_args args = new setSharedNotebookRecipientSettings_args();
            args.setAuthenticationToken(authenticationToken);
            args.setSharedNotebookId(sharedNotebookId);
            args.setRecipientSettings(recipientSettings);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_setSharedNotebookRecipientSettings() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "setSharedNotebookRecipientSettings failed: out of sequence response");
            }
            setSharedNotebookRecipientSettings_result result = new setSharedNotebookRecipientSettings_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "setSharedNotebookRecipientSettings failed: unknown result");
        }

        @Override
        public int sendMessageToSharedNotebookMembers(String authenticationToken, String notebookGuid, String messageText, List<String> recipients) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_sendMessageToSharedNotebookMembers(authenticationToken, notebookGuid, messageText, recipients);
            return this.recv_sendMessageToSharedNotebookMembers();
        }

        public void send_sendMessageToSharedNotebookMembers(String authenticationToken, String notebookGuid, String messageText, List<String> recipients) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("sendMessageToSharedNotebookMembers", 1, ++this.seqid_));
            sendMessageToSharedNotebookMembers_args args = new sendMessageToSharedNotebookMembers_args();
            args.setAuthenticationToken(authenticationToken);
            args.setNotebookGuid(notebookGuid);
            args.setMessageText(messageText);
            args.setRecipients(recipients);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_sendMessageToSharedNotebookMembers() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "sendMessageToSharedNotebookMembers failed: out of sequence response");
            }
            sendMessageToSharedNotebookMembers_result result = new sendMessageToSharedNotebookMembers_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "sendMessageToSharedNotebookMembers failed: unknown result");
        }

        @Override
        public List<SharedNotebook> listSharedNotebooks(String authenticationToken) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_listSharedNotebooks(authenticationToken);
            return this.recv_listSharedNotebooks();
        }

        public void send_listSharedNotebooks(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("listSharedNotebooks", 1, ++this.seqid_));
            listSharedNotebooks_args args = new listSharedNotebooks_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<SharedNotebook> recv_listSharedNotebooks() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "listSharedNotebooks failed: out of sequence response");
            }
            listSharedNotebooks_result result = new listSharedNotebooks_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "listSharedNotebooks failed: unknown result");
        }

        @Override
        public int expungeSharedNotebooks(String authenticationToken, List<Long> sharedNotebookIds) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_expungeSharedNotebooks(authenticationToken, sharedNotebookIds);
            return this.recv_expungeSharedNotebooks();
        }

        public void send_expungeSharedNotebooks(String authenticationToken, List<Long> sharedNotebookIds) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeSharedNotebooks", 1, ++this.seqid_));
            expungeSharedNotebooks_args args = new expungeSharedNotebooks_args();
            args.setAuthenticationToken(authenticationToken);
            args.setSharedNotebookIds(sharedNotebookIds);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeSharedNotebooks() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeSharedNotebooks failed: out of sequence response");
            }
            expungeSharedNotebooks_result result = new expungeSharedNotebooks_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "expungeSharedNotebooks failed: unknown result");
        }

        @Override
        public LinkedNotebook createLinkedNotebook(String authenticationToken, LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_createLinkedNotebook(authenticationToken, linkedNotebook);
            return this.recv_createLinkedNotebook();
        }

        public void send_createLinkedNotebook(String authenticationToken, LinkedNotebook linkedNotebook) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("createLinkedNotebook", 1, ++this.seqid_));
            createLinkedNotebook_args args = new createLinkedNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setLinkedNotebook(linkedNotebook);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public LinkedNotebook recv_createLinkedNotebook() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "createLinkedNotebook failed: out of sequence response");
            }
            createLinkedNotebook_result result = new createLinkedNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "createLinkedNotebook failed: unknown result");
        }

        @Override
        public int updateLinkedNotebook(String authenticationToken, LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_updateLinkedNotebook(authenticationToken, linkedNotebook);
            return this.recv_updateLinkedNotebook();
        }

        public void send_updateLinkedNotebook(String authenticationToken, LinkedNotebook linkedNotebook) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("updateLinkedNotebook", 1, ++this.seqid_));
            updateLinkedNotebook_args args = new updateLinkedNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setLinkedNotebook(linkedNotebook);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_updateLinkedNotebook() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "updateLinkedNotebook failed: out of sequence response");
            }
            updateLinkedNotebook_result result = new updateLinkedNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "updateLinkedNotebook failed: unknown result");
        }

        @Override
        public List<LinkedNotebook> listLinkedNotebooks(String authenticationToken) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_listLinkedNotebooks(authenticationToken);
            return this.recv_listLinkedNotebooks();
        }

        public void send_listLinkedNotebooks(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("listLinkedNotebooks", 1, ++this.seqid_));
            listLinkedNotebooks_args args = new listLinkedNotebooks_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public List<LinkedNotebook> recv_listLinkedNotebooks() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "listLinkedNotebooks failed: out of sequence response");
            }
            listLinkedNotebooks_result result = new listLinkedNotebooks_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "listLinkedNotebooks failed: unknown result");
        }

        @Override
        public int expungeLinkedNotebook(String authenticationToken, String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_expungeLinkedNotebook(authenticationToken, guid);
            return this.recv_expungeLinkedNotebook();
        }

        public void send_expungeLinkedNotebook(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("expungeLinkedNotebook", 1, ++this.seqid_));
            expungeLinkedNotebook_args args = new expungeLinkedNotebook_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public int recv_expungeLinkedNotebook() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "expungeLinkedNotebook failed: out of sequence response");
            }
            expungeLinkedNotebook_result result = new expungeLinkedNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "expungeLinkedNotebook failed: unknown result");
        }

        @Override
        public AuthenticationResult authenticateToSharedNotebook(String shareKey, String authenticationToken) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_authenticateToSharedNotebook(shareKey, authenticationToken);
            return this.recv_authenticateToSharedNotebook();
        }

        public void send_authenticateToSharedNotebook(String shareKey, String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("authenticateToSharedNotebook", 1, ++this.seqid_));
            authenticateToSharedNotebook_args args = new authenticateToSharedNotebook_args();
            args.setShareKey(shareKey);
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public AuthenticationResult recv_authenticateToSharedNotebook() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "authenticateToSharedNotebook failed: out of sequence response");
            }
            authenticateToSharedNotebook_result result = new authenticateToSharedNotebook_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "authenticateToSharedNotebook failed: unknown result");
        }

        @Override
        public SharedNotebook getSharedNotebookByAuth(String authenticationToken) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_getSharedNotebookByAuth(authenticationToken);
            return this.recv_getSharedNotebookByAuth();
        }

        public void send_getSharedNotebookByAuth(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getSharedNotebookByAuth", 1, ++this.seqid_));
            getSharedNotebookByAuth_args args = new getSharedNotebookByAuth_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public SharedNotebook recv_getSharedNotebookByAuth() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getSharedNotebookByAuth failed: out of sequence response");
            }
            getSharedNotebookByAuth_result result = new getSharedNotebookByAuth_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getSharedNotebookByAuth failed: unknown result");
        }

        @Override
        public void emailNote(String authenticationToken, NoteEmailParameters parameters) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_emailNote(authenticationToken, parameters);
            this.recv_emailNote();
        }

        public void send_emailNote(String authenticationToken, NoteEmailParameters parameters) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("emailNote", 1, ++this.seqid_));
            emailNote_args args = new emailNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setParameters(parameters);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public void recv_emailNote() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "emailNote failed: out of sequence response");
            }
            emailNote_result result = new emailNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
        }

        @Override
        public String shareNote(String authenticationToken, String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_shareNote(authenticationToken, guid);
            return this.recv_shareNote();
        }

        public void send_shareNote(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("shareNote", 1, ++this.seqid_));
            shareNote_args args = new shareNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public String recv_shareNote() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "shareNote failed: out of sequence response");
            }
            shareNote_result result = new shareNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "shareNote failed: unknown result");
        }

        @Override
        public void stopSharingNote(String authenticationToken, String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_stopSharingNote(authenticationToken, guid);
            this.recv_stopSharingNote();
        }

        public void send_stopSharingNote(String authenticationToken, String guid) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("stopSharingNote", 1, ++this.seqid_));
            stopSharingNote_args args = new stopSharingNote_args();
            args.setAuthenticationToken(authenticationToken);
            args.setGuid(guid);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public void recv_stopSharingNote() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "stopSharingNote failed: out of sequence response");
            }
            stopSharingNote_result result = new stopSharingNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
        }

        @Override
        public AuthenticationResult authenticateToSharedNote(String guid, String noteKey, String authenticationToken) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            this.send_authenticateToSharedNote(guid, noteKey, authenticationToken);
            return this.recv_authenticateToSharedNote();
        }

        public void send_authenticateToSharedNote(String guid, String noteKey, String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("authenticateToSharedNote", 1, ++this.seqid_));
            authenticateToSharedNote_args args = new authenticateToSharedNote_args();
            args.setGuid(guid);
            args.setNoteKey(noteKey);
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public AuthenticationResult recv_authenticateToSharedNote() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "authenticateToSharedNote failed: out of sequence response");
            }
            authenticateToSharedNote_result result = new authenticateToSharedNote_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "authenticateToSharedNote failed: unknown result");
        }

        @Override
        public RelatedResult findRelated(String authenticationToken, RelatedQuery query, RelatedResultSpec resultSpec) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            this.send_findRelated(authenticationToken, query, resultSpec);
            return this.recv_findRelated();
        }

        public void send_findRelated(String authenticationToken, RelatedQuery query, RelatedResultSpec resultSpec) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("findRelated", 1, ++this.seqid_));
            findRelated_args args = new findRelated_args();
            args.setAuthenticationToken(authenticationToken);
            args.setQuery(query);
            args.setResultSpec(resultSpec);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public RelatedResult recv_findRelated() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "findRelated failed: out of sequence response");
            }
            findRelated_result result = new findRelated_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            throw new TApplicationException(5, "findRelated failed: unknown result");
        }
    }

    public static interface Iface
    extends NoteStoreIface {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateToSharedNote_args
    implements TBase<authenticateToSharedNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateToSharedNote_args");
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 1);
        private static final TField NOTE_KEY_FIELD_DESC = new TField("noteKey", 11, 2);
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 3);
        private String guid;
        private String noteKey;
        private String authenticationToken;

        public authenticateToSharedNote_args() {
        }

        public authenticateToSharedNote_args(authenticateToSharedNote_args other) {
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            if (other.isSetNoteKey()) {
                this.noteKey = other.noteKey;
            }
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public authenticateToSharedNote_args deepCopy() {
            return new authenticateToSharedNote_args(this);
        }

        @Override
        public void clear() {
            this.guid = null;
            this.noteKey = null;
            this.authenticationToken = null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setNoteKey(String noteKey) {
            this.noteKey = noteKey;
        }

        public boolean isSetNoteKey() {
            return this.noteKey != null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(authenticateToSharedNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateToSharedNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNoteKey()).compareTo(typedOther.isSetNoteKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNoteKey() && (lastComparison = TBaseHelper.compareTo(this.noteKey, typedOther.noteKey)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.noteKey = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            if (this.noteKey != null) {
                oprot.writeFieldBegin(NOTE_KEY_FIELD_DESC);
                oprot.writeString(this.noteKey);
                oprot.writeFieldEnd();
            }
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateToSharedNote_result
    implements TBase<authenticateToSharedNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateToSharedNote_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private AuthenticationResult success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public authenticateToSharedNote_result() {
        }

        public authenticateToSharedNote_result(authenticateToSharedNote_result other) {
            if (other.isSetSuccess()) {
                this.success = new AuthenticationResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public authenticateToSharedNote_result deepCopy() {
            return new authenticateToSharedNote_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(authenticateToSharedNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateToSharedNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new AuthenticationResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateToSharedNotebook_args
    implements TBase<authenticateToSharedNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateToSharedNotebook_args");
        private static final TField SHARE_KEY_FIELD_DESC = new TField("shareKey", 11, 1);
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 2);
        private String shareKey;
        private String authenticationToken;

        public authenticateToSharedNotebook_args() {
        }

        public authenticateToSharedNotebook_args(authenticateToSharedNotebook_args other) {
            if (other.isSetShareKey()) {
                this.shareKey = other.shareKey;
            }
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public authenticateToSharedNotebook_args deepCopy() {
            return new authenticateToSharedNotebook_args(this);
        }

        @Override
        public void clear() {
            this.shareKey = null;
            this.authenticationToken = null;
        }

        public void setShareKey(String shareKey) {
            this.shareKey = shareKey;
        }

        public boolean isSetShareKey() {
            return this.shareKey != null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(authenticateToSharedNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateToSharedNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetShareKey()).compareTo(typedOther.isSetShareKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetShareKey() && (lastComparison = TBaseHelper.compareTo(this.shareKey, typedOther.shareKey)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.shareKey = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.shareKey != null) {
                oprot.writeFieldBegin(SHARE_KEY_FIELD_DESC);
                oprot.writeString(this.shareKey);
                oprot.writeFieldEnd();
            }
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateToSharedNotebook_result
    implements TBase<authenticateToSharedNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateToSharedNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private AuthenticationResult success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public authenticateToSharedNotebook_result() {
        }

        public authenticateToSharedNotebook_result(authenticateToSharedNotebook_result other) {
            if (other.isSetSuccess()) {
                this.success = new AuthenticationResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public authenticateToSharedNotebook_result deepCopy() {
            return new authenticateToSharedNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(authenticateToSharedNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateToSharedNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new AuthenticationResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class copyNote_args
    implements TBase<copyNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("copyNote_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTE_GUID_FIELD_DESC = new TField("noteGuid", 11, 2);
        private static final TField TO_NOTEBOOK_GUID_FIELD_DESC = new TField("toNotebookGuid", 11, 3);
        private String authenticationToken;
        private String noteGuid;
        private String toNotebookGuid;

        public copyNote_args() {
        }

        public copyNote_args(copyNote_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNoteGuid()) {
                this.noteGuid = other.noteGuid;
            }
            if (other.isSetToNotebookGuid()) {
                this.toNotebookGuid = other.toNotebookGuid;
            }
        }

        public copyNote_args deepCopy() {
            return new copyNote_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.noteGuid = null;
            this.toNotebookGuid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNoteGuid(String noteGuid) {
            this.noteGuid = noteGuid;
        }

        public boolean isSetNoteGuid() {
            return this.noteGuid != null;
        }

        public void setToNotebookGuid(String toNotebookGuid) {
            this.toNotebookGuid = toNotebookGuid;
        }

        public boolean isSetToNotebookGuid() {
            return this.toNotebookGuid != null;
        }

        @Override
        public int compareTo(copyNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            copyNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNoteGuid()).compareTo(typedOther.isSetNoteGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNoteGuid() && (lastComparison = TBaseHelper.compareTo(this.noteGuid, typedOther.noteGuid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetToNotebookGuid()).compareTo(typedOther.isSetToNotebookGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetToNotebookGuid() && (lastComparison = TBaseHelper.compareTo(this.toNotebookGuid, typedOther.toNotebookGuid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.noteGuid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.toNotebookGuid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.noteGuid != null) {
                oprot.writeFieldBegin(NOTE_GUID_FIELD_DESC);
                oprot.writeString(this.noteGuid);
                oprot.writeFieldEnd();
            }
            if (this.toNotebookGuid != null) {
                oprot.writeFieldBegin(TO_NOTEBOOK_GUID_FIELD_DESC);
                oprot.writeString(this.toNotebookGuid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class copyNote_result
    implements TBase<copyNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("copyNote_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Note success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public copyNote_result() {
        }

        public copyNote_result(copyNote_result other) {
            if (other.isSetSuccess()) {
                this.success = new Note(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public copyNote_result deepCopy() {
            return new copyNote_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(copyNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            copyNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Note();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createLinkedNotebook_args
    implements TBase<createLinkedNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createLinkedNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField LINKED_NOTEBOOK_FIELD_DESC = new TField("linkedNotebook", 12, 2);
        private String authenticationToken;
        private LinkedNotebook linkedNotebook;

        public createLinkedNotebook_args() {
        }

        public createLinkedNotebook_args(createLinkedNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetLinkedNotebook()) {
                this.linkedNotebook = new LinkedNotebook(other.linkedNotebook);
            }
        }

        public createLinkedNotebook_args deepCopy() {
            return new createLinkedNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.linkedNotebook = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setLinkedNotebook(LinkedNotebook linkedNotebook) {
            this.linkedNotebook = linkedNotebook;
        }

        public boolean isSetLinkedNotebook() {
            return this.linkedNotebook != null;
        }

        @Override
        public int compareTo(createLinkedNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createLinkedNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetLinkedNotebook()).compareTo(typedOther.isSetLinkedNotebook());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetLinkedNotebook() && (lastComparison = TBaseHelper.compareTo(this.linkedNotebook, typedOther.linkedNotebook)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.linkedNotebook = new LinkedNotebook();
                            this.linkedNotebook.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.linkedNotebook != null) {
                oprot.writeFieldBegin(LINKED_NOTEBOOK_FIELD_DESC);
                this.linkedNotebook.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createLinkedNotebook_result
    implements TBase<createLinkedNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createLinkedNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private LinkedNotebook success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public createLinkedNotebook_result() {
        }

        public createLinkedNotebook_result(createLinkedNotebook_result other) {
            if (other.isSetSuccess()) {
                this.success = new LinkedNotebook(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public createLinkedNotebook_result deepCopy() {
            return new createLinkedNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(createLinkedNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createLinkedNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new LinkedNotebook();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createNote_args
    implements TBase<createNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createNote_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTE_FIELD_DESC = new TField("note", 12, 2);
        private String authenticationToken;
        private Note note;

        public createNote_args() {
        }

        public createNote_args(createNote_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNote()) {
                this.note = new Note(other.note);
            }
        }

        public createNote_args deepCopy() {
            return new createNote_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.note = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNote(Note note) {
            this.note = note;
        }

        public boolean isSetNote() {
            return this.note != null;
        }

        @Override
        public int compareTo(createNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNote()).compareTo(typedOther.isSetNote());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNote() && (lastComparison = TBaseHelper.compareTo(this.note, typedOther.note)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.note = new Note();
                            this.note.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.note != null) {
                oprot.writeFieldBegin(NOTE_FIELD_DESC);
                this.note.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createNote_result
    implements TBase<createNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createNote_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Note success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public createNote_result() {
        }

        public createNote_result(createNote_result other) {
            if (other.isSetSuccess()) {
                this.success = new Note(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public createNote_result deepCopy() {
            return new createNote_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(createNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Note();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createNotebook_args
    implements TBase<createNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTEBOOK_FIELD_DESC = new TField("notebook", 12, 2);
        private String authenticationToken;
        private Notebook notebook;

        public createNotebook_args() {
        }

        public createNotebook_args(createNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNotebook()) {
                this.notebook = new Notebook(other.notebook);
            }
        }

        public createNotebook_args deepCopy() {
            return new createNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.notebook = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNotebook(Notebook notebook) {
            this.notebook = notebook;
        }

        public boolean isSetNotebook() {
            return this.notebook != null;
        }

        @Override
        public int compareTo(createNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotebook()).compareTo(typedOther.isSetNotebook());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotebook() && (lastComparison = TBaseHelper.compareTo(this.notebook, typedOther.notebook)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notebook = new Notebook();
                            this.notebook.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.notebook != null) {
                oprot.writeFieldBegin(NOTEBOOK_FIELD_DESC);
                this.notebook.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createNotebook_result
    implements TBase<createNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private Notebook success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public createNotebook_result() {
        }

        public createNotebook_result(createNotebook_result other) {
            if (other.isSetSuccess()) {
                this.success = new Notebook(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public createNotebook_result deepCopy() {
            return new createNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(createNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Notebook();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createSearch_args
    implements TBase<createSearch_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createSearch_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField SEARCH_FIELD_DESC = new TField("search", 12, 2);
        private String authenticationToken;
        private SavedSearch search;

        public createSearch_args() {
        }

        public createSearch_args(createSearch_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetSearch()) {
                this.search = new SavedSearch(other.search);
            }
        }

        public createSearch_args deepCopy() {
            return new createSearch_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.search = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setSearch(SavedSearch search) {
            this.search = search;
        }

        public boolean isSetSearch() {
            return this.search != null;
        }

        @Override
        public int compareTo(createSearch_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createSearch_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSearch()).compareTo(typedOther.isSetSearch());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSearch() && (lastComparison = TBaseHelper.compareTo(this.search, typedOther.search)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.search = new SavedSearch();
                            this.search.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.search != null) {
                oprot.writeFieldBegin(SEARCH_FIELD_DESC);
                this.search.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createSearch_result
    implements TBase<createSearch_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createSearch_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private SavedSearch success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public createSearch_result() {
        }

        public createSearch_result(createSearch_result other) {
            if (other.isSetSuccess()) {
                this.success = new SavedSearch(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public createSearch_result deepCopy() {
            return new createSearch_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(createSearch_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createSearch_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SavedSearch();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createSharedNotebook_args
    implements TBase<createSharedNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createSharedNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField SHARED_NOTEBOOK_FIELD_DESC = new TField("sharedNotebook", 12, 2);
        private String authenticationToken;
        private SharedNotebook sharedNotebook;

        public createSharedNotebook_args() {
        }

        public createSharedNotebook_args(createSharedNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetSharedNotebook()) {
                this.sharedNotebook = new SharedNotebook(other.sharedNotebook);
            }
        }

        public createSharedNotebook_args deepCopy() {
            return new createSharedNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.sharedNotebook = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setSharedNotebook(SharedNotebook sharedNotebook) {
            this.sharedNotebook = sharedNotebook;
        }

        public boolean isSetSharedNotebook() {
            return this.sharedNotebook != null;
        }

        @Override
        public int compareTo(createSharedNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createSharedNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSharedNotebook()).compareTo(typedOther.isSetSharedNotebook());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSharedNotebook() && (lastComparison = TBaseHelper.compareTo(this.sharedNotebook, typedOther.sharedNotebook)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.sharedNotebook = new SharedNotebook();
                            this.sharedNotebook.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.sharedNotebook != null) {
                oprot.writeFieldBegin(SHARED_NOTEBOOK_FIELD_DESC);
                this.sharedNotebook.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createSharedNotebook_result
    implements TBase<createSharedNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createSharedNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private SharedNotebook success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public createSharedNotebook_result() {
        }

        public createSharedNotebook_result(createSharedNotebook_result other) {
            if (other.isSetSuccess()) {
                this.success = new SharedNotebook(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public createSharedNotebook_result deepCopy() {
            return new createSharedNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(createSharedNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createSharedNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SharedNotebook();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createTag_args
    implements TBase<createTag_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createTag_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField TAG_FIELD_DESC = new TField("tag", 12, 2);
        private String authenticationToken;
        private Tag tag;

        public createTag_args() {
        }

        public createTag_args(createTag_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetTag()) {
                this.tag = new Tag(other.tag);
            }
        }

        public createTag_args deepCopy() {
            return new createTag_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.tag = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setTag(Tag tag) {
            this.tag = tag;
        }

        public boolean isSetTag() {
            return this.tag != null;
        }

        @Override
        public int compareTo(createTag_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createTag_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTag()).compareTo(typedOther.isSetTag());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTag() && (lastComparison = TBaseHelper.compareTo(this.tag, typedOther.tag)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.tag = new Tag();
                            this.tag.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.tag != null) {
                oprot.writeFieldBegin(TAG_FIELD_DESC);
                this.tag.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class createTag_result
    implements TBase<createTag_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("createTag_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Tag success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public createTag_result() {
        }

        public createTag_result(createTag_result other) {
            if (other.isSetSuccess()) {
                this.success = new Tag(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public createTag_result deepCopy() {
            return new createTag_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(createTag_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            createTag_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Tag();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class deleteNote_args
    implements TBase<deleteNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("deleteNote_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public deleteNote_args() {
        }

        public deleteNote_args(deleteNote_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public deleteNote_args deepCopy() {
            return new deleteNote_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(deleteNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            deleteNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class deleteNote_result
    implements TBase<deleteNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("deleteNote_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public deleteNote_result() {
        }

        public deleteNote_result(deleteNote_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public deleteNote_result deepCopy() {
            return new deleteNote_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(deleteNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            deleteNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class emailNote_args
    implements TBase<emailNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("emailNote_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 12, 2);
        private String authenticationToken;
        private NoteEmailParameters parameters;

        public emailNote_args() {
        }

        public emailNote_args(emailNote_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetParameters()) {
                this.parameters = new NoteEmailParameters(other.parameters);
            }
        }

        public emailNote_args deepCopy() {
            return new emailNote_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.parameters = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setParameters(NoteEmailParameters parameters) {
            this.parameters = parameters;
        }

        public boolean isSetParameters() {
            return this.parameters != null;
        }

        @Override
        public int compareTo(emailNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            emailNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetParameters()).compareTo(typedOther.isSetParameters());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, typedOther.parameters)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.parameters = new NoteEmailParameters();
                            this.parameters.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.parameters != null) {
                oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
                this.parameters.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class emailNote_result
    implements TBase<emailNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("emailNote_result");
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public emailNote_result() {
        }

        public emailNote_result(emailNote_result other) {
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public emailNote_result deepCopy() {
            return new emailNote_result(this);
        }

        @Override
        public void clear() {
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(emailNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            emailNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeInactiveNotes_args
    implements TBase<expungeInactiveNotes_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeInactiveNotes_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public expungeInactiveNotes_args() {
        }

        public expungeInactiveNotes_args(expungeInactiveNotes_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public expungeInactiveNotes_args deepCopy() {
            return new expungeInactiveNotes_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(expungeInactiveNotes_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeInactiveNotes_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeInactiveNotes_result
    implements TBase<expungeInactiveNotes_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeInactiveNotes_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeInactiveNotes_result() {
        }

        public expungeInactiveNotes_result(expungeInactiveNotes_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public expungeInactiveNotes_result deepCopy() {
            return new expungeInactiveNotes_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(expungeInactiveNotes_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeInactiveNotes_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeLinkedNotebook_args
    implements TBase<expungeLinkedNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeLinkedNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public expungeLinkedNotebook_args() {
        }

        public expungeLinkedNotebook_args(expungeLinkedNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public expungeLinkedNotebook_args deepCopy() {
            return new expungeLinkedNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(expungeLinkedNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeLinkedNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeLinkedNotebook_result
    implements TBase<expungeLinkedNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeLinkedNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeLinkedNotebook_result() {
        }

        public expungeLinkedNotebook_result(expungeLinkedNotebook_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public expungeLinkedNotebook_result deepCopy() {
            return new expungeLinkedNotebook_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(expungeLinkedNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeLinkedNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeNote_args
    implements TBase<expungeNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeNote_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public expungeNote_args() {
        }

        public expungeNote_args(expungeNote_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public expungeNote_args deepCopy() {
            return new expungeNote_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(expungeNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeNote_result
    implements TBase<expungeNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeNote_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeNote_result() {
        }

        public expungeNote_result(expungeNote_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public expungeNote_result deepCopy() {
            return new expungeNote_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(expungeNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeNotebook_args
    implements TBase<expungeNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public expungeNotebook_args() {
        }

        public expungeNotebook_args(expungeNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public expungeNotebook_args deepCopy() {
            return new expungeNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(expungeNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeNotebook_result
    implements TBase<expungeNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeNotebook_result() {
        }

        public expungeNotebook_result(expungeNotebook_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public expungeNotebook_result deepCopy() {
            return new expungeNotebook_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(expungeNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeNotes_args
    implements TBase<expungeNotes_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeNotes_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTE_GUIDS_FIELD_DESC = new TField("noteGuids", 15, 2);
        private String authenticationToken;
        private List<String> noteGuids;

        public expungeNotes_args() {
        }

        public expungeNotes_args(expungeNotes_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNoteGuids()) {
                ArrayList<String> __this__noteGuids = new ArrayList<String>();
                for (String other_element : other.noteGuids) {
                    __this__noteGuids.add(other_element);
                }
                this.noteGuids = __this__noteGuids;
            }
        }

        public expungeNotes_args deepCopy() {
            return new expungeNotes_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.noteGuids = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNoteGuids(List<String> noteGuids) {
            this.noteGuids = noteGuids;
        }

        public boolean isSetNoteGuids() {
            return this.noteGuids != null;
        }

        @Override
        public int compareTo(expungeNotes_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeNotes_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNoteGuids()).compareTo(typedOther.isSetNoteGuids());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNoteGuids() && (lastComparison = TBaseHelper.compareTo(this.noteGuids, typedOther.noteGuids)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 15) {
                            TList _list130 = iprot.readListBegin();
                            this.noteGuids = new ArrayList<String>(_list130.size);
                            int _i131 = 0;
                            while (_i131 < _list130.size) {
                                String _elem132 = iprot.readString();
                                this.noteGuids.add(_elem132);
                                ++_i131;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.noteGuids != null) {
                oprot.writeFieldBegin(NOTE_GUIDS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, this.noteGuids.size()));
                for (String _iter133 : this.noteGuids) {
                    oprot.writeString(_iter133);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeNotes_result
    implements TBase<expungeNotes_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeNotes_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeNotes_result() {
        }

        public expungeNotes_result(expungeNotes_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public expungeNotes_result deepCopy() {
            return new expungeNotes_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(expungeNotes_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeNotes_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeSearch_args
    implements TBase<expungeSearch_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeSearch_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public expungeSearch_args() {
        }

        public expungeSearch_args(expungeSearch_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public expungeSearch_args deepCopy() {
            return new expungeSearch_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(expungeSearch_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeSearch_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeSearch_result
    implements TBase<expungeSearch_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeSearch_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeSearch_result() {
        }

        public expungeSearch_result(expungeSearch_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public expungeSearch_result deepCopy() {
            return new expungeSearch_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(expungeSearch_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeSearch_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeSharedNotebooks_args
    implements TBase<expungeSharedNotebooks_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeSharedNotebooks_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField SHARED_NOTEBOOK_IDS_FIELD_DESC = new TField("sharedNotebookIds", 15, 2);
        private String authenticationToken;
        private List<Long> sharedNotebookIds;

        public expungeSharedNotebooks_args() {
        }

        public expungeSharedNotebooks_args(expungeSharedNotebooks_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetSharedNotebookIds()) {
                ArrayList<Long> __this__sharedNotebookIds = new ArrayList<Long>();
                for (Long other_element : other.sharedNotebookIds) {
                    __this__sharedNotebookIds.add(other_element);
                }
                this.sharedNotebookIds = __this__sharedNotebookIds;
            }
        }

        public expungeSharedNotebooks_args deepCopy() {
            return new expungeSharedNotebooks_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.sharedNotebookIds = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setSharedNotebookIds(List<Long> sharedNotebookIds) {
            this.sharedNotebookIds = sharedNotebookIds;
        }

        public boolean isSetSharedNotebookIds() {
            return this.sharedNotebookIds != null;
        }

        @Override
        public int compareTo(expungeSharedNotebooks_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeSharedNotebooks_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSharedNotebookIds()).compareTo(typedOther.isSetSharedNotebookIds());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSharedNotebookIds() && (lastComparison = TBaseHelper.compareTo(this.sharedNotebookIds, typedOther.sharedNotebookIds)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 15) {
                            TList _list146 = iprot.readListBegin();
                            this.sharedNotebookIds = new ArrayList<Long>(_list146.size);
                            int _i147 = 0;
                            while (_i147 < _list146.size) {
                                long _elem148 = iprot.readI64();
                                this.sharedNotebookIds.add(_elem148);
                                ++_i147;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.sharedNotebookIds != null) {
                oprot.writeFieldBegin(SHARED_NOTEBOOK_IDS_FIELD_DESC);
                oprot.writeListBegin(new TList(10, this.sharedNotebookIds.size()));
                for (long _iter149 : this.sharedNotebookIds) {
                    oprot.writeI64(_iter149);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeSharedNotebooks_result
    implements TBase<expungeSharedNotebooks_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeSharedNotebooks_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeSharedNotebooks_result() {
        }

        public expungeSharedNotebooks_result(expungeSharedNotebooks_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public expungeSharedNotebooks_result deepCopy() {
            return new expungeSharedNotebooks_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(expungeSharedNotebooks_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeSharedNotebooks_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeTag_args
    implements TBase<expungeTag_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeTag_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public expungeTag_args() {
        }

        public expungeTag_args(expungeTag_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public expungeTag_args deepCopy() {
            return new expungeTag_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(expungeTag_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeTag_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class expungeTag_result
    implements TBase<expungeTag_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("expungeTag_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public expungeTag_result() {
        }

        public expungeTag_result(expungeTag_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public expungeTag_result deepCopy() {
            return new expungeTag_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(expungeTag_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            expungeTag_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNoteCounts_args
    implements TBase<findNoteCounts_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNoteCounts_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField FILTER_FIELD_DESC = new TField("filter", 12, 2);
        private static final TField WITH_TRASH_FIELD_DESC = new TField("withTrash", 2, 3);
        private String authenticationToken;
        private NoteFilter filter;
        private boolean withTrash;
        private static final int __WITHTRASH_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public findNoteCounts_args() {
        }

        public findNoteCounts_args(findNoteCounts_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetFilter()) {
                this.filter = new NoteFilter(other.filter);
            }
            this.withTrash = other.withTrash;
        }

        public findNoteCounts_args deepCopy() {
            return new findNoteCounts_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.filter = null;
            this.setWithTrashIsSet(false);
            this.withTrash = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setFilter(NoteFilter filter) {
            this.filter = filter;
        }

        public boolean isSetFilter() {
            return this.filter != null;
        }

        public void setWithTrash(boolean withTrash) {
            this.withTrash = withTrash;
            this.setWithTrashIsSet(true);
        }

        public boolean isSetWithTrash() {
            return this.__isset_vector[0];
        }

        public void setWithTrashIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        @Override
        public int compareTo(findNoteCounts_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNoteCounts_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(typedOther.isSetFilter());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFilter() && (lastComparison = TBaseHelper.compareTo(this.filter, typedOther.filter)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithTrash()).compareTo(typedOther.isSetWithTrash());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithTrash() && (lastComparison = TBaseHelper.compareTo(this.withTrash, typedOther.withTrash)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.filter = new NoteFilter();
                            this.filter.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 2) {
                            this.withTrash = iprot.readBool();
                            this.setWithTrashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.filter != null) {
                oprot.writeFieldBegin(FILTER_FIELD_DESC);
                this.filter.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(WITH_TRASH_FIELD_DESC);
            oprot.writeBool(this.withTrash);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNoteCounts_result
    implements TBase<findNoteCounts_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNoteCounts_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private NoteCollectionCounts success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public findNoteCounts_result() {
        }

        public findNoteCounts_result(findNoteCounts_result other) {
            if (other.isSetSuccess()) {
                this.success = new NoteCollectionCounts(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public findNoteCounts_result deepCopy() {
            return new findNoteCounts_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(findNoteCounts_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNoteCounts_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new NoteCollectionCounts();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNoteOffset_args
    implements TBase<findNoteOffset_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNoteOffset_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField FILTER_FIELD_DESC = new TField("filter", 12, 2);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 3);
        private String authenticationToken;
        private NoteFilter filter;
        private String guid;

        public findNoteOffset_args() {
        }

        public findNoteOffset_args(findNoteOffset_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetFilter()) {
                this.filter = new NoteFilter(other.filter);
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public findNoteOffset_args deepCopy() {
            return new findNoteOffset_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.filter = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setFilter(NoteFilter filter) {
            this.filter = filter;
        }

        public boolean isSetFilter() {
            return this.filter != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(findNoteOffset_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNoteOffset_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(typedOther.isSetFilter());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFilter() && (lastComparison = TBaseHelper.compareTo(this.filter, typedOther.filter)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.filter = new NoteFilter();
                            this.filter.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.filter != null) {
                oprot.writeFieldBegin(FILTER_FIELD_DESC);
                this.filter.write(oprot);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNoteOffset_result
    implements TBase<findNoteOffset_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNoteOffset_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public findNoteOffset_result() {
        }

        public findNoteOffset_result(findNoteOffset_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public findNoteOffset_result deepCopy() {
            return new findNoteOffset_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(findNoteOffset_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNoteOffset_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNotesMetadata_args
    implements TBase<findNotesMetadata_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNotesMetadata_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField FILTER_FIELD_DESC = new TField("filter", 12, 2);
        private static final TField OFFSET_FIELD_DESC = new TField("offset", 8, 3);
        private static final TField MAX_NOTES_FIELD_DESC = new TField("maxNotes", 8, 4);
        private static final TField RESULT_SPEC_FIELD_DESC = new TField("resultSpec", 12, 5);
        private String authenticationToken;
        private NoteFilter filter;
        private int offset;
        private int maxNotes;
        private NotesMetadataResultSpec resultSpec;
        private static final int __OFFSET_ISSET_ID = 0;
        private static final int __MAXNOTES_ISSET_ID = 1;
        private boolean[] __isset_vector = new boolean[2];

        public findNotesMetadata_args() {
        }

        public findNotesMetadata_args(findNotesMetadata_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetFilter()) {
                this.filter = new NoteFilter(other.filter);
            }
            this.offset = other.offset;
            this.maxNotes = other.maxNotes;
            if (other.isSetResultSpec()) {
                this.resultSpec = new NotesMetadataResultSpec(other.resultSpec);
            }
        }

        public findNotesMetadata_args deepCopy() {
            return new findNotesMetadata_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.filter = null;
            this.setOffsetIsSet(false);
            this.offset = 0;
            this.setMaxNotesIsSet(false);
            this.maxNotes = 0;
            this.resultSpec = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setFilter(NoteFilter filter) {
            this.filter = filter;
        }

        public boolean isSetFilter() {
            return this.filter != null;
        }

        public void setOffset(int offset) {
            this.offset = offset;
            this.setOffsetIsSet(true);
        }

        public boolean isSetOffset() {
            return this.__isset_vector[0];
        }

        public void setOffsetIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setMaxNotes(int maxNotes) {
            this.maxNotes = maxNotes;
            this.setMaxNotesIsSet(true);
        }

        public boolean isSetMaxNotes() {
            return this.__isset_vector[1];
        }

        public void setMaxNotesIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setResultSpec(NotesMetadataResultSpec resultSpec) {
            this.resultSpec = resultSpec;
        }

        public boolean isSetResultSpec() {
            return this.resultSpec != null;
        }

        @Override
        public int compareTo(findNotesMetadata_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNotesMetadata_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(typedOther.isSetFilter());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFilter() && (lastComparison = TBaseHelper.compareTo(this.filter, typedOther.filter)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetOffset()).compareTo(typedOther.isSetOffset());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetOffset() && (lastComparison = TBaseHelper.compareTo(this.offset, typedOther.offset)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetMaxNotes()).compareTo(typedOther.isSetMaxNotes());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetMaxNotes() && (lastComparison = TBaseHelper.compareTo(this.maxNotes, typedOther.maxNotes)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetResultSpec()).compareTo(typedOther.isSetResultSpec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetResultSpec() && (lastComparison = TBaseHelper.compareTo(this.resultSpec, typedOther.resultSpec)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.filter = new NoteFilter();
                            this.filter.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 8) {
                            this.offset = iprot.readI32();
                            this.setOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 8) {
                            this.maxNotes = iprot.readI32();
                            this.setMaxNotesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 12) {
                            this.resultSpec = new NotesMetadataResultSpec();
                            this.resultSpec.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.filter != null) {
                oprot.writeFieldBegin(FILTER_FIELD_DESC);
                this.filter.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(OFFSET_FIELD_DESC);
            oprot.writeI32(this.offset);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_NOTES_FIELD_DESC);
            oprot.writeI32(this.maxNotes);
            oprot.writeFieldEnd();
            if (this.resultSpec != null) {
                oprot.writeFieldBegin(RESULT_SPEC_FIELD_DESC);
                this.resultSpec.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNotesMetadata_result
    implements TBase<findNotesMetadata_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNotesMetadata_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private NotesMetadataList success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public findNotesMetadata_result() {
        }

        public findNotesMetadata_result(findNotesMetadata_result other) {
            if (other.isSetSuccess()) {
                this.success = new NotesMetadataList(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public findNotesMetadata_result deepCopy() {
            return new findNotesMetadata_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(findNotesMetadata_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNotesMetadata_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new NotesMetadataList();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNotes_args
    implements TBase<findNotes_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNotes_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField FILTER_FIELD_DESC = new TField("filter", 12, 2);
        private static final TField OFFSET_FIELD_DESC = new TField("offset", 8, 3);
        private static final TField MAX_NOTES_FIELD_DESC = new TField("maxNotes", 8, 4);
        private String authenticationToken;
        private NoteFilter filter;
        private int offset;
        private int maxNotes;
        private static final int __OFFSET_ISSET_ID = 0;
        private static final int __MAXNOTES_ISSET_ID = 1;
        private boolean[] __isset_vector = new boolean[2];

        public findNotes_args() {
        }

        public findNotes_args(findNotes_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetFilter()) {
                this.filter = new NoteFilter(other.filter);
            }
            this.offset = other.offset;
            this.maxNotes = other.maxNotes;
        }

        public findNotes_args deepCopy() {
            return new findNotes_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.filter = null;
            this.setOffsetIsSet(false);
            this.offset = 0;
            this.setMaxNotesIsSet(false);
            this.maxNotes = 0;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setFilter(NoteFilter filter) {
            this.filter = filter;
        }

        public boolean isSetFilter() {
            return this.filter != null;
        }

        public void setOffset(int offset) {
            this.offset = offset;
            this.setOffsetIsSet(true);
        }

        public boolean isSetOffset() {
            return this.__isset_vector[0];
        }

        public void setOffsetIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setMaxNotes(int maxNotes) {
            this.maxNotes = maxNotes;
            this.setMaxNotesIsSet(true);
        }

        public boolean isSetMaxNotes() {
            return this.__isset_vector[1];
        }

        public void setMaxNotesIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        @Override
        public int compareTo(findNotes_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNotes_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(typedOther.isSetFilter());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFilter() && (lastComparison = TBaseHelper.compareTo(this.filter, typedOther.filter)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetOffset()).compareTo(typedOther.isSetOffset());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetOffset() && (lastComparison = TBaseHelper.compareTo(this.offset, typedOther.offset)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetMaxNotes()).compareTo(typedOther.isSetMaxNotes());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetMaxNotes() && (lastComparison = TBaseHelper.compareTo(this.maxNotes, typedOther.maxNotes)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.filter = new NoteFilter();
                            this.filter.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 8) {
                            this.offset = iprot.readI32();
                            this.setOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 8) {
                            this.maxNotes = iprot.readI32();
                            this.setMaxNotesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.filter != null) {
                oprot.writeFieldBegin(FILTER_FIELD_DESC);
                this.filter.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(OFFSET_FIELD_DESC);
            oprot.writeI32(this.offset);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_NOTES_FIELD_DESC);
            oprot.writeI32(this.maxNotes);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findNotes_result
    implements TBase<findNotes_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findNotes_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private NoteList success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public findNotes_result() {
        }

        public findNotes_result(findNotes_result other) {
            if (other.isSetSuccess()) {
                this.success = new NoteList(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public findNotes_result deepCopy() {
            return new findNotes_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(findNotes_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findNotes_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new NoteList();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findRelated_args
    implements TBase<findRelated_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findRelated_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField QUERY_FIELD_DESC = new TField("query", 12, 2);
        private static final TField RESULT_SPEC_FIELD_DESC = new TField("resultSpec", 12, 3);
        private String authenticationToken;
        private RelatedQuery query;
        private RelatedResultSpec resultSpec;

        public findRelated_args() {
        }

        public findRelated_args(findRelated_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetQuery()) {
                this.query = new RelatedQuery(other.query);
            }
            if (other.isSetResultSpec()) {
                this.resultSpec = new RelatedResultSpec(other.resultSpec);
            }
        }

        public findRelated_args deepCopy() {
            return new findRelated_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.query = null;
            this.resultSpec = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setQuery(RelatedQuery query) {
            this.query = query;
        }

        public boolean isSetQuery() {
            return this.query != null;
        }

        public void setResultSpec(RelatedResultSpec resultSpec) {
            this.resultSpec = resultSpec;
        }

        public boolean isSetResultSpec() {
            return this.resultSpec != null;
        }

        @Override
        public int compareTo(findRelated_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findRelated_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetQuery()).compareTo(typedOther.isSetQuery());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetQuery() && (lastComparison = TBaseHelper.compareTo(this.query, typedOther.query)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetResultSpec()).compareTo(typedOther.isSetResultSpec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetResultSpec() && (lastComparison = TBaseHelper.compareTo(this.resultSpec, typedOther.resultSpec)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.query = new RelatedQuery();
                            this.query.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.resultSpec = new RelatedResultSpec();
                            this.resultSpec.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.query != null) {
                oprot.writeFieldBegin(QUERY_FIELD_DESC);
                this.query.write(oprot);
                oprot.writeFieldEnd();
            }
            if (this.resultSpec != null) {
                oprot.writeFieldBegin(RESULT_SPEC_FIELD_DESC);
                this.resultSpec.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class findRelated_result
    implements TBase<findRelated_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("findRelated_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private RelatedResult success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public findRelated_result() {
        }

        public findRelated_result(findRelated_result other) {
            if (other.isSetSuccess()) {
                this.success = new RelatedResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public findRelated_result deepCopy() {
            return new findRelated_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(findRelated_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            findRelated_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new RelatedResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getDefaultNotebook_args
    implements TBase<getDefaultNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getDefaultNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public getDefaultNotebook_args() {
        }

        public getDefaultNotebook_args(getDefaultNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public getDefaultNotebook_args deepCopy() {
            return new getDefaultNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(getDefaultNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getDefaultNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getDefaultNotebook_result
    implements TBase<getDefaultNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getDefaultNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private Notebook success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getDefaultNotebook_result() {
        }

        public getDefaultNotebook_result(getDefaultNotebook_result other) {
            if (other.isSetSuccess()) {
                this.success = new Notebook(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getDefaultNotebook_result deepCopy() {
            return new getDefaultNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getDefaultNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getDefaultNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Notebook();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getFilteredSyncChunk_args
    implements TBase<getFilteredSyncChunk_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getFilteredSyncChunk_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField AFTER_USN_FIELD_DESC = new TField("afterUSN", 8, 2);
        private static final TField MAX_ENTRIES_FIELD_DESC = new TField("maxEntries", 8, 3);
        private static final TField FILTER_FIELD_DESC = new TField("filter", 12, 4);
        private String authenticationToken;
        private int afterUSN;
        private int maxEntries;
        private SyncChunkFilter filter;
        private static final int __AFTERUSN_ISSET_ID = 0;
        private static final int __MAXENTRIES_ISSET_ID = 1;
        private boolean[] __isset_vector = new boolean[2];

        public getFilteredSyncChunk_args() {
        }

        public getFilteredSyncChunk_args(getFilteredSyncChunk_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            this.afterUSN = other.afterUSN;
            this.maxEntries = other.maxEntries;
            if (other.isSetFilter()) {
                this.filter = new SyncChunkFilter(other.filter);
            }
        }

        public getFilteredSyncChunk_args deepCopy() {
            return new getFilteredSyncChunk_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.setAfterUSNIsSet(false);
            this.afterUSN = 0;
            this.setMaxEntriesIsSet(false);
            this.maxEntries = 0;
            this.filter = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setAfterUSN(int afterUSN) {
            this.afterUSN = afterUSN;
            this.setAfterUSNIsSet(true);
        }

        public boolean isSetAfterUSN() {
            return this.__isset_vector[0];
        }

        public void setAfterUSNIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setMaxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
            this.setMaxEntriesIsSet(true);
        }

        public boolean isSetMaxEntries() {
            return this.__isset_vector[1];
        }

        public void setMaxEntriesIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setFilter(SyncChunkFilter filter) {
            this.filter = filter;
        }

        public boolean isSetFilter() {
            return this.filter != null;
        }

        @Override
        public int compareTo(getFilteredSyncChunk_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getFilteredSyncChunk_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetAfterUSN()).compareTo(typedOther.isSetAfterUSN());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAfterUSN() && (lastComparison = TBaseHelper.compareTo(this.afterUSN, typedOther.afterUSN)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetMaxEntries()).compareTo(typedOther.isSetMaxEntries());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetMaxEntries() && (lastComparison = TBaseHelper.compareTo(this.maxEntries, typedOther.maxEntries)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(typedOther.isSetFilter());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFilter() && (lastComparison = TBaseHelper.compareTo(this.filter, typedOther.filter)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 8) {
                            this.afterUSN = iprot.readI32();
                            this.setAfterUSNIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 8) {
                            this.maxEntries = iprot.readI32();
                            this.setMaxEntriesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 12) {
                            this.filter = new SyncChunkFilter();
                            this.filter.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(AFTER_USN_FIELD_DESC);
            oprot.writeI32(this.afterUSN);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_ENTRIES_FIELD_DESC);
            oprot.writeI32(this.maxEntries);
            oprot.writeFieldEnd();
            if (this.filter != null) {
                oprot.writeFieldBegin(FILTER_FIELD_DESC);
                this.filter.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getFilteredSyncChunk_result
    implements TBase<getFilteredSyncChunk_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getFilteredSyncChunk_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private SyncChunk success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getFilteredSyncChunk_result() {
        }

        public getFilteredSyncChunk_result(getFilteredSyncChunk_result other) {
            if (other.isSetSuccess()) {
                this.success = new SyncChunk(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getFilteredSyncChunk_result deepCopy() {
            return new getFilteredSyncChunk_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getFilteredSyncChunk_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getFilteredSyncChunk_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SyncChunk();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getLinkedNotebookSyncChunk_args
    implements TBase<getLinkedNotebookSyncChunk_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getLinkedNotebookSyncChunk_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField LINKED_NOTEBOOK_FIELD_DESC = new TField("linkedNotebook", 12, 2);
        private static final TField AFTER_USN_FIELD_DESC = new TField("afterUSN", 8, 3);
        private static final TField MAX_ENTRIES_FIELD_DESC = new TField("maxEntries", 8, 4);
        private static final TField FULL_SYNC_ONLY_FIELD_DESC = new TField("fullSyncOnly", 2, 5);
        private String authenticationToken;
        private LinkedNotebook linkedNotebook;
        private int afterUSN;
        private int maxEntries;
        private boolean fullSyncOnly;
        private static final int __AFTERUSN_ISSET_ID = 0;
        private static final int __MAXENTRIES_ISSET_ID = 1;
        private static final int __FULLSYNCONLY_ISSET_ID = 2;
        private boolean[] __isset_vector = new boolean[3];

        public getLinkedNotebookSyncChunk_args() {
        }

        public getLinkedNotebookSyncChunk_args(getLinkedNotebookSyncChunk_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetLinkedNotebook()) {
                this.linkedNotebook = new LinkedNotebook(other.linkedNotebook);
            }
            this.afterUSN = other.afterUSN;
            this.maxEntries = other.maxEntries;
            this.fullSyncOnly = other.fullSyncOnly;
        }

        public getLinkedNotebookSyncChunk_args deepCopy() {
            return new getLinkedNotebookSyncChunk_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.linkedNotebook = null;
            this.setAfterUSNIsSet(false);
            this.afterUSN = 0;
            this.setMaxEntriesIsSet(false);
            this.maxEntries = 0;
            this.setFullSyncOnlyIsSet(false);
            this.fullSyncOnly = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setLinkedNotebook(LinkedNotebook linkedNotebook) {
            this.linkedNotebook = linkedNotebook;
        }

        public boolean isSetLinkedNotebook() {
            return this.linkedNotebook != null;
        }

        public void setAfterUSN(int afterUSN) {
            this.afterUSN = afterUSN;
            this.setAfterUSNIsSet(true);
        }

        public boolean isSetAfterUSN() {
            return this.__isset_vector[0];
        }

        public void setAfterUSNIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setMaxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
            this.setMaxEntriesIsSet(true);
        }

        public boolean isSetMaxEntries() {
            return this.__isset_vector[1];
        }

        public void setMaxEntriesIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setFullSyncOnly(boolean fullSyncOnly) {
            this.fullSyncOnly = fullSyncOnly;
            this.setFullSyncOnlyIsSet(true);
        }

        public boolean isSetFullSyncOnly() {
            return this.__isset_vector[2];
        }

        public void setFullSyncOnlyIsSet(boolean value) {
            this.__isset_vector[2] = value;
        }

        @Override
        public int compareTo(getLinkedNotebookSyncChunk_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getLinkedNotebookSyncChunk_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetLinkedNotebook()).compareTo(typedOther.isSetLinkedNotebook());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetLinkedNotebook() && (lastComparison = TBaseHelper.compareTo(this.linkedNotebook, typedOther.linkedNotebook)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetAfterUSN()).compareTo(typedOther.isSetAfterUSN());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAfterUSN() && (lastComparison = TBaseHelper.compareTo(this.afterUSN, typedOther.afterUSN)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetMaxEntries()).compareTo(typedOther.isSetMaxEntries());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetMaxEntries() && (lastComparison = TBaseHelper.compareTo(this.maxEntries, typedOther.maxEntries)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFullSyncOnly()).compareTo(typedOther.isSetFullSyncOnly());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFullSyncOnly() && (lastComparison = TBaseHelper.compareTo(this.fullSyncOnly, typedOther.fullSyncOnly)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.linkedNotebook = new LinkedNotebook();
                            this.linkedNotebook.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 8) {
                            this.afterUSN = iprot.readI32();
                            this.setAfterUSNIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 8) {
                            this.maxEntries = iprot.readI32();
                            this.setMaxEntriesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 2) {
                            this.fullSyncOnly = iprot.readBool();
                            this.setFullSyncOnlyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.linkedNotebook != null) {
                oprot.writeFieldBegin(LINKED_NOTEBOOK_FIELD_DESC);
                this.linkedNotebook.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(AFTER_USN_FIELD_DESC);
            oprot.writeI32(this.afterUSN);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_ENTRIES_FIELD_DESC);
            oprot.writeI32(this.maxEntries);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(FULL_SYNC_ONLY_FIELD_DESC);
            oprot.writeBool(this.fullSyncOnly);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getLinkedNotebookSyncChunk_result
    implements TBase<getLinkedNotebookSyncChunk_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getLinkedNotebookSyncChunk_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private SyncChunk success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getLinkedNotebookSyncChunk_result() {
        }

        public getLinkedNotebookSyncChunk_result(getLinkedNotebookSyncChunk_result other) {
            if (other.isSetSuccess()) {
                this.success = new SyncChunk(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getLinkedNotebookSyncChunk_result deepCopy() {
            return new getLinkedNotebookSyncChunk_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getLinkedNotebookSyncChunk_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getLinkedNotebookSyncChunk_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SyncChunk();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getLinkedNotebookSyncState_args
    implements TBase<getLinkedNotebookSyncState_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getLinkedNotebookSyncState_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField LINKED_NOTEBOOK_FIELD_DESC = new TField("linkedNotebook", 12, 2);
        private String authenticationToken;
        private LinkedNotebook linkedNotebook;

        public getLinkedNotebookSyncState_args() {
        }

        public getLinkedNotebookSyncState_args(getLinkedNotebookSyncState_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetLinkedNotebook()) {
                this.linkedNotebook = new LinkedNotebook(other.linkedNotebook);
            }
        }

        public getLinkedNotebookSyncState_args deepCopy() {
            return new getLinkedNotebookSyncState_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.linkedNotebook = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setLinkedNotebook(LinkedNotebook linkedNotebook) {
            this.linkedNotebook = linkedNotebook;
        }

        public boolean isSetLinkedNotebook() {
            return this.linkedNotebook != null;
        }

        @Override
        public int compareTo(getLinkedNotebookSyncState_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getLinkedNotebookSyncState_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetLinkedNotebook()).compareTo(typedOther.isSetLinkedNotebook());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetLinkedNotebook() && (lastComparison = TBaseHelper.compareTo(this.linkedNotebook, typedOther.linkedNotebook)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.linkedNotebook = new LinkedNotebook();
                            this.linkedNotebook.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.linkedNotebook != null) {
                oprot.writeFieldBegin(LINKED_NOTEBOOK_FIELD_DESC);
                this.linkedNotebook.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getLinkedNotebookSyncState_result
    implements TBase<getLinkedNotebookSyncState_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getLinkedNotebookSyncState_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private SyncState success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getLinkedNotebookSyncState_result() {
        }

        public getLinkedNotebookSyncState_result(getLinkedNotebookSyncState_result other) {
            if (other.isSetSuccess()) {
                this.success = new SyncState(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getLinkedNotebookSyncState_result deepCopy() {
            return new getLinkedNotebookSyncState_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getLinkedNotebookSyncState_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getLinkedNotebookSyncState_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SyncState();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteApplicationDataEntry_args
    implements TBase<getNoteApplicationDataEntry_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteApplicationDataEntry_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private static final TField KEY_FIELD_DESC = new TField("key", 11, 3);
        private String authenticationToken;
        private String guid;
        private String key;

        public getNoteApplicationDataEntry_args() {
        }

        public getNoteApplicationDataEntry_args(getNoteApplicationDataEntry_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            if (other.isSetKey()) {
                this.key = other.key;
            }
        }

        public getNoteApplicationDataEntry_args deepCopy() {
            return new getNoteApplicationDataEntry_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
            this.key = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean isSetKey() {
            return this.key != null;
        }

        @Override
        public int compareTo(getNoteApplicationDataEntry_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteApplicationDataEntry_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(typedOther.isSetKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo(this.key, typedOther.key)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.key = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            if (this.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                oprot.writeString(this.key);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteApplicationDataEntry_result
    implements TBase<getNoteApplicationDataEntry_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteApplicationDataEntry_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private String success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNoteApplicationDataEntry_result() {
        }

        public getNoteApplicationDataEntry_result(getNoteApplicationDataEntry_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNoteApplicationDataEntry_result deepCopy() {
            return new getNoteApplicationDataEntry_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNoteApplicationDataEntry_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteApplicationDataEntry_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeString(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteApplicationData_args
    implements TBase<getNoteApplicationData_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteApplicationData_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getNoteApplicationData_args() {
        }

        public getNoteApplicationData_args(getNoteApplicationData_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getNoteApplicationData_args deepCopy() {
            return new getNoteApplicationData_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getNoteApplicationData_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteApplicationData_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteApplicationData_result
    implements TBase<getNoteApplicationData_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteApplicationData_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private LazyMap success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNoteApplicationData_result() {
        }

        public getNoteApplicationData_result(getNoteApplicationData_result other) {
            if (other.isSetSuccess()) {
                this.success = new LazyMap(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNoteApplicationData_result deepCopy() {
            return new getNoteApplicationData_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNoteApplicationData_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteApplicationData_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new LazyMap();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteContent_args
    implements TBase<getNoteContent_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteContent_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getNoteContent_args() {
        }

        public getNoteContent_args(getNoteContent_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getNoteContent_args deepCopy() {
            return new getNoteContent_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getNoteContent_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteContent_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteContent_result
    implements TBase<getNoteContent_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteContent_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private String success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNoteContent_result() {
        }

        public getNoteContent_result(getNoteContent_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNoteContent_result deepCopy() {
            return new getNoteContent_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNoteContent_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteContent_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeString(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteSearchText_args
    implements TBase<getNoteSearchText_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteSearchText_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private static final TField NOTE_ONLY_FIELD_DESC = new TField("noteOnly", 2, 3);
        private static final TField TOKENIZE_FOR_INDEXING_FIELD_DESC = new TField("tokenizeForIndexing", 2, 4);
        private String authenticationToken;
        private String guid;
        private boolean noteOnly;
        private boolean tokenizeForIndexing;
        private static final int __NOTEONLY_ISSET_ID = 0;
        private static final int __TOKENIZEFORINDEXING_ISSET_ID = 1;
        private boolean[] __isset_vector = new boolean[2];

        public getNoteSearchText_args() {
        }

        public getNoteSearchText_args(getNoteSearchText_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            this.noteOnly = other.noteOnly;
            this.tokenizeForIndexing = other.tokenizeForIndexing;
        }

        public getNoteSearchText_args deepCopy() {
            return new getNoteSearchText_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
            this.setNoteOnlyIsSet(false);
            this.noteOnly = false;
            this.setTokenizeForIndexingIsSet(false);
            this.tokenizeForIndexing = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setNoteOnly(boolean noteOnly) {
            this.noteOnly = noteOnly;
            this.setNoteOnlyIsSet(true);
        }

        public boolean isSetNoteOnly() {
            return this.__isset_vector[0];
        }

        public void setNoteOnlyIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setTokenizeForIndexing(boolean tokenizeForIndexing) {
            this.tokenizeForIndexing = tokenizeForIndexing;
            this.setTokenizeForIndexingIsSet(true);
        }

        public boolean isSetTokenizeForIndexing() {
            return this.__isset_vector[1];
        }

        public void setTokenizeForIndexingIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        @Override
        public int compareTo(getNoteSearchText_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteSearchText_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNoteOnly()).compareTo(typedOther.isSetNoteOnly());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNoteOnly() && (lastComparison = TBaseHelper.compareTo(this.noteOnly, typedOther.noteOnly)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTokenizeForIndexing()).compareTo(typedOther.isSetTokenizeForIndexing());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTokenizeForIndexing() && (lastComparison = TBaseHelper.compareTo(this.tokenizeForIndexing, typedOther.tokenizeForIndexing)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 2) {
                            this.noteOnly = iprot.readBool();
                            this.setNoteOnlyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 2) {
                            this.tokenizeForIndexing = iprot.readBool();
                            this.setTokenizeForIndexingIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(NOTE_ONLY_FIELD_DESC);
            oprot.writeBool(this.noteOnly);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(TOKENIZE_FOR_INDEXING_FIELD_DESC);
            oprot.writeBool(this.tokenizeForIndexing);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteSearchText_result
    implements TBase<getNoteSearchText_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteSearchText_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private String success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNoteSearchText_result() {
        }

        public getNoteSearchText_result(getNoteSearchText_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNoteSearchText_result deepCopy() {
            return new getNoteSearchText_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNoteSearchText_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteSearchText_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeString(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteTagNames_args
    implements TBase<getNoteTagNames_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteTagNames_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getNoteTagNames_args() {
        }

        public getNoteTagNames_args(getNoteTagNames_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getNoteTagNames_args deepCopy() {
            return new getNoteTagNames_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getNoteTagNames_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteTagNames_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteTagNames_result
    implements TBase<getNoteTagNames_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteTagNames_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private List<String> success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNoteTagNames_result() {
        }

        public getNoteTagNames_result(getNoteTagNames_result other) {
            if (other.isSetSuccess()) {
                ArrayList<String> __this__success = new ArrayList<String>();
                for (String other_element : other.success) {
                    __this__success.add(other_element);
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNoteTagNames_result deepCopy() {
            return new getNoteTagNames_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNoteTagNames_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteTagNames_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list126 = iprot.readListBegin();
                            this.success = new ArrayList<String>(_list126.size);
                            int _i127 = 0;
                            while (_i127 < _list126.size) {
                                String _elem128 = iprot.readString();
                                this.success.add(_elem128);
                                ++_i127;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, this.success.size()));
                for (String _iter129 : this.success) {
                    oprot.writeString(_iter129);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteVersion_args
    implements TBase<getNoteVersion_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteVersion_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTE_GUID_FIELD_DESC = new TField("noteGuid", 11, 2);
        private static final TField UPDATE_SEQUENCE_NUM_FIELD_DESC = new TField("updateSequenceNum", 8, 3);
        private static final TField WITH_RESOURCES_DATA_FIELD_DESC = new TField("withResourcesData", 2, 4);
        private static final TField WITH_RESOURCES_RECOGNITION_FIELD_DESC = new TField("withResourcesRecognition", 2, 5);
        private static final TField WITH_RESOURCES_ALTERNATE_DATA_FIELD_DESC = new TField("withResourcesAlternateData", 2, 6);
        private String authenticationToken;
        private String noteGuid;
        private int updateSequenceNum;
        private boolean withResourcesData;
        private boolean withResourcesRecognition;
        private boolean withResourcesAlternateData;
        private static final int __UPDATESEQUENCENUM_ISSET_ID = 0;
        private static final int __WITHRESOURCESDATA_ISSET_ID = 1;
        private static final int __WITHRESOURCESRECOGNITION_ISSET_ID = 2;
        private static final int __WITHRESOURCESALTERNATEDATA_ISSET_ID = 3;
        private boolean[] __isset_vector = new boolean[4];

        public getNoteVersion_args() {
        }

        public getNoteVersion_args(getNoteVersion_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNoteGuid()) {
                this.noteGuid = other.noteGuid;
            }
            this.updateSequenceNum = other.updateSequenceNum;
            this.withResourcesData = other.withResourcesData;
            this.withResourcesRecognition = other.withResourcesRecognition;
            this.withResourcesAlternateData = other.withResourcesAlternateData;
        }

        public getNoteVersion_args deepCopy() {
            return new getNoteVersion_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.noteGuid = null;
            this.setUpdateSequenceNumIsSet(false);
            this.updateSequenceNum = 0;
            this.setWithResourcesDataIsSet(false);
            this.withResourcesData = false;
            this.setWithResourcesRecognitionIsSet(false);
            this.withResourcesRecognition = false;
            this.setWithResourcesAlternateDataIsSet(false);
            this.withResourcesAlternateData = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNoteGuid(String noteGuid) {
            this.noteGuid = noteGuid;
        }

        public boolean isSetNoteGuid() {
            return this.noteGuid != null;
        }

        public void setUpdateSequenceNum(int updateSequenceNum) {
            this.updateSequenceNum = updateSequenceNum;
            this.setUpdateSequenceNumIsSet(true);
        }

        public boolean isSetUpdateSequenceNum() {
            return this.__isset_vector[0];
        }

        public void setUpdateSequenceNumIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setWithResourcesData(boolean withResourcesData) {
            this.withResourcesData = withResourcesData;
            this.setWithResourcesDataIsSet(true);
        }

        public boolean isSetWithResourcesData() {
            return this.__isset_vector[1];
        }

        public void setWithResourcesDataIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setWithResourcesRecognition(boolean withResourcesRecognition) {
            this.withResourcesRecognition = withResourcesRecognition;
            this.setWithResourcesRecognitionIsSet(true);
        }

        public boolean isSetWithResourcesRecognition() {
            return this.__isset_vector[2];
        }

        public void setWithResourcesRecognitionIsSet(boolean value) {
            this.__isset_vector[2] = value;
        }

        public void setWithResourcesAlternateData(boolean withResourcesAlternateData) {
            this.withResourcesAlternateData = withResourcesAlternateData;
            this.setWithResourcesAlternateDataIsSet(true);
        }

        public boolean isSetWithResourcesAlternateData() {
            return this.__isset_vector[3];
        }

        public void setWithResourcesAlternateDataIsSet(boolean value) {
            this.__isset_vector[3] = value;
        }

        @Override
        public int compareTo(getNoteVersion_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteVersion_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNoteGuid()).compareTo(typedOther.isSetNoteGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNoteGuid() && (lastComparison = TBaseHelper.compareTo(this.noteGuid, typedOther.noteGuid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUpdateSequenceNum()).compareTo(typedOther.isSetUpdateSequenceNum());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUpdateSequenceNum() && (lastComparison = TBaseHelper.compareTo(this.updateSequenceNum, typedOther.updateSequenceNum)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithResourcesData()).compareTo(typedOther.isSetWithResourcesData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithResourcesData() && (lastComparison = TBaseHelper.compareTo(this.withResourcesData, typedOther.withResourcesData)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithResourcesRecognition()).compareTo(typedOther.isSetWithResourcesRecognition());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithResourcesRecognition() && (lastComparison = TBaseHelper.compareTo(this.withResourcesRecognition, typedOther.withResourcesRecognition)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithResourcesAlternateData()).compareTo(typedOther.isSetWithResourcesAlternateData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithResourcesAlternateData() && (lastComparison = TBaseHelper.compareTo(this.withResourcesAlternateData, typedOther.withResourcesAlternateData)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.noteGuid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 8) {
                            this.updateSequenceNum = iprot.readI32();
                            this.setUpdateSequenceNumIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 2) {
                            this.withResourcesData = iprot.readBool();
                            this.setWithResourcesDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 2) {
                            this.withResourcesRecognition = iprot.readBool();
                            this.setWithResourcesRecognitionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 6: {
                        if (field.type == 2) {
                            this.withResourcesAlternateData = iprot.readBool();
                            this.setWithResourcesAlternateDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.noteGuid != null) {
                oprot.writeFieldBegin(NOTE_GUID_FIELD_DESC);
                oprot.writeString(this.noteGuid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(UPDATE_SEQUENCE_NUM_FIELD_DESC);
            oprot.writeI32(this.updateSequenceNum);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RESOURCES_DATA_FIELD_DESC);
            oprot.writeBool(this.withResourcesData);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RESOURCES_RECOGNITION_FIELD_DESC);
            oprot.writeBool(this.withResourcesRecognition);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RESOURCES_ALTERNATE_DATA_FIELD_DESC);
            oprot.writeBool(this.withResourcesAlternateData);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteVersion_result
    implements TBase<getNoteVersion_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteVersion_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Note success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNoteVersion_result() {
        }

        public getNoteVersion_result(getNoteVersion_result other) {
            if (other.isSetSuccess()) {
                this.success = new Note(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNoteVersion_result deepCopy() {
            return new getNoteVersion_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNoteVersion_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteVersion_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Note();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNote_args
    implements TBase<getNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNote_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private static final TField WITH_CONTENT_FIELD_DESC = new TField("withContent", 2, 3);
        private static final TField WITH_RESOURCES_DATA_FIELD_DESC = new TField("withResourcesData", 2, 4);
        private static final TField WITH_RESOURCES_RECOGNITION_FIELD_DESC = new TField("withResourcesRecognition", 2, 5);
        private static final TField WITH_RESOURCES_ALTERNATE_DATA_FIELD_DESC = new TField("withResourcesAlternateData", 2, 6);
        private String authenticationToken;
        private String guid;
        private boolean withContent;
        private boolean withResourcesData;
        private boolean withResourcesRecognition;
        private boolean withResourcesAlternateData;
        private static final int __WITHCONTENT_ISSET_ID = 0;
        private static final int __WITHRESOURCESDATA_ISSET_ID = 1;
        private static final int __WITHRESOURCESRECOGNITION_ISSET_ID = 2;
        private static final int __WITHRESOURCESALTERNATEDATA_ISSET_ID = 3;
        private boolean[] __isset_vector = new boolean[4];

        public getNote_args() {
        }

        public getNote_args(getNote_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            this.withContent = other.withContent;
            this.withResourcesData = other.withResourcesData;
            this.withResourcesRecognition = other.withResourcesRecognition;
            this.withResourcesAlternateData = other.withResourcesAlternateData;
        }

        public getNote_args deepCopy() {
            return new getNote_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
            this.setWithContentIsSet(false);
            this.withContent = false;
            this.setWithResourcesDataIsSet(false);
            this.withResourcesData = false;
            this.setWithResourcesRecognitionIsSet(false);
            this.withResourcesRecognition = false;
            this.setWithResourcesAlternateDataIsSet(false);
            this.withResourcesAlternateData = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setWithContent(boolean withContent) {
            this.withContent = withContent;
            this.setWithContentIsSet(true);
        }

        public boolean isSetWithContent() {
            return this.__isset_vector[0];
        }

        public void setWithContentIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setWithResourcesData(boolean withResourcesData) {
            this.withResourcesData = withResourcesData;
            this.setWithResourcesDataIsSet(true);
        }

        public boolean isSetWithResourcesData() {
            return this.__isset_vector[1];
        }

        public void setWithResourcesDataIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setWithResourcesRecognition(boolean withResourcesRecognition) {
            this.withResourcesRecognition = withResourcesRecognition;
            this.setWithResourcesRecognitionIsSet(true);
        }

        public boolean isSetWithResourcesRecognition() {
            return this.__isset_vector[2];
        }

        public void setWithResourcesRecognitionIsSet(boolean value) {
            this.__isset_vector[2] = value;
        }

        public void setWithResourcesAlternateData(boolean withResourcesAlternateData) {
            this.withResourcesAlternateData = withResourcesAlternateData;
            this.setWithResourcesAlternateDataIsSet(true);
        }

        public boolean isSetWithResourcesAlternateData() {
            return this.__isset_vector[3];
        }

        public void setWithResourcesAlternateDataIsSet(boolean value) {
            this.__isset_vector[3] = value;
        }

        @Override
        public int compareTo(getNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithContent()).compareTo(typedOther.isSetWithContent());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithContent() && (lastComparison = TBaseHelper.compareTo(this.withContent, typedOther.withContent)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithResourcesData()).compareTo(typedOther.isSetWithResourcesData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithResourcesData() && (lastComparison = TBaseHelper.compareTo(this.withResourcesData, typedOther.withResourcesData)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithResourcesRecognition()).compareTo(typedOther.isSetWithResourcesRecognition());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithResourcesRecognition() && (lastComparison = TBaseHelper.compareTo(this.withResourcesRecognition, typedOther.withResourcesRecognition)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithResourcesAlternateData()).compareTo(typedOther.isSetWithResourcesAlternateData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithResourcesAlternateData() && (lastComparison = TBaseHelper.compareTo(this.withResourcesAlternateData, typedOther.withResourcesAlternateData)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 2) {
                            this.withContent = iprot.readBool();
                            this.setWithContentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 2) {
                            this.withResourcesData = iprot.readBool();
                            this.setWithResourcesDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 2) {
                            this.withResourcesRecognition = iprot.readBool();
                            this.setWithResourcesRecognitionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 6: {
                        if (field.type == 2) {
                            this.withResourcesAlternateData = iprot.readBool();
                            this.setWithResourcesAlternateDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(WITH_CONTENT_FIELD_DESC);
            oprot.writeBool(this.withContent);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RESOURCES_DATA_FIELD_DESC);
            oprot.writeBool(this.withResourcesData);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RESOURCES_RECOGNITION_FIELD_DESC);
            oprot.writeBool(this.withResourcesRecognition);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RESOURCES_ALTERNATE_DATA_FIELD_DESC);
            oprot.writeBool(this.withResourcesAlternateData);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNote_result
    implements TBase<getNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNote_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Note success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNote_result() {
        }

        public getNote_result(getNote_result other) {
            if (other.isSetSuccess()) {
                this.success = new Note(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNote_result deepCopy() {
            return new getNote_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Note();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNotebook_args
    implements TBase<getNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getNotebook_args() {
        }

        public getNotebook_args(getNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getNotebook_args deepCopy() {
            return new getNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNotebook_result
    implements TBase<getNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Notebook success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getNotebook_result() {
        }

        public getNotebook_result(getNotebook_result other) {
            if (other.isSetSuccess()) {
                this.success = new Notebook(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getNotebook_result deepCopy() {
            return new getNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Notebook();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getPublicNotebook_args
    implements TBase<getPublicNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getPublicNotebook_args");
        private static final TField USER_ID_FIELD_DESC = new TField("userId", 8, 1);
        private static final TField PUBLIC_URI_FIELD_DESC = new TField("publicUri", 11, 2);
        private int userId;
        private String publicUri;
        private static final int __USERID_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public getPublicNotebook_args() {
        }

        public getPublicNotebook_args(getPublicNotebook_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.userId = other.userId;
            if (other.isSetPublicUri()) {
                this.publicUri = other.publicUri;
            }
        }

        public getPublicNotebook_args deepCopy() {
            return new getPublicNotebook_args(this);
        }

        @Override
        public void clear() {
            this.setUserIdIsSet(false);
            this.userId = 0;
            this.publicUri = null;
        }

        public void setUserId(int userId) {
            this.userId = userId;
            this.setUserIdIsSet(true);
        }

        public boolean isSetUserId() {
            return this.__isset_vector[0];
        }

        public void setUserIdIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setPublicUri(String publicUri) {
            this.publicUri = publicUri;
        }

        public boolean isSetPublicUri() {
            return this.publicUri != null;
        }

        @Override
        public int compareTo(getPublicNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getPublicNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetUserId()).compareTo(typedOther.isSetUserId());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserId() && (lastComparison = TBaseHelper.compareTo(this.userId, typedOther.userId)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetPublicUri()).compareTo(typedOther.isSetPublicUri());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetPublicUri() && (lastComparison = TBaseHelper.compareTo(this.publicUri, typedOther.publicUri)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 8) {
                            this.userId = iprot.readI32();
                            this.setUserIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.publicUri = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(USER_ID_FIELD_DESC);
            oprot.writeI32(this.userId);
            oprot.writeFieldEnd();
            if (this.publicUri != null) {
                oprot.writeFieldBegin(PUBLIC_URI_FIELD_DESC);
                oprot.writeString(this.publicUri);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getPublicNotebook_result
    implements TBase<getPublicNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getPublicNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private Notebook success;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getPublicNotebook_result() {
        }

        public getPublicNotebook_result(getPublicNotebook_result other) {
            if (other.isSetSuccess()) {
                this.success = new Notebook(other.success);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getPublicNotebook_result deepCopy() {
            return new getPublicNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getPublicNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getPublicNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Notebook();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceAlternateData_args
    implements TBase<getResourceAlternateData_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceAlternateData_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getResourceAlternateData_args() {
        }

        public getResourceAlternateData_args(getResourceAlternateData_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getResourceAlternateData_args deepCopy() {
            return new getResourceAlternateData_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getResourceAlternateData_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceAlternateData_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceAlternateData_result
    implements TBase<getResourceAlternateData_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceAlternateData_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private byte[] success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceAlternateData_result() {
        }

        public getResourceAlternateData_result(getResourceAlternateData_result other) {
            if (other.isSetSuccess()) {
                this.success = new byte[other.success.length];
                System.arraycopy(other.success, 0, this.success, 0, other.success.length);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceAlternateData_result deepCopy() {
            return new getResourceAlternateData_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceAlternateData_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceAlternateData_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readBytes();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeBinary(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceApplicationDataEntry_args
    implements TBase<getResourceApplicationDataEntry_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceApplicationDataEntry_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private static final TField KEY_FIELD_DESC = new TField("key", 11, 3);
        private String authenticationToken;
        private String guid;
        private String key;

        public getResourceApplicationDataEntry_args() {
        }

        public getResourceApplicationDataEntry_args(getResourceApplicationDataEntry_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            if (other.isSetKey()) {
                this.key = other.key;
            }
        }

        public getResourceApplicationDataEntry_args deepCopy() {
            return new getResourceApplicationDataEntry_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
            this.key = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean isSetKey() {
            return this.key != null;
        }

        @Override
        public int compareTo(getResourceApplicationDataEntry_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceApplicationDataEntry_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(typedOther.isSetKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo(this.key, typedOther.key)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.key = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            if (this.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                oprot.writeString(this.key);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceApplicationDataEntry_result
    implements TBase<getResourceApplicationDataEntry_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceApplicationDataEntry_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private String success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceApplicationDataEntry_result() {
        }

        public getResourceApplicationDataEntry_result(getResourceApplicationDataEntry_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceApplicationDataEntry_result deepCopy() {
            return new getResourceApplicationDataEntry_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceApplicationDataEntry_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceApplicationDataEntry_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeString(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceApplicationData_args
    implements TBase<getResourceApplicationData_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceApplicationData_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getResourceApplicationData_args() {
        }

        public getResourceApplicationData_args(getResourceApplicationData_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getResourceApplicationData_args deepCopy() {
            return new getResourceApplicationData_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getResourceApplicationData_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceApplicationData_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceApplicationData_result
    implements TBase<getResourceApplicationData_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceApplicationData_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private LazyMap success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceApplicationData_result() {
        }

        public getResourceApplicationData_result(getResourceApplicationData_result other) {
            if (other.isSetSuccess()) {
                this.success = new LazyMap(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceApplicationData_result deepCopy() {
            return new getResourceApplicationData_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceApplicationData_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceApplicationData_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new LazyMap();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceAttributes_args
    implements TBase<getResourceAttributes_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceAttributes_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getResourceAttributes_args() {
        }

        public getResourceAttributes_args(getResourceAttributes_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getResourceAttributes_args deepCopy() {
            return new getResourceAttributes_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getResourceAttributes_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceAttributes_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceAttributes_result
    implements TBase<getResourceAttributes_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceAttributes_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private ResourceAttributes success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceAttributes_result() {
        }

        public getResourceAttributes_result(getResourceAttributes_result other) {
            if (other.isSetSuccess()) {
                this.success = new ResourceAttributes(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceAttributes_result deepCopy() {
            return new getResourceAttributes_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceAttributes_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceAttributes_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new ResourceAttributes();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceByHash_args
    implements TBase<getResourceByHash_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceByHash_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTE_GUID_FIELD_DESC = new TField("noteGuid", 11, 2);
        private static final TField CONTENT_HASH_FIELD_DESC = new TField("contentHash", 11, 3);
        private static final TField WITH_DATA_FIELD_DESC = new TField("withData", 2, 4);
        private static final TField WITH_RECOGNITION_FIELD_DESC = new TField("withRecognition", 2, 5);
        private static final TField WITH_ALTERNATE_DATA_FIELD_DESC = new TField("withAlternateData", 2, 6);
        private String authenticationToken;
        private String noteGuid;
        private byte[] contentHash;
        private boolean withData;
        private boolean withRecognition;
        private boolean withAlternateData;
        private static final int __WITHDATA_ISSET_ID = 0;
        private static final int __WITHRECOGNITION_ISSET_ID = 1;
        private static final int __WITHALTERNATEDATA_ISSET_ID = 2;
        private boolean[] __isset_vector = new boolean[3];

        public getResourceByHash_args() {
        }

        public getResourceByHash_args(getResourceByHash_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNoteGuid()) {
                this.noteGuid = other.noteGuid;
            }
            if (other.isSetContentHash()) {
                this.contentHash = new byte[other.contentHash.length];
                System.arraycopy(other.contentHash, 0, this.contentHash, 0, other.contentHash.length);
            }
            this.withData = other.withData;
            this.withRecognition = other.withRecognition;
            this.withAlternateData = other.withAlternateData;
        }

        public getResourceByHash_args deepCopy() {
            return new getResourceByHash_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.noteGuid = null;
            this.contentHash = null;
            this.setWithDataIsSet(false);
            this.withData = false;
            this.setWithRecognitionIsSet(false);
            this.withRecognition = false;
            this.setWithAlternateDataIsSet(false);
            this.withAlternateData = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNoteGuid(String noteGuid) {
            this.noteGuid = noteGuid;
        }

        public boolean isSetNoteGuid() {
            return this.noteGuid != null;
        }

        public void setContentHash(byte[] contentHash) {
            this.contentHash = contentHash;
        }

        public boolean isSetContentHash() {
            return this.contentHash != null;
        }

        public void setWithData(boolean withData) {
            this.withData = withData;
            this.setWithDataIsSet(true);
        }

        public boolean isSetWithData() {
            return this.__isset_vector[0];
        }

        public void setWithDataIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setWithRecognition(boolean withRecognition) {
            this.withRecognition = withRecognition;
            this.setWithRecognitionIsSet(true);
        }

        public boolean isSetWithRecognition() {
            return this.__isset_vector[1];
        }

        public void setWithRecognitionIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setWithAlternateData(boolean withAlternateData) {
            this.withAlternateData = withAlternateData;
            this.setWithAlternateDataIsSet(true);
        }

        public boolean isSetWithAlternateData() {
            return this.__isset_vector[2];
        }

        public void setWithAlternateDataIsSet(boolean value) {
            this.__isset_vector[2] = value;
        }

        @Override
        public int compareTo(getResourceByHash_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceByHash_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNoteGuid()).compareTo(typedOther.isSetNoteGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNoteGuid() && (lastComparison = TBaseHelper.compareTo(this.noteGuid, typedOther.noteGuid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetContentHash()).compareTo(typedOther.isSetContentHash());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetContentHash() && (lastComparison = TBaseHelper.compareTo(this.contentHash, typedOther.contentHash)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithData()).compareTo(typedOther.isSetWithData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithData() && (lastComparison = TBaseHelper.compareTo(this.withData, typedOther.withData)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithRecognition()).compareTo(typedOther.isSetWithRecognition());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithRecognition() && (lastComparison = TBaseHelper.compareTo(this.withRecognition, typedOther.withRecognition)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithAlternateData()).compareTo(typedOther.isSetWithAlternateData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithAlternateData() && (lastComparison = TBaseHelper.compareTo(this.withAlternateData, typedOther.withAlternateData)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.noteGuid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.contentHash = iprot.readBytes();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 2) {
                            this.withData = iprot.readBool();
                            this.setWithDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 2) {
                            this.withRecognition = iprot.readBool();
                            this.setWithRecognitionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 6: {
                        if (field.type == 2) {
                            this.withAlternateData = iprot.readBool();
                            this.setWithAlternateDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.noteGuid != null) {
                oprot.writeFieldBegin(NOTE_GUID_FIELD_DESC);
                oprot.writeString(this.noteGuid);
                oprot.writeFieldEnd();
            }
            if (this.contentHash != null) {
                oprot.writeFieldBegin(CONTENT_HASH_FIELD_DESC);
                oprot.writeBinary(this.contentHash);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(WITH_DATA_FIELD_DESC);
            oprot.writeBool(this.withData);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RECOGNITION_FIELD_DESC);
            oprot.writeBool(this.withRecognition);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_ALTERNATE_DATA_FIELD_DESC);
            oprot.writeBool(this.withAlternateData);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceByHash_result
    implements TBase<getResourceByHash_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceByHash_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Resource success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceByHash_result() {
        }

        public getResourceByHash_result(getResourceByHash_result other) {
            if (other.isSetSuccess()) {
                this.success = new Resource(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceByHash_result deepCopy() {
            return new getResourceByHash_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceByHash_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceByHash_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Resource();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceData_args
    implements TBase<getResourceData_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceData_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getResourceData_args() {
        }

        public getResourceData_args(getResourceData_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getResourceData_args deepCopy() {
            return new getResourceData_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getResourceData_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceData_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceData_result
    implements TBase<getResourceData_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceData_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private byte[] success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceData_result() {
        }

        public getResourceData_result(getResourceData_result other) {
            if (other.isSetSuccess()) {
                this.success = new byte[other.success.length];
                System.arraycopy(other.success, 0, this.success, 0, other.success.length);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceData_result deepCopy() {
            return new getResourceData_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceData_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceData_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readBytes();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeBinary(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceRecognition_args
    implements TBase<getResourceRecognition_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceRecognition_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getResourceRecognition_args() {
        }

        public getResourceRecognition_args(getResourceRecognition_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getResourceRecognition_args deepCopy() {
            return new getResourceRecognition_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getResourceRecognition_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceRecognition_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceRecognition_result
    implements TBase<getResourceRecognition_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceRecognition_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private byte[] success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceRecognition_result() {
        }

        public getResourceRecognition_result(getResourceRecognition_result other) {
            if (other.isSetSuccess()) {
                this.success = new byte[other.success.length];
                System.arraycopy(other.success, 0, this.success, 0, other.success.length);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceRecognition_result deepCopy() {
            return new getResourceRecognition_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceRecognition_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceRecognition_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readBytes();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeBinary(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceSearchText_args
    implements TBase<getResourceSearchText_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceSearchText_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getResourceSearchText_args() {
        }

        public getResourceSearchText_args(getResourceSearchText_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getResourceSearchText_args deepCopy() {
            return new getResourceSearchText_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getResourceSearchText_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceSearchText_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResourceSearchText_result
    implements TBase<getResourceSearchText_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResourceSearchText_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private String success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResourceSearchText_result() {
        }

        public getResourceSearchText_result(getResourceSearchText_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResourceSearchText_result deepCopy() {
            return new getResourceSearchText_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResourceSearchText_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResourceSearchText_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeString(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResource_args
    implements TBase<getResource_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResource_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private static final TField WITH_DATA_FIELD_DESC = new TField("withData", 2, 3);
        private static final TField WITH_RECOGNITION_FIELD_DESC = new TField("withRecognition", 2, 4);
        private static final TField WITH_ATTRIBUTES_FIELD_DESC = new TField("withAttributes", 2, 5);
        private static final TField WITH_ALTERNATE_DATA_FIELD_DESC = new TField("withAlternateData", 2, 6);
        private String authenticationToken;
        private String guid;
        private boolean withData;
        private boolean withRecognition;
        private boolean withAttributes;
        private boolean withAlternateData;
        private static final int __WITHDATA_ISSET_ID = 0;
        private static final int __WITHRECOGNITION_ISSET_ID = 1;
        private static final int __WITHATTRIBUTES_ISSET_ID = 2;
        private static final int __WITHALTERNATEDATA_ISSET_ID = 3;
        private boolean[] __isset_vector = new boolean[4];

        public getResource_args() {
        }

        public getResource_args(getResource_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            this.withData = other.withData;
            this.withRecognition = other.withRecognition;
            this.withAttributes = other.withAttributes;
            this.withAlternateData = other.withAlternateData;
        }

        public getResource_args deepCopy() {
            return new getResource_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
            this.setWithDataIsSet(false);
            this.withData = false;
            this.setWithRecognitionIsSet(false);
            this.withRecognition = false;
            this.setWithAttributesIsSet(false);
            this.withAttributes = false;
            this.setWithAlternateDataIsSet(false);
            this.withAlternateData = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setWithData(boolean withData) {
            this.withData = withData;
            this.setWithDataIsSet(true);
        }

        public boolean isSetWithData() {
            return this.__isset_vector[0];
        }

        public void setWithDataIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setWithRecognition(boolean withRecognition) {
            this.withRecognition = withRecognition;
            this.setWithRecognitionIsSet(true);
        }

        public boolean isSetWithRecognition() {
            return this.__isset_vector[1];
        }

        public void setWithRecognitionIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setWithAttributes(boolean withAttributes) {
            this.withAttributes = withAttributes;
            this.setWithAttributesIsSet(true);
        }

        public boolean isSetWithAttributes() {
            return this.__isset_vector[2];
        }

        public void setWithAttributesIsSet(boolean value) {
            this.__isset_vector[2] = value;
        }

        public void setWithAlternateData(boolean withAlternateData) {
            this.withAlternateData = withAlternateData;
            this.setWithAlternateDataIsSet(true);
        }

        public boolean isSetWithAlternateData() {
            return this.__isset_vector[3];
        }

        public void setWithAlternateDataIsSet(boolean value) {
            this.__isset_vector[3] = value;
        }

        @Override
        public int compareTo(getResource_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResource_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithData()).compareTo(typedOther.isSetWithData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithData() && (lastComparison = TBaseHelper.compareTo(this.withData, typedOther.withData)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithRecognition()).compareTo(typedOther.isSetWithRecognition());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithRecognition() && (lastComparison = TBaseHelper.compareTo(this.withRecognition, typedOther.withRecognition)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithAttributes()).compareTo(typedOther.isSetWithAttributes());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithAttributes() && (lastComparison = TBaseHelper.compareTo(this.withAttributes, typedOther.withAttributes)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetWithAlternateData()).compareTo(typedOther.isSetWithAlternateData());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetWithAlternateData() && (lastComparison = TBaseHelper.compareTo(this.withAlternateData, typedOther.withAlternateData)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 2) {
                            this.withData = iprot.readBool();
                            this.setWithDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 2) {
                            this.withRecognition = iprot.readBool();
                            this.setWithRecognitionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 2) {
                            this.withAttributes = iprot.readBool();
                            this.setWithAttributesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 6: {
                        if (field.type == 2) {
                            this.withAlternateData = iprot.readBool();
                            this.setWithAlternateDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(WITH_DATA_FIELD_DESC);
            oprot.writeBool(this.withData);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_RECOGNITION_FIELD_DESC);
            oprot.writeBool(this.withRecognition);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_ATTRIBUTES_FIELD_DESC);
            oprot.writeBool(this.withAttributes);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WITH_ALTERNATE_DATA_FIELD_DESC);
            oprot.writeBool(this.withAlternateData);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getResource_result
    implements TBase<getResource_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getResource_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Resource success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getResource_result() {
        }

        public getResource_result(getResource_result other) {
            if (other.isSetSuccess()) {
                this.success = new Resource(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getResource_result deepCopy() {
            return new getResource_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getResource_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getResource_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Resource();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSearch_args
    implements TBase<getSearch_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSearch_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getSearch_args() {
        }

        public getSearch_args(getSearch_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getSearch_args deepCopy() {
            return new getSearch_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getSearch_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSearch_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSearch_result
    implements TBase<getSearch_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSearch_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private SavedSearch success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getSearch_result() {
        }

        public getSearch_result(getSearch_result other) {
            if (other.isSetSuccess()) {
                this.success = new SavedSearch(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getSearch_result deepCopy() {
            return new getSearch_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getSearch_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSearch_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SavedSearch();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSharedNotebookByAuth_args
    implements TBase<getSharedNotebookByAuth_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSharedNotebookByAuth_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public getSharedNotebookByAuth_args() {
        }

        public getSharedNotebookByAuth_args(getSharedNotebookByAuth_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public getSharedNotebookByAuth_args deepCopy() {
            return new getSharedNotebookByAuth_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(getSharedNotebookByAuth_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSharedNotebookByAuth_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSharedNotebookByAuth_result
    implements TBase<getSharedNotebookByAuth_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSharedNotebookByAuth_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private SharedNotebook success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public getSharedNotebookByAuth_result() {
        }

        public getSharedNotebookByAuth_result(getSharedNotebookByAuth_result other) {
            if (other.isSetSuccess()) {
                this.success = new SharedNotebook(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getSharedNotebookByAuth_result deepCopy() {
            return new getSharedNotebookByAuth_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getSharedNotebookByAuth_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSharedNotebookByAuth_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SharedNotebook();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSyncChunk_args
    implements TBase<getSyncChunk_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSyncChunk_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField AFTER_USN_FIELD_DESC = new TField("afterUSN", 8, 2);
        private static final TField MAX_ENTRIES_FIELD_DESC = new TField("maxEntries", 8, 3);
        private static final TField FULL_SYNC_ONLY_FIELD_DESC = new TField("fullSyncOnly", 2, 4);
        private String authenticationToken;
        private int afterUSN;
        private int maxEntries;
        private boolean fullSyncOnly;
        private static final int __AFTERUSN_ISSET_ID = 0;
        private static final int __MAXENTRIES_ISSET_ID = 1;
        private static final int __FULLSYNCONLY_ISSET_ID = 2;
        private boolean[] __isset_vector = new boolean[3];

        public getSyncChunk_args() {
        }

        public getSyncChunk_args(getSyncChunk_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            this.afterUSN = other.afterUSN;
            this.maxEntries = other.maxEntries;
            this.fullSyncOnly = other.fullSyncOnly;
        }

        public getSyncChunk_args deepCopy() {
            return new getSyncChunk_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.setAfterUSNIsSet(false);
            this.afterUSN = 0;
            this.setMaxEntriesIsSet(false);
            this.maxEntries = 0;
            this.setFullSyncOnlyIsSet(false);
            this.fullSyncOnly = false;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setAfterUSN(int afterUSN) {
            this.afterUSN = afterUSN;
            this.setAfterUSNIsSet(true);
        }

        public boolean isSetAfterUSN() {
            return this.__isset_vector[0];
        }

        public void setAfterUSNIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setMaxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
            this.setMaxEntriesIsSet(true);
        }

        public boolean isSetMaxEntries() {
            return this.__isset_vector[1];
        }

        public void setMaxEntriesIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        public void setFullSyncOnly(boolean fullSyncOnly) {
            this.fullSyncOnly = fullSyncOnly;
            this.setFullSyncOnlyIsSet(true);
        }

        public boolean isSetFullSyncOnly() {
            return this.__isset_vector[2];
        }

        public void setFullSyncOnlyIsSet(boolean value) {
            this.__isset_vector[2] = value;
        }

        @Override
        public int compareTo(getSyncChunk_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSyncChunk_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetAfterUSN()).compareTo(typedOther.isSetAfterUSN());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAfterUSN() && (lastComparison = TBaseHelper.compareTo(this.afterUSN, typedOther.afterUSN)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetMaxEntries()).compareTo(typedOther.isSetMaxEntries());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetMaxEntries() && (lastComparison = TBaseHelper.compareTo(this.maxEntries, typedOther.maxEntries)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFullSyncOnly()).compareTo(typedOther.isSetFullSyncOnly());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFullSyncOnly() && (lastComparison = TBaseHelper.compareTo(this.fullSyncOnly, typedOther.fullSyncOnly)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 8) {
                            this.afterUSN = iprot.readI32();
                            this.setAfterUSNIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 8) {
                            this.maxEntries = iprot.readI32();
                            this.setMaxEntriesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 2) {
                            this.fullSyncOnly = iprot.readBool();
                            this.setFullSyncOnlyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(AFTER_USN_FIELD_DESC);
            oprot.writeI32(this.afterUSN);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_ENTRIES_FIELD_DESC);
            oprot.writeI32(this.maxEntries);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(FULL_SYNC_ONLY_FIELD_DESC);
            oprot.writeBool(this.fullSyncOnly);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSyncChunk_result
    implements TBase<getSyncChunk_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSyncChunk_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private SyncChunk success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getSyncChunk_result() {
        }

        public getSyncChunk_result(getSyncChunk_result other) {
            if (other.isSetSuccess()) {
                this.success = new SyncChunk(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getSyncChunk_result deepCopy() {
            return new getSyncChunk_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getSyncChunk_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSyncChunk_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SyncChunk();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSyncStateWithMetrics_args
    implements TBase<getSyncStateWithMetrics_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSyncStateWithMetrics_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField CLIENT_METRICS_FIELD_DESC = new TField("clientMetrics", 12, 2);
        private String authenticationToken;
        private ClientUsageMetrics clientMetrics;

        public getSyncStateWithMetrics_args() {
        }

        public getSyncStateWithMetrics_args(getSyncStateWithMetrics_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetClientMetrics()) {
                this.clientMetrics = new ClientUsageMetrics(other.clientMetrics);
            }
        }

        public getSyncStateWithMetrics_args deepCopy() {
            return new getSyncStateWithMetrics_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.clientMetrics = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setClientMetrics(ClientUsageMetrics clientMetrics) {
            this.clientMetrics = clientMetrics;
        }

        public boolean isSetClientMetrics() {
            return this.clientMetrics != null;
        }

        @Override
        public int compareTo(getSyncStateWithMetrics_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSyncStateWithMetrics_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetClientMetrics()).compareTo(typedOther.isSetClientMetrics());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetClientMetrics() && (lastComparison = TBaseHelper.compareTo(this.clientMetrics, typedOther.clientMetrics)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.clientMetrics = new ClientUsageMetrics();
                            this.clientMetrics.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.clientMetrics != null) {
                oprot.writeFieldBegin(CLIENT_METRICS_FIELD_DESC);
                this.clientMetrics.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSyncStateWithMetrics_result
    implements TBase<getSyncStateWithMetrics_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSyncStateWithMetrics_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private SyncState success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getSyncStateWithMetrics_result() {
        }

        public getSyncStateWithMetrics_result(getSyncStateWithMetrics_result other) {
            if (other.isSetSuccess()) {
                this.success = new SyncState(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getSyncStateWithMetrics_result deepCopy() {
            return new getSyncStateWithMetrics_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getSyncStateWithMetrics_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSyncStateWithMetrics_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SyncState();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSyncState_args
    implements TBase<getSyncState_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSyncState_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public getSyncState_args() {
        }

        public getSyncState_args(getSyncState_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public getSyncState_args deepCopy() {
            return new getSyncState_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(getSyncState_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSyncState_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getSyncState_result
    implements TBase<getSyncState_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getSyncState_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private SyncState success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getSyncState_result() {
        }

        public getSyncState_result(getSyncState_result other) {
            if (other.isSetSuccess()) {
                this.success = new SyncState(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getSyncState_result deepCopy() {
            return new getSyncState_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getSyncState_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getSyncState_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new SyncState();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getTag_args
    implements TBase<getTag_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getTag_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public getTag_args() {
        }

        public getTag_args(getTag_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public getTag_args deepCopy() {
            return new getTag_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(getTag_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getTag_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getTag_result
    implements TBase<getTag_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getTag_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private Tag success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public getTag_result() {
        }

        public getTag_result(getTag_result other) {
            if (other.isSetSuccess()) {
                this.success = new Tag(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public getTag_result deepCopy() {
            return new getTag_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(getTag_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getTag_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new Tag();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listLinkedNotebooks_args
    implements TBase<listLinkedNotebooks_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listLinkedNotebooks_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public listLinkedNotebooks_args() {
        }

        public listLinkedNotebooks_args(listLinkedNotebooks_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public listLinkedNotebooks_args deepCopy() {
            return new listLinkedNotebooks_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(listLinkedNotebooks_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listLinkedNotebooks_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listLinkedNotebooks_result
    implements TBase<listLinkedNotebooks_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listLinkedNotebooks_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private List<LinkedNotebook> success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public listLinkedNotebooks_result() {
        }

        public listLinkedNotebooks_result(listLinkedNotebooks_result other) {
            if (other.isSetSuccess()) {
                ArrayList<LinkedNotebook> __this__success = new ArrayList<LinkedNotebook>();
                for (LinkedNotebook other_element : other.success) {
                    __this__success.add(new LinkedNotebook(other_element));
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public listLinkedNotebooks_result deepCopy() {
            return new listLinkedNotebooks_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(listLinkedNotebooks_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listLinkedNotebooks_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list150 = iprot.readListBegin();
                            this.success = new ArrayList<LinkedNotebook>(_list150.size);
                            int _i151 = 0;
                            while (_i151 < _list150.size) {
                                LinkedNotebook _elem152 = new LinkedNotebook();
                                _elem152.read(iprot);
                                this.success.add(_elem152);
                                ++_i151;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, this.success.size()));
                for (LinkedNotebook _iter153 : this.success) {
                    _iter153.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listNoteVersions_args
    implements TBase<listNoteVersions_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listNoteVersions_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTE_GUID_FIELD_DESC = new TField("noteGuid", 11, 2);
        private String authenticationToken;
        private String noteGuid;

        public listNoteVersions_args() {
        }

        public listNoteVersions_args(listNoteVersions_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNoteGuid()) {
                this.noteGuid = other.noteGuid;
            }
        }

        public listNoteVersions_args deepCopy() {
            return new listNoteVersions_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.noteGuid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNoteGuid(String noteGuid) {
            this.noteGuid = noteGuid;
        }

        public boolean isSetNoteGuid() {
            return this.noteGuid != null;
        }

        @Override
        public int compareTo(listNoteVersions_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listNoteVersions_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNoteGuid()).compareTo(typedOther.isSetNoteGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNoteGuid() && (lastComparison = TBaseHelper.compareTo(this.noteGuid, typedOther.noteGuid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.noteGuid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.noteGuid != null) {
                oprot.writeFieldBegin(NOTE_GUID_FIELD_DESC);
                oprot.writeString(this.noteGuid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listNoteVersions_result
    implements TBase<listNoteVersions_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listNoteVersions_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private List<NoteVersionId> success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public listNoteVersions_result() {
        }

        public listNoteVersions_result(listNoteVersions_result other) {
            if (other.isSetSuccess()) {
                ArrayList<NoteVersionId> __this__success = new ArrayList<NoteVersionId>();
                for (NoteVersionId other_element : other.success) {
                    __this__success.add(new NoteVersionId(other_element));
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public listNoteVersions_result deepCopy() {
            return new listNoteVersions_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(listNoteVersions_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listNoteVersions_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list134 = iprot.readListBegin();
                            this.success = new ArrayList<NoteVersionId>(_list134.size);
                            int _i135 = 0;
                            while (_i135 < _list134.size) {
                                NoteVersionId _elem136 = new NoteVersionId();
                                _elem136.read(iprot);
                                this.success.add(_elem136);
                                ++_i135;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, this.success.size()));
                for (NoteVersionId _iter137 : this.success) {
                    _iter137.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listNotebooks_args
    implements TBase<listNotebooks_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listNotebooks_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public listNotebooks_args() {
        }

        public listNotebooks_args(listNotebooks_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public listNotebooks_args deepCopy() {
            return new listNotebooks_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(listNotebooks_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listNotebooks_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listNotebooks_result
    implements TBase<listNotebooks_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listNotebooks_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private List<Notebook> success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public listNotebooks_result() {
        }

        public listNotebooks_result(listNotebooks_result other) {
            if (other.isSetSuccess()) {
                ArrayList<Notebook> __this__success = new ArrayList<Notebook>();
                for (Notebook other_element : other.success) {
                    __this__success.add(new Notebook(other_element));
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public listNotebooks_result deepCopy() {
            return new listNotebooks_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(listNotebooks_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listNotebooks_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list110 = iprot.readListBegin();
                            this.success = new ArrayList<Notebook>(_list110.size);
                            int _i111 = 0;
                            while (_i111 < _list110.size) {
                                Notebook _elem112 = new Notebook();
                                _elem112.read(iprot);
                                this.success.add(_elem112);
                                ++_i111;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, this.success.size()));
                for (Notebook _iter113 : this.success) {
                    _iter113.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listSearches_args
    implements TBase<listSearches_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listSearches_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public listSearches_args() {
        }

        public listSearches_args(listSearches_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public listSearches_args deepCopy() {
            return new listSearches_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(listSearches_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listSearches_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listSearches_result
    implements TBase<listSearches_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listSearches_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private List<SavedSearch> success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public listSearches_result() {
        }

        public listSearches_result(listSearches_result other) {
            if (other.isSetSuccess()) {
                ArrayList<SavedSearch> __this__success = new ArrayList<SavedSearch>();
                for (SavedSearch other_element : other.success) {
                    __this__success.add(new SavedSearch(other_element));
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public listSearches_result deepCopy() {
            return new listSearches_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(listSearches_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listSearches_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list122 = iprot.readListBegin();
                            this.success = new ArrayList<SavedSearch>(_list122.size);
                            int _i123 = 0;
                            while (_i123 < _list122.size) {
                                SavedSearch _elem124 = new SavedSearch();
                                _elem124.read(iprot);
                                this.success.add(_elem124);
                                ++_i123;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, this.success.size()));
                for (SavedSearch _iter125 : this.success) {
                    _iter125.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listSharedNotebooks_args
    implements TBase<listSharedNotebooks_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listSharedNotebooks_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public listSharedNotebooks_args() {
        }

        public listSharedNotebooks_args(listSharedNotebooks_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public listSharedNotebooks_args deepCopy() {
            return new listSharedNotebooks_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(listSharedNotebooks_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listSharedNotebooks_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listSharedNotebooks_result
    implements TBase<listSharedNotebooks_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listSharedNotebooks_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private List<SharedNotebook> success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public listSharedNotebooks_result() {
        }

        public listSharedNotebooks_result(listSharedNotebooks_result other) {
            if (other.isSetSuccess()) {
                ArrayList<SharedNotebook> __this__success = new ArrayList<SharedNotebook>();
                for (SharedNotebook other_element : other.success) {
                    __this__success.add(new SharedNotebook(other_element));
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public listSharedNotebooks_result deepCopy() {
            return new listSharedNotebooks_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(listSharedNotebooks_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listSharedNotebooks_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list142 = iprot.readListBegin();
                            this.success = new ArrayList<SharedNotebook>(_list142.size);
                            int _i143 = 0;
                            while (_i143 < _list142.size) {
                                SharedNotebook _elem144 = new SharedNotebook();
                                _elem144.read(iprot);
                                this.success.add(_elem144);
                                ++_i143;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, this.success.size()));
                for (SharedNotebook _iter145 : this.success) {
                    _iter145.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listTagsByNotebook_args
    implements TBase<listTagsByNotebook_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listTagsByNotebook_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTEBOOK_GUID_FIELD_DESC = new TField("notebookGuid", 11, 2);
        private String authenticationToken;
        private String notebookGuid;

        public listTagsByNotebook_args() {
        }

        public listTagsByNotebook_args(listTagsByNotebook_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNotebookGuid()) {
                this.notebookGuid = other.notebookGuid;
            }
        }

        public listTagsByNotebook_args deepCopy() {
            return new listTagsByNotebook_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.notebookGuid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNotebookGuid(String notebookGuid) {
            this.notebookGuid = notebookGuid;
        }

        public boolean isSetNotebookGuid() {
            return this.notebookGuid != null;
        }

        @Override
        public int compareTo(listTagsByNotebook_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listTagsByNotebook_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotebookGuid()).compareTo(typedOther.isSetNotebookGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotebookGuid() && (lastComparison = TBaseHelper.compareTo(this.notebookGuid, typedOther.notebookGuid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.notebookGuid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.notebookGuid != null) {
                oprot.writeFieldBegin(NOTEBOOK_GUID_FIELD_DESC);
                oprot.writeString(this.notebookGuid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listTagsByNotebook_result
    implements TBase<listTagsByNotebook_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listTagsByNotebook_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private List<Tag> success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;

        public listTagsByNotebook_result() {
        }

        public listTagsByNotebook_result(listTagsByNotebook_result other) {
            if (other.isSetSuccess()) {
                ArrayList<Tag> __this__success = new ArrayList<Tag>();
                for (Tag other_element : other.success) {
                    __this__success.add(new Tag(other_element));
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public listTagsByNotebook_result deepCopy() {
            return new listTagsByNotebook_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(listTagsByNotebook_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listTagsByNotebook_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list118 = iprot.readListBegin();
                            this.success = new ArrayList<Tag>(_list118.size);
                            int _i119 = 0;
                            while (_i119 < _list118.size) {
                                Tag _elem120 = new Tag();
                                _elem120.read(iprot);
                                this.success.add(_elem120);
                                ++_i119;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, this.success.size()));
                for (Tag _iter121 : this.success) {
                    _iter121.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listTags_args
    implements TBase<listTags_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listTags_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public listTags_args() {
        }

        public listTags_args(listTags_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public listTags_args deepCopy() {
            return new listTags_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(listTags_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listTags_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class listTags_result
    implements TBase<listTags_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("listTags_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 15, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private List<Tag> success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public listTags_result() {
        }

        public listTags_result(listTags_result other) {
            if (other.isSetSuccess()) {
                ArrayList<Tag> __this__success = new ArrayList<Tag>();
                for (Tag other_element : other.success) {
                    __this__success.add(new Tag(other_element));
                }
                this.success = __this__success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public listTags_result deepCopy() {
            return new listTags_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(listTags_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            listTags_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 15) {
                            TList _list114 = iprot.readListBegin();
                            this.success = new ArrayList<Tag>(_list114.size);
                            int _i115 = 0;
                            while (_i115 < _list114.size) {
                                Tag _elem116 = new Tag();
                                _elem116.read(iprot);
                                this.success.add(_elem116);
                                ++_i115;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, this.success.size()));
                for (Tag _iter117 : this.success) {
                    _iter117.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class sendMessageToSharedNotebookMembers_args
    implements TBase<sendMessageToSharedNotebookMembers_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("sendMessageToSharedNotebookMembers_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField NOTEBOOK_GUID_FIELD_DESC = new TField("notebookGuid", 11, 2);
        private static final TField MESSAGE_TEXT_FIELD_DESC = new TField("messageText", 11, 3);
        private static final TField RECIPIENTS_FIELD_DESC = new TField("recipients", 15, 4);
        private String authenticationToken;
        private String notebookGuid;
        private String messageText;
        private List<String> recipients;

        public sendMessageToSharedNotebookMembers_args() {
        }

        public sendMessageToSharedNotebookMembers_args(sendMessageToSharedNotebookMembers_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetNotebookGuid()) {
                this.notebookGuid = other.notebookGuid;
            }
            if (other.isSetMessageText()) {
                this.messageText = other.messageText;
            }
            if (other.isSetRecipients()) {
                ArrayList<String> __this__recipients = new ArrayList<String>();
                for (String other_element : other.recipients) {
                    __this__recipients.add(other_element);
                }
                this.recipients = __this__recipients;
            }
        }

        public sendMessageToSharedNotebookMembers_args deepCopy() {
            return new sendMessageToSharedNotebookMembers_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.notebookGuid = null;
            this.messageText = null;
            this.recipients = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setNotebookGuid(String notebookGuid) {
            this.notebookGuid = notebookGuid;
        }

        public boolean isSetNotebookGuid() {
            return this.notebookGuid != null;
        }

        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        public boolean isSetMessageText() {
            return this.messageText != null;
        }

        public void setRecipients(List<String> recipients) {
            this.recipients = recipients;
        }

        public boolean isSetRecipients() {
            return this.recipients != null;
        }

        @Override
        public int compareTo(sendMessageToSharedNotebookMembers_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            sendMessageToSharedNotebookMembers_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotebookGuid()).compareTo(typedOther.isSetNotebookGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotebookGuid() && (lastComparison = TBaseHelper.compareTo(this.notebookGuid, typedOther.notebookGuid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetMessageText()).compareTo(typedOther.isSetMessageText());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetMessageText() && (lastComparison = TBaseHelper.compareTo(this.messageText, typedOther.messageText)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetRecipients()).compareTo(typedOther.isSetRecipients());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetRecipients() && (lastComparison = TBaseHelper.compareTo(this.recipients, typedOther.recipients)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.notebookGuid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.messageText = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 15) {
                            TList _list138 = iprot.readListBegin();
                            this.recipients = new ArrayList<String>(_list138.size);
                            int _i139 = 0;
                            while (_i139 < _list138.size) {
                                String _elem140 = iprot.readString();
                                this.recipients.add(_elem140);
                                ++_i139;
                            }
                            iprot.readListEnd();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.notebookGuid != null) {
                oprot.writeFieldBegin(NOTEBOOK_GUID_FIELD_DESC);
                oprot.writeString(this.notebookGuid);
                oprot.writeFieldEnd();
            }
            if (this.messageText != null) {
                oprot.writeFieldBegin(MESSAGE_TEXT_FIELD_DESC);
                oprot.writeString(this.messageText);
                oprot.writeFieldEnd();
            }
            if (this.recipients != null) {
                oprot.writeFieldBegin(RECIPIENTS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, this.recipients.size()));
                for (String _iter141 : this.recipients) {
                    oprot.writeString(_iter141);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class sendMessageToSharedNotebookMembers_result
    implements TBase<sendMessageToSharedNotebookMembers_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("sendMessageToSharedNotebookMembers_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public sendMessageToSharedNotebookMembers_result() {
        }

        public sendMessageToSharedNotebookMembers_result(sendMessageToSharedNotebookMembers_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public sendMessageToSharedNotebookMembers_result deepCopy() {
            return new sendMessageToSharedNotebookMembers_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(sendMessageToSharedNotebookMembers_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            sendMessageToSharedNotebookMembers_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class setNoteApplicationDataEntry_args
    implements TBase<setNoteApplicationDataEntry_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setNoteApplicationDataEntry_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private static final TField KEY_FIELD_DESC = new TField("key", 11, 3);
        private static final TField VALUE_FIELD_DESC = new TField("value", 11, 4);
        private String authenticationToken;
        private String guid;
        private String key;
        private String value;

        public setNoteApplicationDataEntry_args() {
        }

        public setNoteApplicationDataEntry_args(setNoteApplicationDataEntry_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            if (other.isSetKey()) {
                this.key = other.key;
            }
            if (other.isSetValue()) {
                this.value = other.value;
            }
        }

        public setNoteApplicationDataEntry_args deepCopy() {
            return new setNoteApplicationDataEntry_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
            this.key = null;
            this.value = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean isSetKey() {
            return this.key != null;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSetValue() {
            return this.value != null;
        }

        @Override
        public int compareTo(setNoteApplicationDataEntry_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setNoteApplicationDataEntry_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(typedOther.isSetKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo(this.key, typedOther.key)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(typedOther.isSetValue());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo(this.value, typedOther.value)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.key = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 11) {
                            this.value = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            if (this.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                oprot.writeString(this.key);
                oprot.writeFieldEnd();
            }
            if (this.value != null) {
                oprot.writeFieldBegin(VALUE_FIELD_DESC);
                oprot.writeString(this.value);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class setNoteApplicationDataEntry_result
    implements TBase<setNoteApplicationDataEntry_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setNoteApplicationDataEntry_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public setNoteApplicationDataEntry_result() {
        }

        public setNoteApplicationDataEntry_result(setNoteApplicationDataEntry_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public setNoteApplicationDataEntry_result deepCopy() {
            return new setNoteApplicationDataEntry_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(setNoteApplicationDataEntry_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setNoteApplicationDataEntry_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class setResourceApplicationDataEntry_args
    implements TBase<setResourceApplicationDataEntry_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setResourceApplicationDataEntry_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private static final TField KEY_FIELD_DESC = new TField("key", 11, 3);
        private static final TField VALUE_FIELD_DESC = new TField("value", 11, 4);
        private String authenticationToken;
        private String guid;
        private String key;
        private String value;

        public setResourceApplicationDataEntry_args() {
        }

        public setResourceApplicationDataEntry_args(setResourceApplicationDataEntry_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
            if (other.isSetKey()) {
                this.key = other.key;
            }
            if (other.isSetValue()) {
                this.value = other.value;
            }
        }

        public setResourceApplicationDataEntry_args deepCopy() {
            return new setResourceApplicationDataEntry_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
            this.key = null;
            this.value = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean isSetKey() {
            return this.key != null;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSetValue() {
            return this.value != null;
        }

        @Override
        public int compareTo(setResourceApplicationDataEntry_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setResourceApplicationDataEntry_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(typedOther.isSetKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo(this.key, typedOther.key)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(typedOther.isSetValue());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo(this.value, typedOther.value)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.key = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 11) {
                            this.value = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            if (this.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                oprot.writeString(this.key);
                oprot.writeFieldEnd();
            }
            if (this.value != null) {
                oprot.writeFieldBegin(VALUE_FIELD_DESC);
                oprot.writeString(this.value);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class setResourceApplicationDataEntry_result
    implements TBase<setResourceApplicationDataEntry_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setResourceApplicationDataEntry_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;
        private EDAMNotFoundException notFoundException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public setResourceApplicationDataEntry_result() {
        }

        public setResourceApplicationDataEntry_result(setResourceApplicationDataEntry_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
        }

        public setResourceApplicationDataEntry_result deepCopy() {
            return new setResourceApplicationDataEntry_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.systemException = null;
            this.notFoundException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        @Override
        public int compareTo(setResourceApplicationDataEntry_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setResourceApplicationDataEntry_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class setSharedNotebookRecipientSettings_args
    implements TBase<setSharedNotebookRecipientSettings_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setSharedNotebookRecipientSettings_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField SHARED_NOTEBOOK_ID_FIELD_DESC = new TField("sharedNotebookId", 10, 2);
        private static final TField RECIPIENT_SETTINGS_FIELD_DESC = new TField("recipientSettings", 12, 3);
        private String authenticationToken;
        private long sharedNotebookId;
        private SharedNotebookRecipientSettings recipientSettings;
        private static final int __SHAREDNOTEBOOKID_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public setSharedNotebookRecipientSettings_args() {
        }

        public setSharedNotebookRecipientSettings_args(setSharedNotebookRecipientSettings_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            this.sharedNotebookId = other.sharedNotebookId;
            if (other.isSetRecipientSettings()) {
                this.recipientSettings = new SharedNotebookRecipientSettings(other.recipientSettings);
            }
        }

        public setSharedNotebookRecipientSettings_args deepCopy() {
            return new setSharedNotebookRecipientSettings_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.setSharedNotebookIdIsSet(false);
            this.sharedNotebookId = 0L;
            this.recipientSettings = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setSharedNotebookId(long sharedNotebookId) {
            this.sharedNotebookId = sharedNotebookId;
            this.setSharedNotebookIdIsSet(true);
        }

        public boolean isSetSharedNotebookId() {
            return this.__isset_vector[0];
        }

        public void setSharedNotebookIdIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setRecipientSettings(SharedNotebookRecipientSettings recipientSettings) {
            this.recipientSettings = recipientSettings;
        }

        public boolean isSetRecipientSettings() {
            return this.recipientSettings != null;
        }

        @Override
        public int compareTo(setSharedNotebookRecipientSettings_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setSharedNotebookRecipientSettings_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSharedNotebookId()).compareTo(typedOther.isSetSharedNotebookId());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSharedNotebookId() && (lastComparison = TBaseHelper.compareTo(this.sharedNotebookId, typedOther.sharedNotebookId)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetRecipientSettings()).compareTo(typedOther.isSetRecipientSettings());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetRecipientSettings() && (lastComparison = TBaseHelper.compareTo(this.recipientSettings, typedOther.recipientSettings)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 10) {
                            this.sharedNotebookId = iprot.readI64();
                            this.setSharedNotebookIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.recipientSettings = new SharedNotebookRecipientSettings();
                            this.recipientSettings.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(SHARED_NOTEBOOK_ID_FIELD_DESC);
            oprot.writeI64(this.sharedNotebookId);
            oprot.writeFieldEnd();
            if (this.recipientSettings != null) {
                oprot.writeFieldBegin(RECIPIENT_SETTINGS_FIELD_DESC);
                this.recipientSettings.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class setSharedNotebookRecipientSettings_result
    implements TBase<setSharedNotebookRecipientSettings_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setSharedNotebookRecipientSettings_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 8, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private int success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public setSharedNotebookRecipientSettings_result() {
        }

        public setSharedNotebookRecipientSettings_result(setSharedNotebookRecipientSettings_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public setSharedNotebookRecipientSettings_result deepCopy() {
            return new setSharedNotebookRecipientSettings_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(setSharedNotebookRecipientSettings_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setSharedNotebookRecipientSettings_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 8) {
                            this.success = iprot.readI32();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeI32(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class shareNote_args
    implements TBase<shareNote_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("shareNote_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField GUID_FIELD_DESC = new TField("guid", 11, 2);
        private String authenticationToken;
        private String guid;

        public shareNote_args() {
        }

        public shareNote_args(shareNote_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetGuid()) {
                this.guid = other.guid;
            }
        }

        public shareNote_args deepCopy() {
            return new shareNote_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.guid = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public boolean isSetGuid() {
            return this.guid != null;
        }

        @Override
        public int compareTo(shareNote_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            shareNote_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetGuid()).compareTo(typedOther.isSetGuid());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetGuid() && (lastComparison = TBaseHelper.compareTo(this.guid, typedOther.guid)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.guid = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.guid != null) {
                oprot.writeFieldBegin(GUID_FIELD_DESC);
                oprot.writeString(this.guid);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class shareNote_result
    implements TBase<shareNote_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("shareNote_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 2);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 3);
        private String success;
        private EDAMUserException userException;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;

        public shareNote_result() {
        }

        public shareNote_result(shareNote_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public shareNote_result deepCopy() {
            return new shareNote_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.notFoundException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(shareNote_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            shareNote_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastCompariso