/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.GEF;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.spreadsheet.Messages;
import org.xmind.ui.internal.spreadsheet.ModifyRowOrderCommand;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.internal.spreadsheet.structures.RowInsertion;
import org.xmind.ui.internal.spreadsheet.structures.RowOrder;
import org.xmind.ui.internal.spreadsheet.structures.SpreadsheetColumnStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.tools.DummyMoveTool;
import org.xmind.ui.util.MindMapUtils;

public class RowMoveTool
extends DummyMoveTool {
    private IBranchPart branch = null;
    private RowHead sourceRowHead = null;

    protected void start() {
        this.branch = (IBranchPart)super.getSource();
        this.sourceRowHead = (RowHead)MindMapUtils.getCache((IPart)this.getSource(), (String)"org.xmind.ui.spreadsheet.cache.moveSourceRowHead");
        Assert.isNotNull((Object)this.sourceRowHead);
        super.start();
    }

    protected void end() {
        IInsertion insertion = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.rowInsertion");
        if (insertion != null) {
            insertion.pullOut();
            MindMapUtils.flushCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.rowInsertion");
        }
        MindMapUtils.flushCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.moveSourceRowHead");
        super.end();
    }

    protected IFigure createDummy() {
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            RotatableWrapLabel fig = new RotatableWrapLabel(this.sourceRowHead.toString(), 0);
            layer.add((IFigure)fig);
            fig.setFont(this.sourceRowHead.getFont());
            fig.setSize(fig.getPreferredSize());
            fig.setLocation(this.getStartingPosition().getTranslated(fig.getSize().scale(0.5).negate()));
            return fig;
        }
        return null;
    }

    protected void onMoving(Point currentPos, MouseDragEvent me) {
        super.onMoving(currentPos, me);
        IStructure structure = this.branch.getBranchPolicy().getStructure((IGraphicalPart)this.branch);
        if (structure instanceof SpreadsheetColumnStructure) {
            int index = ((SpreadsheetColumnStructure)structure).calcRowInsertionIndex(this.branch, currentPos);
            this.installInsertion(index);
        }
    }

    private void installInsertion(int index) {
        IInsertion oldInsertion = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.rowInsertion");
        if (oldInsertion == null || oldInsertion.getIndex() != index) {
            if (oldInsertion != null) {
                oldInsertion.pullOut();
            }
            RowInsertion newInsertion = new RowInsertion(this.branch, index, this.sourceRowHead.getPrefSize());
            newInsertion.pushIn();
        }
    }

    protected Request createRequest() {
        IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.rowInsertion");
        if (ins != null) {
            int insIndex = ins.getIndex();
            IStructure structure = this.branch.getBranchPolicy().getStructure((IGraphicalPart)this.branch);
            if (structure instanceof SpreadsheetColumnStructure) {
                Chart2 chart = ((SpreadsheetColumnStructure)structure).getChart(this.branch);
                List<Row2> rows = chart.getRows();
                RowOrder newOrder = new RowOrder();
                int i = 0;
                while (i < rows.size()) {
                    Row2 row;
                    if (i == insIndex) {
                        newOrder.addRowHead(this.sourceRowHead);
                    }
                    if (!this.sourceRowHead.equals((row = rows.get(i)).getHead())) {
                        newOrder.addRowHead(row.getHead());
                    }
                    ++i;
                }
                ModifyRowOrderCommand command = new ModifyRowOrderCommand(chart.getTitle().getTopic(), newOrder);
                ICommandStack cs = this.getDomain().getCommandStack();
                if (cs != null) {
                    command.setLabel(Messages.Command_MoveRow);
                    cs.execute((Command)command);
                }
            }
        }
        return null;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        return Cursors.HAND;
    }
}

