/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.IReturnValueConsumer;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.command.remote.Options;
import org.xmind.core.internal.command.remote.Messages;

public abstract class RemoteCommandJob
extends Job
implements IReturnValueConsumer {
    private String pluginId;
    private IRemoteCommandService remoteCommandService;

    public RemoteCommandJob(String jobName, String pluginId, IRemoteCommandService remoteCommandService) {
        super(jobName);
        this.pluginId = pluginId;
        this.remoteCommandService = remoteCommandService;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public IRemoteCommandService getRemoteCommandService() {
        return this.remoteCommandService;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRemoteCommandService.class) {
            return this.getRemoteCommandService();
        }
        return super.getAdapter(adapter);
    }

    protected IStatus run(IProgressMonitor monitor) {
        ICommand command;
        monitor.beginTask(null, 100);
        SubProgressMonitor createCommandMonitor = new SubProgressMonitor(monitor, 10);
        try {
            command = this.createCommand((IProgressMonitor)createCommandMonitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (command == null) {
            return new Status(8, this.pluginId, Messages.RemoteCommandJob_CommandSendError_Message);
        }
        createCommandMonitor.done();
        SubProgressMonitor sendCommandMonitor = new SubProgressMonitor(monitor, 90);
        IStatus executed = this.executeCommand((IProgressMonitor)sendCommandMonitor, command);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        sendCommandMonitor.done();
        monitor.done();
        return executed;
    }

    protected IStatus executeCommand(IProgressMonitor sendCommandMonitor, ICommand command) {
        return this.getRemoteCommandService().execute(sendCommandMonitor, command, this, this.getOptions());
    }

    protected abstract ICommand createCommand(IProgressMonitor var1) throws CoreException;

    protected Options getOptions() {
        return Options.DEFAULT;
    }
}

