/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xmind.ui.color.ColorAction;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.IPaletteViewer;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.color.PaletteItem;
import org.xmind.ui.color.PaletteMessages;

public class PaletteViewer
extends Viewer
implements IPaletteViewer {
    private static final int ITEM_SIZE = 70;
    private Composite control = null;
    private PaletteContents contents = null;
    private PaletteItemAction autoAction = null;
    private PaletteItemAction noneAction = null;
    private PaletteItemAction customAction = null;
    private boolean showAuto = false;
    private boolean showNone = false;
    private boolean showCustom = false;
    private boolean showStandardLabel = true;
    private boolean hasVerticalIndent = true;
    private RGB autoColor = null;
    private ToolBarManager autoToolBar = null;
    private Control sep1 = null;
    private List<ToolBarManager> paletteToolBarManagers = null;
    private Control sep2 = null;
    private Label standard = null;
    private Control sep3 = null;
    private ToolBarManager noneToolBar = null;
    private ToolBarManager customToolBar = null;
    private List<PaletteItemAction> paletteActions = null;
    private PaletteItemAction selection = null;
    private List<IOpenListener> openListeners = null;

    public Control createControl(Composite parent) {
        if (!this.controlExists() && parent != null) {
            this.control = new Composite(parent, 524288);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.control.setLayout((Layout)layout);
            this.control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PaletteViewer.this.handleDispose(e);
                }
            });
        }
        return this.control;
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.autoToolBar != null) {
            this.autoToolBar.dispose();
        }
        if (this.noneToolBar != null) {
            this.noneToolBar.dispose();
        }
        if (this.customToolBar != null) {
            this.customToolBar.dispose();
        }
        if (this.paletteToolBarManagers != null) {
            for (ToolBarManager toolBarManager : this.paletteToolBarManagers) {
                toolBarManager.dispose();
            }
            this.paletteToolBarManagers.clear();
            this.paletteToolBarManagers = null;
        }
        if (this.sep1 != null) {
            this.sep1.dispose();
            this.sep1 = null;
        }
        if (this.sep2 != null) {
            this.sep2.dispose();
            this.sep2 = null;
        }
        if (this.sep3 != null) {
            this.sep3.dispose();
            this.sep3 = null;
        }
    }

    private boolean controlExists() {
        return this.control != null && !this.control.isDisposed();
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void setPaletteItems(PaletteItem[] items) {
        this.setContents(items == null ? null : new PaletteContents(items));
    }

    @Override
    public PaletteItem[] getPaletteItems() {
        return this.contents == null ? null : this.contents.toArray();
    }

    @Override
    public void setContents(PaletteContents contents) {
        PaletteContents oldContents = this.contents;
        this.contents = contents;
        this.inputChanged(contents, oldContents);
    }

    @Override
    public PaletteContents getContents() {
        return this.contents;
    }

    @Override
    public boolean getShowAutoItem() {
        return this.showAuto;
    }

    @Override
    public boolean getShowCustomItem() {
        return this.showCustom;
    }

    @Override
    public boolean getShowNoneItem() {
        return this.showNone;
    }

    @Override
    public void setShowAutoItem(boolean show) {
        if (show == this.getShowAutoItem()) {
            return;
        }
        this.showAuto = show;
        if (show) {
            if (this.autoToolBar == null) {
                this.autoToolBar = this.createItemBar();
            }
            if (this.autoAction == null) {
                this.autoAction = this.createItemAction(1, PaletteMessages.PaletteViewer_Automatic, this.getAutoColor(), this.autoToolBar);
            }
        } else {
            this.autoAction = null;
            if (this.autoToolBar != null) {
                this.autoToolBar.dispose();
                this.autoToolBar = null;
            }
            if (this.sep1 != null) {
                this.sep1.dispose();
                this.sep1 = null;
            }
        }
        this.refresh();
    }

    public boolean isShowStandardLabel() {
        return this.showStandardLabel;
    }

    public boolean hasVerticalIndent() {
        return this.hasVerticalIndent;
    }

    @Override
    public void setShowNoneItem(boolean show) {
        if (show == this.getShowNoneItem()) {
            return;
        }
        this.showNone = show;
        if (show) {
            if (this.noneToolBar == null) {
                this.noneToolBar = this.createItemBar();
            }
            if (this.noneAction == null) {
                this.noneAction = this.createItemAction(2, null, null, this.noneToolBar);
            }
        } else {
            this.noneAction = null;
            if (this.noneToolBar != null) {
                this.noneToolBar.dispose();
                this.noneToolBar = null;
            }
        }
        this.refresh();
    }

    @Override
    public void setShowCustomItem(boolean show) {
        if (show == this.getShowCustomItem()) {
            return;
        }
        this.showCustom = show;
        if (show) {
            if (this.customToolBar == null) {
                this.customToolBar = this.createItemBar();
            }
            if (this.customAction == null) {
                this.customAction = this.createItemAction(3, PaletteMessages.PaletteViewer_MoreColors, null, this.customToolBar);
            }
        } else {
            this.customAction = null;
            if (this.customToolBar != null) {
                this.customToolBar.dispose();
                this.customToolBar = null;
            }
            if (this.sep2 != null) {
                this.sep2.dispose();
                this.sep2 = null;
            }
            if (this.standard != null) {
                this.standard.dispose();
                this.standard = null;
            }
            if (this.sep3 != null) {
                this.sep3.dispose();
                this.sep3 = null;
            }
        }
        this.refresh();
    }

    public void setShowStandardLabel(boolean showStandardLabel) {
        this.showStandardLabel = showStandardLabel;
    }

    public void setHasVerticalIndent(boolean hasVerticalIndent) {
        this.hasVerticalIndent = hasVerticalIndent;
    }

    @Override
    public RGB getAutoColor() {
        return this.autoColor;
    }

    @Override
    public void setAutoColor(RGB color) {
        if (color == this.autoColor || color != null && color.equals((Object)this.autoColor)) {
            return;
        }
        this.autoColor = color;
        if (this.autoAction != null) {
            this.autoAction.setColor(color);
        }
    }

    public ISelection getSelection() {
        return this.selection == null ? ColorSelection.EMPTY : new ColorSelection(this.selection.getType(), this.selection.getColor());
    }

    public void refresh() {
        this.setContents(this.getContents());
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        if (this.control != null && !this.control.isDisposed()) {
            this.update(this.control, input, oldInput);
        }
    }

    private void update(Composite parent, Object input, Object oldInput) {
        boolean showAutoItem = this.getShowAutoItem();
        boolean showNoneItem = this.getShowNoneItem();
        boolean showCustomItem = this.getShowCustomItem();
        PaletteItem[] oldItems = oldInput == null ? null : ((PaletteContents)oldInput).toArray();
        PaletteItem[] newItems = input == null ? null : ((PaletteContents)input).toArray();
        boolean paletteChanged = !PaletteViewer.equals(oldItems, newItems);
        boolean showPaletteItems = newItems != null && newItems.length > 0;
        int selType = this.selection == null ? -1 : this.selection.getType();
        RGB selColor = this.selection == null ? null : this.selection.getColor();
        Control last = null;
        if (showAutoItem) {
            last = this.showItemBar(this.autoToolBar, parent, last);
            if (showPaletteItems || showNoneItem || showCustomItem) {
                if (this.sep1 == null || this.sep1.isDisposed()) {
                    this.sep1 = this.createSeparator(parent);
                }
                last = this.moveControl(this.sep1, last);
            }
        }
        if (this.paletteActions != null) {
            this.paletteActions.clear();
            this.paletteActions = null;
        }
        if (this.paletteToolBarManagers != null) {
            if (!this.paletteToolBarManagers.isEmpty()) {
                for (ToolBarManager toolBarManager : this.paletteToolBarManagers) {
                    toolBarManager.removeAll();
                    toolBarManager.dispose();
                }
            }
            this.paletteToolBarManagers.clear();
            this.paletteToolBarManagers = null;
        }
        if (showPaletteItems) {
            if (this.isShowStandardLabel()) {
                int cols = ((PaletteContents)input).getPreferredColumns();
                List<PaletteItem> items = Arrays.asList(newItems);
                List<PaletteItem> genItems = items.subList(0, items.size() - cols);
                last = this.showPalette(input, genItems.toArray(new PaletteItem[genItems.size()]), paletteChanged, parent, last);
                if (this.sep2 == null || this.sep2.isDisposed()) {
                    this.sep2 = this.createSeparator(parent);
                }
                last = this.moveControl(this.sep2, last);
                if (this.standard == null || this.standard.isDisposed()) {
                    this.standard = new Label(parent, 0);
                    this.standard.setText(PaletteMessages.PaletteItem_Standard_label);
                    GridData labelLayout = new GridData(768);
                    labelLayout.horizontalIndent = 7;
                    labelLayout.verticalIndent = 5;
                    this.standard.setLayoutData((Object)labelLayout);
                }
                last = this.moveControl((Control)this.standard, last);
                List<PaletteItem> staItems = items.subList(items.size() - cols, items.size());
                last = this.showPalette(input, staItems.toArray(new PaletteItem[staItems.size()]), paletteChanged, parent, last);
            } else {
                List<PaletteItem> items = Arrays.asList(newItems);
                last = this.showPalette(input, items.toArray(new PaletteItem[items.size()]), paletteChanged, parent, last);
            }
        }
        if (showCustomItem) {
            if (showAutoItem || showPaletteItems || showNoneItem) {
                if (this.sep3 == null || this.sep3.isDisposed()) {
                    this.sep3 = this.createSeparator(parent);
                }
                last = this.moveControl(this.sep3, last);
            }
            if (showNoneItem) {
                Composite moreAndNone = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginLeft = 0;
                layout.horizontalSpacing = 2;
                moreAndNone.setLayout((Layout)layout);
                last = this.showItemBar(this.noneToolBar, moreAndNone, last);
                last = this.showItemBar(this.customToolBar, moreAndNone, last);
            } else {
                last = this.showItemBar(this.customToolBar, parent, last);
            }
        }
        this.selection = this.findActionToSelect(selType, selColor);
        parent.layout();
    }

    private Control showPalette(Object newInput, PaletteItem[] newItems, boolean paletteChanged, final Composite parent, Control currentControl) {
        GridData layoutData;
        ToolBar tb;
        int i;
        Composite paletteContainer = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = ((PaletteContents)newInput).getPreferredColumns();
        containerLayout.verticalSpacing = 0;
        containerLayout.horizontalSpacing = 0;
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 5;
        paletteContainer.setLayout((Layout)containerLayout);
        if (this.paletteToolBarManagers == null) {
            this.paletteToolBarManagers = new ArrayList<ToolBarManager>();
            paletteChanged = true;
        }
        if (this.paletteActions == null) {
            this.paletteActions = new ArrayList<PaletteItemAction>();
            paletteChanged = true;
        }
        if (paletteChanged) {
            i = 0;
            while (i < newItems.length) {
                PaletteItemAction action = new PaletteItemAction(newItems[i]);
                tb = new ToolBar(paletteContainer, 0x820000);
                layoutData = new GridData(768);
                if (newItems.length == 70 - containerLayout.numColumns && this.hasVerticalIndent() && i >= containerLayout.numColumns && i < containerLayout.numColumns * 2) {
                    layoutData.verticalIndent = 10;
                }
                tb.setLayoutData((Object)layoutData);
                ToolBarManager toolBar = new ToolBarManager(tb);
                toolBar.add((IAction)action);
                tb.addMouseTrackListener(new MouseTrackListener(){

                    public void mouseHover(MouseEvent e) {
                    }

                    public void mouseExit(MouseEvent e) {
                        tb.setBackground(parent.getBackground());
                    }

                    public void mouseEnter(MouseEvent e) {
                        tb.setBackground(parent.getDisplay().getSystemColor(3));
                    }
                });
                tb.addMouseMoveListener(new MouseMoveListener(){

                    public void mouseMove(MouseEvent e) {
                    }
                });
                this.paletteToolBarManagers.add(toolBar);
                this.paletteActions.add(action);
                ++i;
            }
        }
        i = 0;
        while (i < this.paletteToolBarManagers.size()) {
            ToolBarManager toolBar = this.paletteToolBarManagers.get(i);
            if (toolBar != null) {
                tb = toolBar.getControl();
                if (tb == null) {
                    tb = toolBar.createControl(paletteContainer);
                    layoutData = new GridData(768);
                    if (newItems.length == 70 - containerLayout.numColumns && this.hasVerticalIndent() && i >= containerLayout.numColumns && i < containerLayout.numColumns * 2) {
                        layoutData.verticalIndent = 10;
                    }
                    tb.setLayoutData((Object)layoutData);
                } else {
                    this.updatePaletteToolBar(toolBar);
                }
            }
            ++i;
        }
        this.moveControl((Control)paletteContainer, currentControl);
        return paletteContainer;
    }

    private void updatePaletteToolBar(ToolBarManager toolBarManager) {
        ToolBar toolBar = toolBarManager.getControl();
        IContributionItem item = toolBarManager.getItems()[0];
        ToolItem[] mi = toolBar.getItems();
        if (mi.length <= 0 || mi[0].getData() != item) {
            int i = 0;
            while (i < mi.length) {
                mi[i].dispose();
                ++i;
            }
            item.fill(toolBar, 0);
        }
    }

    private Control showItemBar(ToolBarManager tbm, Composite parent, Control last) {
        if (tbm != null) {
            ToolBar tb = tbm.getControl();
            if (tb == null || tb.isDisposed()) {
                tb = tbm.createControl(parent);
                tb.setLayoutData((Object)new GridData(1, 4, true, false));
                this.moveControl((Control)tb, last);
            } else {
                tbm.update(true);
            }
            return tb;
        }
        return last;
    }

    protected Control createSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(768));
        return label;
    }

    private ToolBarManager createItemBar() {
        return new ToolBarManager(0x820000);
    }

    private PaletteItemAction createItemAction(int type, String text, RGB initColor, ToolBarManager parent) {
        PaletteItemAction action = new PaletteItemAction(type, text);
        action.setColor(initColor);
        ActionContributionItem ci = new ActionContributionItem((IAction)action);
        ci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        parent.add((IContributionItem)ci);
        return action;
    }

    private Control moveControl(Control c, Control last) {
        if (c != null) {
            if (last != null) {
                c.moveBelow(last);
            } else {
                c.moveAbove(null);
            }
            return c;
        }
        return last;
    }

    protected PaletteItemAction findActionToSelect(int type, RGB color) {
        if (this.autoAction != null && type == this.autoAction.getType()) {
            return this.autoAction;
        }
        if (this.noneAction != null && type == this.noneAction.getType()) {
            return this.noneAction;
        }
        if (type == 3) {
            if (this.paletteActions != null) {
                for (PaletteItemAction a : this.paletteActions) {
                    if (!PaletteViewer.equals(color, a.getColor())) continue;
                    return a;
                }
            }
            if (this.customAction != null && PaletteViewer.equals(color, this.customAction.getColor())) {
                return this.customAction;
            }
        }
        return null;
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        PaletteItemAction oldSelection = this.selection;
        if (selection == null || selection.isEmpty() || !(selection instanceof IColorSelection)) {
            this.selectAction(null);
            if (oldSelection != null) {
                this.fireColorSelectionChanged();
            }
            return;
        }
        IColorSelection colorSelection = (IColorSelection)selection;
        this.setSelection(colorSelection.getType(), colorSelection.getColor());
    }

    protected void setSelection(int type, RGB color) {
        RGB oldCustomColor;
        PaletteItemAction oldSelection = this.selection;
        PaletteItemAction newSelection = this.findActionToSelect(type, color);
        if (newSelection == null && type == 3 && this.customAction != null && !PaletteViewer.equals(color, oldCustomColor = this.customAction.getColor())) {
            this.customAction.setColor(color);
            this.selectAction(this.customAction);
            this.fireColorSelectionChanged();
            return;
        }
        this.selectAction(newSelection);
        if (newSelection != oldSelection) {
            this.fireColorSelectionChanged();
        }
    }

    protected void fireColorSelectionChanged() {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    protected void selectAction(PaletteItemAction action) {
        if (action != null) {
            action.setChecked(true);
        }
        if (action == this.selection) {
            return;
        }
        this.selection = action;
        if (this.autoAction != null && this.autoAction != action) {
            this.autoAction.setChecked(false);
        }
        if (this.noneAction != null && this.noneAction != action) {
            this.noneAction.setChecked(false);
        }
        if (this.customAction != null && this.customAction != action) {
            this.customAction.setChecked(false);
        }
        if (this.paletteActions != null) {
            for (PaletteItemAction a : this.paletteActions) {
                if (a == action) continue;
                a.setChecked(false);
            }
        }
    }

    public Object getInput() {
        return this.getContents();
    }

    public void setInput(Object input) {
        if (!(input instanceof PaletteContents)) {
            input = null;
        }
        this.setContents((PaletteContents)input);
    }

    public void addOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<IOpenListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    protected void fireOpenEvent(final OpenEvent event) {
        if (this.openListeners == null) {
            return;
        }
        Object[] objectArray = this.openListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IOpenListener)l).open(event);
                }
            });
            ++n2;
        }
    }

    protected void actionSelected(PaletteItemAction action) {
        if (action == this.customAction) {
            RGB newColor;
            RGB oldColor = action.getColor();
            Shell shell = this.getControl().getShell();
            if (shell != null && !shell.isDisposed() && (newColor = this.openNativeColorDialog(shell, oldColor)) != null) {
                this.setSelection(action.getType(), newColor);
                action.setColor(newColor);
            }
        } else {
            this.setSelection(action.getType(), action.getColor());
        }
        this.fireOpenEvent(new OpenEvent((Viewer)this, this.getSelection()));
    }

    protected RGB openNativeColorDialog(Shell shell, RGB oldColor) {
        ColorDialog dialog = new ColorDialog(shell, 0);
        dialog.setRGB(oldColor);
        return dialog.open();
    }

    protected final class PaletteItemAction
    extends ColorAction {
        private static final int DEFAULT_WIDTH = 16;
        private static final int DEFAULT_HEIGHT = 16;
        private int type;

        public PaletteItemAction(int type, String text) {
            super(null, 2);
            this.type = type;
            this.setText(text);
        }

        public PaletteItemAction(PaletteItem item) {
            super(item.color, 2);
            this.type = 3;
            this.setToolTipText(item.description);
        }

        public int getType() {
            return this.type;
        }

        @Override
        public void setColor(RGB color) {
            super.setColor(color);
            if (this.getText() == PaletteMessages.PaletteViewer_MoreColors) {
                this.setImageDescriptor(new ImageDescriptor(){

                    public ImageData getImageData() {
                        Display display = Display.getCurrent();
                        Image image = new Image((Device)display, 16, 16);
                        GC gc = new GC((Drawable)image);
                        gc.setLineWidth(1);
                        gc.setLineStyle(1);
                        gc.setAntialias(1);
                        int standardRadius = 8;
                        float brightness = 1.0f;
                        int index = standardRadius;
                        while (index > 1) {
                            PaletteItemAction.this.drawCycle(gc, index, brightness);
                            --index;
                        }
                        gc.dispose();
                        ImageData imageData = image.getImageData();
                        image.dispose();
                        return imageData;
                    }
                });
            }
        }

        private void drawCycle(GC graphics, int radius, float brightness) {
            int standardRadius = 8;
            int delta = standardRadius - radius;
            float saturation = 1.0f - (float)delta * 1.0f / (float)standardRadius;
            Color color = null;
            int index = 0;
            while (index < 360) {
                color = new Color(null, new RGB((float)index, saturation, brightness));
                graphics.setBackground(color);
                graphics.fillArc(delta, delta, radius * 2, radius * 2, index, 1);
                color.dispose();
                ++index;
            }
        }

        public void run() {
            super.run();
            PaletteViewer.this.actionSelected(this);
        }
    }
}

