/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xmind.core.io.BundleResource;
import org.xmind.core.io.IInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResourceInputSource
implements IInputSource {
    private BundleResource base;

    public BundleResourceInputSource(BundleResource baseResource) {
        Assert.isNotNull((Object)baseResource);
        BundleResource resolved = baseResource.resolve();
        this.base = resolved == null ? baseResource : resolved;
    }

    public BundleResourceInputSource(String pluginId, String basePath) {
        this(new BundleResource(Platform.getBundle((String)pluginId), (IPath)new Path(basePath)));
    }

    public BundleResourceInputSource(Bundle bundle, String basePath) {
        this(new BundleResource(bundle, (IPath)new Path(basePath)));
    }

    private URL getEntry(String entryName) {
        BundleResource entryResource = new BundleResource(this.base.getBundle(), this.base.getPath().append(entryName)).resolve();
        if (entryResource == null) {
            return null;
        }
        return entryResource.toPlatformURL();
    }

    public boolean hasEntry(String entryName) {
        return this.getEntry(entryName) != null;
    }

    public Iterator<String> getEntries() {
        String basePath = this.base.getPath().toString();
        final String prefix = basePath.startsWith("/") ? basePath.substring(1) : basePath;
        final Stack<Enumeration> pathStack = new Stack<Enumeration>();
        pathStack.push(this.base.getBundle().getEntryPaths(basePath));
        return new Iterator<String>(){
            private String nextPath = this.findNextPath();

            private String findNextPath() {
                if (pathStack.isEmpty()) {
                    return null;
                }
                Enumeration paths = (Enumeration)pathStack.peek();
                if (!paths.hasMoreElements()) {
                    pathStack.pop();
                    return this.findNextPath();
                }
                String path = (String)paths.nextElement();
                if (path.endsWith("/")) {
                    pathStack.push(BundleResourceInputSource.this.base.getBundle().getEntryPaths(path));
                    return this.findNextPath();
                }
                if (path.startsWith(prefix)) {
                    return path.substring(prefix.length());
                }
                return this.findNextPath();
            }

            @Override
            public void remove() {
            }

            @Override
            public String next() {
                String p = this.nextPath;
                this.nextPath = this.findNextPath();
                return p;
            }

            @Override
            public boolean hasNext() {
                return this.nextPath != null;
            }
        };
    }

    public boolean isEntryAvailable(String entryName) {
        return this.getEntry(entryName) != null;
    }

    public InputStream getEntryStream(String entryName) {
        try {
            return this.openEntryStream(entryName);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream openEntryStream(String entryName) throws IOException {
        URL entry = this.getEntry(entryName);
        if (entry == null) {
            throw new FileNotFoundException();
        }
        return entry.openStream();
    }

    public long getEntrySize(String entryName) {
        URLConnection conn;
        URL entry = this.getEntry(entryName);
        if (entry == null) {
            return 0L;
        }
        try {
            conn = entry.openConnection();
        }
        catch (IOException iOException) {
            return 0L;
        }
        return conn.getContentLength();
    }

    public long getEntryTime(String entryName) {
        URLConnection conn;
        URL entry = this.getEntry(entryName);
        if (entry == null) {
            return 0L;
        }
        try {
            conn = entry.openConnection();
        }
        catch (IOException iOException) {
            return 0L;
        }
        return conn.getLastModified();
    }
}

