/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.ITopic;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.MindMapMessages;

public class DeleteNotesCommand
extends SourceCommand {
    private ITopic topic;
    private INotesContent htmlContent;
    private INotesContent plainContent;

    public DeleteNotesCommand(ITopic topic) {
        super((Object)topic);
        this.topic = topic;
        this.setLabel(MindMapMessages.DeleteNotes_label);
    }

    public void redo() {
        if (this.topic == null) {
            return;
        }
        INotes notes = this.topic.getNotes();
        if (this.htmlContent == null && this.plainContent == null) {
            this.htmlContent = notes.getContent("html");
            this.plainContent = notes.getContent("plain");
        }
        notes.setContent("html", null);
        notes.setContent("plain", null);
        super.redo();
    }

    public void undo() {
        INotes notes = this.topic.getNotes();
        notes.setContent("plain", this.plainContent);
        notes.setContent("html", this.htmlContent);
        super.undo();
    }
}

