/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.ITopic;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.branch.IBranchPolicyDescriptor;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTopicStructureCommand;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class StructureMenuDynamic
extends ContributionItem
implements IWorkbenchContribution {
    private IGraphicalEditorPage page;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            StructureMenuDynamic.this.dirty = true;
        }
    };

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.page == null) {
            return;
        }
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    private void fillMenu(IMenuManager menu) {
        List<IBranchPolicyDescriptor> descriptors = this.getCurrentStructures();
        if (descriptors == null) {
            return;
        }
        for (IBranchPolicyDescriptor descriptor : descriptors) {
            this.addStructureAction(descriptor, menu);
        }
    }

    private void addStructureAction(IBranchPolicyDescriptor descriptor, IMenuManager menu) {
        menu.add((IAction)new StructureAction(descriptor));
    }

    private List<IBranchPolicyDescriptor> getCurrentStructures() {
        ISelection selection;
        if (this.page == null) {
            return null;
        }
        ArrayList<IBranchPolicyDescriptor> list = null;
        IGraphicalViewer viewer = this.page.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchPart branch;
                Object o = objectArray[n2];
                if (o instanceof ITopic && (branch = MindMapUtils.findBranch(viewer.findPart(o))) != null) {
                    List<IBranchPolicyDescriptor> applicables = MindMapUI.getBranchPolicyManager().getApplicableBranchPolicyDescriptors(branch);
                    if (applicables.isEmpty()) {
                        return null;
                    }
                    if (list == null) {
                        list = new ArrayList<IBranchPolicyDescriptor>(applicables);
                    } else {
                        list.retainAll(applicables);
                    }
                    if (list.isEmpty()) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return list;
    }

    public void initialize(IServiceLocator serviceLocator) {
        IWorkbenchWindow window = (IWorkbenchWindow)serviceLocator.getService(IWorkbenchWindow.class);
        if (window == null) {
            return;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (editor instanceof IGraphicalEditor) {
            this.page = ((IGraphicalEditor)editor).getActivePageInstance();
        }
    }

    private class StructureAction
    extends Action {
        private IBranchPolicyDescriptor descriptor;

        public StructureAction(IBranchPolicyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.setId("#" + descriptor.getId());
            this.setText(descriptor.getName());
            this.setImageDescriptor(descriptor.getIcon());
        }

        public void run() {
            if (StructureMenuDynamic.this.page == null) {
                return;
            }
            this.changeStructureClass(this.descriptor.getId());
        }

        private void changeStructureClass(String newStructureClass) {
            EditDomain domain = StructureMenuDynamic.this.page.getEditDomain();
            if (domain == null) {
                return;
            }
            ICommandStack commandStack = domain.getCommandStack();
            if (commandStack == null) {
                return;
            }
            List<ITopic> topics = this.getTopics();
            if (topics != null && !topics.isEmpty()) {
                ModifyTopicStructureCommand command = new ModifyTopicStructureCommand(topics, newStructureClass);
                command.setLabel(CommandMessages.Command_ModifyTopicStructure);
                commandStack.execute((Command)command);
            }
        }

        private List<ITopic> getTopics() {
            ISelection selection = StructureMenuDynamic.this.page.getViewer().getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return null;
            }
            Object[] elements = ((IStructuredSelection)selection).toArray();
            ArrayList<ITopic> list = new ArrayList<ITopic>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof ITopic && !list.contains(o)) {
                    list.add((ITopic)o);
                }
                ++n2;
            }
            return list;
        }
    }
}

