/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchPropertyTester;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.MindMapUtils;

public class BranchPartPropertyTester
extends PropertyTester {
    private static final String P_TYPE = "type";
    private static final String P_FOLDED = "folded";
    private static final String P_INDEX = "index";
    private static final String P_POLICY_ID = "policyId";
    private static final String P_STRUCTURE_ID = "structureId";
    private static final String P_HAS_PARENT = "hasParent";
    private static final String P_PREFERRED_POSITION = "preferredPosition";
    private static final String P_PROPERTY = "property";
    private static final String ARG_EAST_OF = "eastOf";
    private static final String ARG_WEST_OF = "westOf";
    private static final String ARG_NORTH_OF = "northOf";
    private static final String ARG_SOUTH_OF = "southOf";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IBranchPart) {
            IBranchPart branch = (IBranchPart)receiver;
            if (P_TYPE.equals(property)) {
                if (expectedValue == null) {
                    return false;
                }
                if (expectedValue instanceof String) {
                    return expectedValue.equals(branch.getBranchType());
                }
            } else if (P_FOLDED.equals(property)) {
                if (expectedValue == null) {
                    return branch.isFolded();
                }
                if (expectedValue instanceof Boolean) {
                    return branch.isFolded() == ((Boolean)expectedValue).booleanValue();
                }
            } else if (P_INDEX.equals(property)) {
                if (expectedValue == null) {
                    return false;
                }
                if (expectedValue instanceof Integer) {
                    return branch.getBranchIndex() == ((Integer)expectedValue).intValue();
                }
            } else if (P_POLICY_ID.equals(property)) {
                if (expectedValue == null) {
                    return false;
                }
                if (expectedValue instanceof String) {
                    return expectedValue.equals(branch.getBranchPolicyId());
                }
            } else if (P_STRUCTURE_ID.equals(property)) {
                if (expectedValue == null || expectedValue instanceof String) {
                    return this.isStructureAlgorithmId(branch, args, (String)expectedValue);
                }
            } else if (P_HAS_PARENT.equals(property)) {
                if (expectedValue == null) {
                    return this.hasParent(branch);
                }
                if (expectedValue instanceof Boolean) {
                    return this.hasParent(branch) == ((Boolean)expectedValue).booleanValue();
                }
            } else if (P_PREFERRED_POSITION.equals(property)) {
                if (expectedValue == null || expectedValue instanceof String) {
                    return this.isPreferredPosition(branch, args, (String)expectedValue);
                }
            } else if (P_PROPERTY.equals(property)) {
                if (args.length == 0 || args[0] == null) {
                    return false;
                }
                String p = args[0].toString();
                Object[] newArgs = new Object[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                return this.testSpecifiedProperty(branch, p, newArgs, expectedValue);
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private boolean isStructureAlgorithmId(IBranchPart branch, Object[] args, String expectedValue) {
        String id = (String)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.branchCache.structureId");
        if (id == null) {
            return expectedValue != null;
        }
        return id.equals(expectedValue);
    }

    private boolean testSpecifiedProperty(IBranchPart branch, String property, Object[] args, Object expectedValue) {
        IBranchPropertyTester tester = (IBranchPropertyTester)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.branchCache.propertyTester");
        if (tester != null) {
            return tester.test(branch, property, args, expectedValue);
        }
        return expectedValue == null;
    }

    private boolean isPreferredPosition(IBranchPart branch, Object[] args, String expectedValue) {
        Object arg;
        Point expPos = this.toPoint(expectedValue);
        Point prefPos = (Point)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.cache.preferredPosition");
        if (args.length > 0 && (arg = args[0]) instanceof String) {
            int y2;
            String direction = (String)arg;
            int x1 = prefPos == null ? 0 : prefPos.x;
            int x2 = expPos == null ? 0 : expPos.x;
            int y1 = prefPos == null ? 0 : prefPos.y;
            int n = y2 = expPos == null ? 0 : expPos.y;
            if (ARG_EAST_OF.equals(direction)) {
                return x1 > x2;
            }
            if (ARG_WEST_OF.equals(direction)) {
                return x1 < x2;
            }
            if (ARG_NORTH_OF.equals(direction)) {
                return y1 < y2;
            }
            if (ARG_SOUTH_OF.equals(direction)) {
                return y1 > y2;
            }
        }
        if (prefPos == null) {
            return expPos == null;
        }
        if (expPos == null) {
            return false;
        }
        return prefPos.equals((Object)expPos);
    }

    private Point toPoint(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] sp = string.split(",");
        if (sp.length == 0) {
            return null;
        }
        Point p = new Point();
        String x = sp[0];
        try {
            p.x = Integer.parseInt(x);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (sp.length > 1) {
            String y = sp[1];
            try {
                p.y = Integer.parseInt(y);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return p;
    }

    private boolean hasParent(IBranchPart branch) {
        return branch.getParentBranch() != null;
    }
}

