/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.IPageSite;
import org.xmind.core.style.IStyled;
import org.xmind.gef.command.Command;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.properties.GraphicalPropertySheetPage;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyStyleCommand;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.properties.PropertySectionContributorManager;
import org.xmind.ui.mindmap.ICategoryAnalyzation;
import org.xmind.ui.mindmap.ICategoryManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;

public class MindMapPropertySheetPage
extends GraphicalPropertySheetPage {
    private static PropertySectionContributorManager manager = PropertySectionContributorManager.getInstance();
    private Hyperlink resetStyleControl;

    public MindMapPropertySheetPage(IGraphicalEditor editor) {
        super(editor);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IActionBars targetActionBars = pageSite.getActionBars();
        IActionBars sourceActionBars = this.getContributedEditor().getEditorSite().getActionBars();
        this.retargetAction(sourceActionBars, targetActionBars, ActionFactory.UNDO.getId());
        this.retargetAction(sourceActionBars, targetActionBars, ActionFactory.REDO.getId());
    }

    private void retargetAction(IActionBars sourceActionBars, IActionBars targetActionBars, String actionId) {
        IAction handler = sourceActionBars.getGlobalActionHandler(actionId);
        if (handler != null) {
            targetActionBars.setGlobalActionHandler(actionId, handler);
        }
    }

    protected void createExtendSectionControls(WidgetFactory widgetFactory, Composite parent) {
        super.createExtendSectionControls(widgetFactory, parent);
        this.createResetStyleControl(widgetFactory, parent);
    }

    private void createResetStyleControl(WidgetFactory widgetFactory, Composite parent) {
        this.resetStyleControl = widgetFactory.createHyperlink(parent, MindMapMessages.MindMapPropertySheetPage_ResetStyle_text, 0);
        this.resetStyleControl.setUnderlined(false);
        this.resetStyleControl.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.resetStyleControl.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
                MindMapPropertySheetPage.this.resetStyleControl.setUnderlined(false);
            }

            public void linkEntered(HyperlinkEvent e) {
                MindMapPropertySheetPage.this.resetStyleControl.setUnderlined(true);
            }

            public void linkActivated(HyperlinkEvent e) {
                MindMapPropertySheetPage.this.resetStyles();
            }
        });
        this.resetStyleControl.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        this.resetStyleControl.setForeground(parent.getDisplay().getSystemColor(9));
    }

    private boolean shouldHasResetStyleControl(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return false;
        }
        boolean result = true;
        Object[] resetedStyleds = ((StructuredSelection)selection).toArray();
        if (resetedStyleds != null) {
            Object[] objectArray = resetedStyleds;
            int n = resetedStyleds.length;
            int n2 = 0;
            while (n2 < n) {
                Object styled = objectArray[n2];
                if (!(styled instanceof IStyled)) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    protected void resetStyles() {
        IGraphicalEditor editor = this.getContributedEditor();
        if (editor == null) {
            return;
        }
        IGraphicalEditorPage activePageInstance = editor.getActivePageInstance();
        if (activePageInstance == null) {
            return;
        }
        ISelectionProvider selectionProvider = activePageInstance.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object[] resetedStyleds = ((StructuredSelection)selection).toArray();
        if (resetedStyleds != null) {
            Object[] objectArray = resetedStyleds;
            int n = resetedStyleds.length;
            int n2 = 0;
            while (n2 < n) {
                Object styled = objectArray[n2];
                if (styled instanceof IStyled) {
                    IStyled resetedStyled = (IStyled)styled;
                    ModifyStyleCommand modifyStyleCommand = new ModifyStyleCommand(resetedStyled, null);
                    modifyStyleCommand.setLabel(CommandMessages.Command_ModifyStyle);
                    editor.getCommandStack().execute((Command)modifyStyleCommand);
                }
                ++n2;
            }
        }
    }

    protected void selectionChanged(ISelection selection) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(false);
        }
        if (this.resetStyleControl != null && !this.resetStyleControl.isDisposed()) {
            boolean resetStyleControlVisible = this.shouldHasResetStyleControl(selection);
            GridData gd = (GridData)this.resetStyleControl.getLayoutData();
            gd.exclude = !resetStyleControlVisible;
            this.resetStyleControl.setVisible(resetStyleControlVisible);
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List<String> newVisibleSectionIds = manager.getApplicableSectionIds(ss.toArray());
            List oldVisibleSectionIds = this.getVisibleSectionIds();
            if (!MindMapPropertySheetPage.equalsList(oldVisibleSectionIds, newVisibleSectionIds)) {
                List oldSectionIds = this.getSectionIds();
                ArrayList<String> toAdd = new ArrayList<String>(newVisibleSectionIds);
                toAdd.removeAll(oldSectionIds);
                for (String id : toAdd) {
                    this.addSection(id, newVisibleSectionIds, oldSectionIds);
                    oldSectionIds = this.getSectionIds();
                }
                ArrayList toHide = new ArrayList(oldSectionIds);
                toHide.removeAll(newVisibleSectionIds);
                Iterator iterator = oldSectionIds.iterator();
                while (iterator.hasNext()) {
                    String id;
                    this.setSectionVisible(id, !toHide.contains(id = (String)iterator.next()));
                }
                this.reflow();
            }
            this.setTitle(this.calcTitle(ss.toArray()));
        } else {
            this.setTitle(null);
        }
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(true);
        }
    }

    private void addSection(String id, List<String> newVisibleSectionIds, List<String> oldSectionIds) {
        this.addSection(id, manager.createSection(id));
        String aboveId = this.findAboveId(id, oldSectionIds, newVisibleSectionIds);
        this.moveSectionAfter(id, aboveId);
    }

    private String findAboveId(String id, List<String> oldSectionIds, List<String> newSectionIds) {
        int index = newSectionIds.indexOf(id);
        int i = index - 1;
        while (i >= 0) {
            String aboveId = newSectionIds.get(i);
            if (oldSectionIds.contains(aboveId)) {
                return aboveId;
            }
            --i;
        }
        return null;
    }

    private static boolean equalsList(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            String s2;
            String s1 = list1.get(i);
            if (!s1.equals(s2 = list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String calcTitle(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        String category = this.getCategoryName(objects);
        return category;
    }

    private String getCategoryName(Object[] objects) {
        ICategoryManager typeManager = MindMapUI.getCategoryManager();
        ICategoryAnalyzation result = typeManager.analyze(objects);
        return typeManager.getCategoryName(result.getMainCategory());
    }
}

