/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import net.xmind.verify.ui.AbstractProViewPart20141031;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicComponent;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGlobalActionHandlerService;
import org.xmind.ui.internal.taskinfo.TaskInfoViewer;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.util.MindMapUtils;

public class TaskInfoView
extends AbstractProViewPart20141031
implements IPartListener,
IContributedContentsView,
ISelectionChangedListener,
ISelectionListener {
    private TaskInfoViewer viewer;
    private IEditorPart targetEditor;
    private IGlobalActionHandlerService targetActionService;
    private boolean changingViewerInput = false;
    private boolean changingEditorSelection = false;
    private ITopic topic;

    protected int getRequiredFeatures() {
        return 3;
    }

    protected String getFeatureKey() {
        return "TaskInfoView";
    }

    protected void doCreatePartControl(Composite composite) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        this.viewer = new TaskInfoViewer();
        this.viewer.addTaskChangedListener(new Runnable(){

            public void run() {
                if (TaskInfoView.this.changingViewerInput) {
                    return;
                }
                TaskInfoView.this.setTaskSelectionToEditor(TaskInfoView.this.viewer.getTask());
            }
        });
        this.viewer.createControl(composite);
        this.setTargetEditor(activeEditor);
        this.setInitialInputFromView();
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void setInitialInputFromView() {
        ISelectionProvider provider;
        Object obj;
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor != null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MPart part = E4Utils.findPart((IWorkbenchWindow)window, (String)"org.xmind.ui.dialogPart.gantt");
        if (part != null && (obj = part.getObject()) instanceof IAdaptable && (provider = (ISelectionProvider)((IAdaptable)obj).getAdapter(ISelectionProvider.class)) != null) {
            this.refreshViewer(provider.getSelection());
        }
    }

    public void dispose() {
        this.setTargetEditor(null);
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.viewer = null;
        super.dispose();
    }

    public void doSetFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void partActivated(IWorkbenchPart part) {
        if (!(part instanceof IEditorPart)) {
            return;
        }
        this.setTargetEditor((IEditorPart)part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.targetEditor) {
            this.setTargetEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part == this) {
            VerifyUI20141031.getUsageDataCollector().increase("ShowTaskInfoCount");
        }
    }

    private void setTargetEditor(IEditorPart editor) {
        ISelectionProvider selectionProvider;
        ISelectionProvider selectionProvider2;
        if (editor == this.targetEditor) {
            return;
        }
        if (this.targetActionService != null) {
            this.targetActionService.removeActionBars(this.getViewSite().getActionBars());
        }
        if (this.targetEditor != null && (selectionProvider2 = this.targetEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider2.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.targetEditor = editor;
        this.targetActionService = editor == null ? null : (IGlobalActionHandlerService)editor.getAdapter(IGlobalActionHandlerService.class);
        StructuredSelection newSelection = null;
        if (editor != null && (selectionProvider = editor.getSite().getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            newSelection = selectionProvider.getSelection();
        }
        if (newSelection == null) {
            newSelection = StructuredSelection.EMPTY;
        }
        this.refreshViewer((ISelection)newSelection);
        if (this.targetActionService != null) {
            this.targetActionService.addActionBars(this.getViewSite().getActionBars());
        }
    }

    private ITopic findLastTopic(ISelection selection) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        ITopicComponent topicComponent = null;
        Object[] objs = ((IStructuredSelection)selection).toArray();
        if (objs == null) {
            return null;
        }
        int i = objs.length - 1;
        while (i >= 0) {
            Object o = objs[i];
            if (o instanceof ITopic) {
                return (ITopic)o;
            }
            if (o instanceof ITopicComponent && topicComponent == null) {
                topicComponent = (ITopicComponent)o;
            }
            --i;
        }
        if (topicComponent != null) {
            return topicComponent.getParent();
        }
        return null;
    }

    private ICommandStack findCommandStack(IWorkbenchPart part) {
        return part == null ? null : (ICommandStack)part.getAdapter(ICommandStack.class);
    }

    public IWorkbenchPart getContributingPart() {
        return this.targetEditor;
    }

    private void refreshViewer(ISelection selection) {
        ITopic topic;
        if (this.viewer != null && (topic = this.findLastTopic(selection)) != this.topic) {
            this.topic = topic;
            this.setTaskInputToViewer(topic);
            this.viewer.setCommandStack(this.findCommandStack(topic));
        }
    }

    private ICommandStack findCommandStack(ITopic topic) {
        ICommandStack cs = this.findCommandStack((IWorkbenchPart)this.targetEditor);
        if (cs == null && topic != null) {
            cs = MindMapUtils.getCommandStack((IWorkbook)topic.getOwnedWorkbook());
        }
        return cs;
    }

    private void setTaskInputToViewer(ITopic task) {
        this.changingViewerInput = true;
        this.viewer.setTask(task);
        this.changingViewerInput = false;
    }

    private void setTaskSelectionToEditor(ITopic task) {
        ISelectionProvider selectionProvider;
        if (this.targetEditor != null && (selectionProvider = this.targetEditor.getSite().getSelectionProvider()) != null) {
            this.changingEditorSelection = true;
            selectionProvider.setSelection((ISelection)new StructuredSelection((Object)task));
            this.changingEditorSelection = false;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.changingEditorSelection) {
            return;
        }
        this.refreshViewer(event.getSelection());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor != null) {
            return;
        }
        if (part.getSite().getId().equals("org.xmind.ui.dialogPart.gantt")) {
            this.refreshViewer(selection);
        }
    }
}

