/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.Relationship;
import org.xmind.core.util.Point;

public class ControlPoint
implements IControlPoint,
ICoreEventSource {
    private final Relationship parent;
    private final int index;
    private Point position;
    private Double polarAngle;
    private Double polarAmount;

    public ControlPoint(Relationship relationship, int index) {
        this.parent = relationship;
        this.index = index;
        this.position = null;
        this.polarAngle = null;
        this.polarAmount = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IRelationship.class.equals(adapter)) {
            return adapter.cast(this.parent);
        }
        return this.parent.getAdapter(adapter);
    }

    public ISheet getOwnedSheet() {
        return this.parent.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.parent.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.parent.isOrphan();
    }

    private Point copyPosition(Point p) {
        return p == null ? null : new Point(p.x, p.y);
    }

    public void setPosition(int x, int y) {
        Point newPosition = new Point(x, y);
        Point oldPosition = this.copyPosition(this.position);
        if (newPosition.equals((Object)oldPosition)) {
            return;
        }
        this.position = this.copyPosition(newPosition);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "position", (Object)oldPosition, (Object)newPosition);
    }

    public Point getPosition() {
        return this.copyPosition(this.position);
    }

    public void setPosition(Point position) {
        Point oldPosition = this.copyPosition(this.position);
        Point newPosition = this.copyPosition(position);
        if (newPosition == oldPosition || newPosition != null && newPosition.equals((Object)oldPosition)) {
            return;
        }
        this.position = this.copyPosition(newPosition);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "position", (Object)oldPosition, (Object)newPosition);
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public IRelationship getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean usesPolarPosition() {
        return this.polarAngle != null && this.polarAmount != null;
    }

    public boolean hasPolarAngle() {
        return this.polarAngle != null;
    }

    public boolean hasPolarAmount() {
        return this.polarAmount != null;
    }

    public double getPolarAngle() {
        return this.polarAngle == null ? 0.0 : this.polarAngle;
    }

    public double getPolarAmount() {
        return this.polarAmount == null ? 0.0 : this.polarAmount;
    }

    public void setPolarAngle(double angle) {
        this.doSetPolarAngle(angle);
    }

    public void setPolarAmount(double amount) {
        this.doSetPolarAmount(amount);
    }

    public void resetPolarAngle() {
        this.doSetPolarAngle(null);
    }

    public void resetPolarAmount() {
        this.doSetPolarAmount(null);
    }

    private void doSetPolarAngle(Double angle) {
        Double oldAngle = this.polarAngle;
        if (angle == oldAngle || angle != null && angle.equals(oldAngle)) {
            return;
        }
        this.polarAngle = angle;
    }

    private void doSetPolarAmount(Double amount) {
        Double oldAmount = this.polarAmount;
        if (amount == oldAmount || amount != null && amount.equals(oldAmount)) {
            return;
        }
        this.polarAmount = amount;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.parent.getCoreEventSupport();
    }
}

