/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IResourceRef;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.ObjectRefManager;
import org.xmind.seawind.internal.core.PathInfo;

public class ExtensionsSerializer {
    private final IWorkbookExtensionManager extensionManager;
    private final IStorage resourceStorage;
    private Map<String, String> resourceIdMap = new HashMap<String, String>();

    public ExtensionsSerializer(IWorkbookExtensionManager extensionManager, IStorage resourceStorage) {
        this.extensionManager = extensionManager;
        this.resourceStorage = resourceStorage;
    }

    public JSONObject serialize() throws IOException {
        ObjectRefManager refManager = (ObjectRefManager)this.extensionManager.getOwnedWorkbook().getAdapter(ObjectRefManager.class);
        Assert.isNotNull((Object)refManager);
        JSONArray extensionArray = new JSONArray();
        for (IWorkbookExtension ext : this.extensionManager.getExtensions()) {
            JSONObject extObject = new JSONObject().put("provider", (Object)ext.getProviderName());
            JSONArray resourceRefArray = new JSONArray();
            for (IResourceRef ref : ext.getResourceRefs()) {
                if (!"file-entry".equals(ref.getType())) continue;
                String oldId = ref.getResourceId();
                String newId = HyperlinkUtils.toAttachmentURL((String)oldId);
                this.resourceIdMap.put(oldId, newId);
                resourceRefArray.put((Object)newId);
            }
            if (resourceRefArray.length() > 0) {
                extObject.put("resourceRefs", (Object)resourceRefArray);
            }
            this.serializeWorkbookExtensionElement(extObject, ext.getContent());
            extensionArray.put((Object)extObject);
        }
        IManifest manifest = this.extensionManager.getOwnedWorkbook().getManifest();
        for (String entryPath : refManager.getRefsFor(this.extensionManager.getOwnedWorkbook(), "file-entry")) {
            this.saveResource(manifest, entryPath);
        }
        JSONObject extensionsObject = new JSONObject();
        if (extensionArray.length() > 0) {
            extensionsObject.put("extensions", (Object)extensionArray);
        }
        return extensionsObject;
    }

    private void saveResource(IManifest manifest, String entryPath) throws IOException {
        if (!entryPath.startsWith("resources/")) {
            return;
        }
        IFileEntry entry = manifest.getFileEntry(entryPath);
        if (entry == null || entry.isDirectory()) {
            return;
        }
        PathInfo pathInfo = new PathInfo(entryPath);
        if (this.resourceStorage.getInputSource().hasEntry(pathInfo.hash)) {
            return;
        }
        try (InputStream sourceStream = entry.openInputStream();
             OutputStream targetStream = this.resourceStorage.getOutputTarget().openEntryStream(pathInfo.hash);){
            FileUtils.transfer((InputStream)sourceStream, (OutputStream)targetStream, (boolean)false);
        }
    }

    private void serializeWorkbookExtensionElement(JSONObject elementObject, IWorkbookExtensionElement element) {
        String textContent;
        JSONObject attrMapObject = new JSONObject();
        for (String attrKey : element.getAttributeKeys()) {
            attrMapObject.put(attrKey, (Object)element.getAttribute(attrKey));
        }
        if (attrMapObject.length() > 0) {
            elementObject.put("attrs", (Object)attrMapObject);
        }
        if ((textContent = element.getTextContent()) != null) {
            elementObject.put("content", (Object)textContent);
        } else {
            JSONArray childElementArray = new JSONArray();
            for (IWorkbookExtensionElement childElement : element.getChildren()) {
                JSONObject childElementObject = new JSONObject().put("name", (Object)childElement.getName());
                this.serializeWorkbookExtensionElement(childElementObject, childElement);
                childElementArray.put((Object)childElementObject);
            }
            if (childElementArray.length() > 0) {
                elementObject.put("content", (Object)childElementArray);
            }
        }
    }
}

