/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xmind.core.io.IInputSource;
import org.xmind.core.net.internal.MonitoredInputStream;

public class MonitoredInputSource
implements IInputSource {
    protected final IInputSource source;
    private IProgressMonitor monitor;

    public MonitoredInputSource(IInputSource source, IProgressMonitor monitor) {
        this.source = source;
        this.monitor = monitor;
    }

    public boolean hasEntry(String entryName) {
        return this.source.hasEntry(entryName);
    }

    public Iterator<String> getEntries() {
        return this.source.getEntries();
    }

    public boolean isEntryAvailable(String entryName) {
        return this.source.isEntryAvailable(entryName);
    }

    public InputStream getEntryStream(String entryName) {
        InputStream stream = this.source.getEntryStream(entryName);
        if (stream != null && this.monitor != null) {
            return new MonitoredInputStream(stream, this.monitor);
        }
        return stream;
    }

    public InputStream openEntryStream(String entryName) throws IOException {
        InputStream stream = this.source.openEntryStream(entryName);
        if (this.monitor != null) {
            return new MonitoredInputStream(stream, this.monitor);
        }
        return stream;
    }

    public long getEntrySize(String entryName) {
        return this.source.getEntrySize(entryName);
    }

    public long getEntryTime(String entryName) {
        return this.source.getEntryTime(entryName);
    }
}

