/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.dashboard.DashboardPart;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.dashboard.pages.IDashboardPage;
import org.xmind.ui.tabfolder.MTabFolder;
import org.xmind.ui.tabfolder.MTabItem;

public class DashboardContent {
    private static final String CONTENT_URI = "platform:/plugin/org.xmind.cathy/dashboard/dashboard.xml";
    private static final String NLS_PATH_BASE = "dashboard/dashboard";
    private static final String TAG_DASHBOARD = "dashboard";
    private static final String TAG_PAGE = "page";
    private static final String TAG_SPACE = "space";
    private static final String TAG_COMMAND = "command";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_ITEM = "item";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_TOOLTIP = "tooltip";
    private static final String ATTR_ICON_URI = "iconURI";
    private static final String ATTR_CONTRIBUTION_URI = "contributionURI";
    private static final String ATTR_COMMAND_ID = "commandId";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_COLOR = "color";
    private static final String VAL_FILL = "fill";
    private static final String DATA_ID = "org.xmind.ui.dashboard.itemId";
    private static final String DATA_PARAMETERS = "org.xmind.ui.dashboard.commandParameters";
    private static final String STATE_SELECTED_PAGE_ID = "selectedPageId";
    private final DashboardPart part;
    private final MTabFolder tabFolder;
    private Properties nlsProperties = new Properties();

    public DashboardContent(final DashboardPart part, final MTabFolder tabFolder) {
        this.part = part;
        this.tabFolder = tabFolder;
        this.loadFromDefaultLocation();
        tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object page = event.item.getData();
                if (page instanceof IDashboardPage) {
                    DashboardContent.this.handlePageSelected((IDashboardPage)page);
                }
            }
        });
        tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MTabItem item = tabFolder.getSelection();
                String pageId = (String)item.getData(DashboardContent.DATA_ID);
                if (pageId != null) {
                    part.setPersistedState(DashboardContent.STATE_SELECTED_PAGE_ID, pageId);
                }
            }
        });
    }

    private void loadFromDefaultLocation() {
        this.nlsProperties = CathyPlugin.getDefault().loadNLSProperties(NLS_PATH_BASE);
        try {
            URL docURL = new URL(CONTENT_URI);
            this.loadFromURL(docURL);
        }
        catch (Exception e) {
            CathyPlugin.log(e, "Failed to load dashboard content from platform:/plugin/org.xmind.cathy/dashboard/dashboard.xml");
        }
        MTabItem primarySelection = this.findPrimarySelection();
        this.tabFolder.setSelection(primarySelection);
        IDashboardPage page = this.getDashboardPage(primarySelection);
        if (page != null) {
            if (page.getControl() == null || page.getControl().isDisposed()) {
                page.createControl(this.tabFolder.getBody());
                primarySelection.setControl(page.getControl());
            }
            this.handlePageSelected(page);
        }
    }

    private void loadFromURL(URL docURL) throws Exception {
        InputStream docStream = docURL.openStream();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(docStream);
            Element rootElement = doc.getDocumentElement();
            if (rootElement == null || !TAG_DASHBOARD.equals(rootElement.getNodeName())) {
                throw new IllegalArgumentException("No 'dashboard' element in platform:/plugin/org.xmind.cathy/dashboard/dashboard.xml");
            }
            this.readElement(rootElement, this.tabFolder);
        }
        finally {
            docStream.close();
        }
    }

    private void readElement(Element element, Object parent) throws Exception {
        String tagName = element.getTagName();
        Object item = parent;
        if (parent instanceof MTabFolder) {
            if (TAG_PAGE.equals(tagName)) {
                item = this.readPage(element, (MTabFolder)parent);
            } else if (TAG_COMMAND.equals(tagName)) {
                item = this.readCommand(element, (MTabFolder)parent);
            } else if (TAG_SPACE.equals(tagName)) {
                item = this.readSeparator(element, (MTabFolder)parent);
            } else if (TAG_ITEM.equals(tagName)) {
                item = this.readSimpleItem(element, (MTabFolder)parent);
            }
        } else if (parent instanceof MTabItem && TAG_PARAMETER.equals(tagName)) {
            this.readCommandParameter(element, (MTabItem)parent);
        }
        this.readChildren(element.getChildNodes(), item);
    }

    private void readChildren(NodeList children, Object parent) throws Exception {
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1) {
                this.readElement((Element)childNode, parent);
            }
            ++i;
        }
    }

    private MTabItem readPage(Element element, MTabFolder tabFolder) throws Exception {
        Class cls;
        String id = element.getAttribute(ATTR_ID);
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("No id for page.");
        }
        String contributionURI = element.getAttribute(ATTR_CONTRIBUTION_URI);
        if (contributionURI == null || !contributionURI.startsWith("bundleclass://")) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String[] contributionPaths = contributionURI.substring(14).split("/");
        if (contributionPaths.length != 2) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String bundleId = contributionPaths[0];
        String className = contributionPaths[1];
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                throw new ClassNotFoundException();
            }
            cls = bundle.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object contribution = ContextInjectionFactory.make((Class)cls, (IEclipseContext)this.part.getContext());
        if (!(contribution instanceof IDashboardPage)) {
            throw new IllegalArgumentException("Invalid contribution type: " + contribution);
        }
        final IDashboardPage page = (IDashboardPage)contribution;
        page.setContext((IDashboardContext)this.part);
        String label = this.readLabel(element);
        page.setTitle(label);
        ImageDescriptor icon = this.readIcon(element);
        page.setImageDescriptor(icon);
        MTabItem item = new MTabItem(tabFolder, 16);
        item.setText(page.getTitle());
        String tooltip = this.readTooltip(element);
        item.setTooltipText(tooltip);
        item.setImage(page.getImage());
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control pageControl = page.getControl();
                if (pageControl != null) {
                    pageControl.dispose();
                }
                page.dispose();
            }
        });
        item.setData((Object)page);
        item.setData(DATA_ID, (Object)id);
        return item;
    }

    private MTabItem readCommand(Element element, MTabFolder tabFolder) throws Exception {
        String id = element.getAttribute(ATTR_ID);
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("No id for command.");
        }
        final String commandId = element.getAttribute(ATTR_COMMAND_ID);
        if (commandId == null || "".equals(commandId)) {
            throw new IllegalArgumentException("No command id found for command");
        }
        String label = this.readLabel(element);
        String tooltip = this.readTooltip(element);
        ImageDescriptor icon = this.readIcon(element);
        MTabItem item = new MTabItem(tabFolder, 8);
        String width = element.getAttribute(ATTR_WIDTH);
        if (width != null && !"".equals(width)) {
            try {
                int widthValue = Integer.parseInt(width, 10);
                item.setWidth(widthValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        item.setText(label);
        item.setTooltipText(tooltip);
        final Image iconImage = icon == null ? null : icon.createImage();
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                iconImage.dispose();
            }
        });
        item.setImage(iconImage);
        item.setData(DATA_ID, (Object)id);
        item.setData(DATA_PARAMETERS, (Object)new Properties());
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                Properties commandParameters = (Properties)event.widget.getData(DashboardContent.DATA_PARAMETERS);
                if (commandParameters != null) {
                    for (Map.Entry<Object, Object> en : commandParameters.entrySet()) {
                        parameters.put((String)en.getKey(), en.getValue());
                    }
                }
                DashboardContent.this.part.executeCommand(commandId, parameters);
            }
        });
        return item;
    }

    private MTabItem readSimpleItem(Element element, MTabFolder tabFolder) throws Exception {
        String id = element.getAttribute(ATTR_ID);
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("No id for page.");
        }
        String label = this.readLabel(element);
        String tooltip = this.readTooltip(element);
        ImageDescriptor icon = this.readIcon(element);
        MTabItem item = new MTabItem(tabFolder, 64);
        item.setText(label);
        item.setTooltipText(tooltip);
        final Image iconImage = icon.createImage();
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                iconImage.dispose();
            }
        });
        item.setImage(iconImage);
        item.setData(DATA_ID, (Object)id);
        return item;
    }

    private MTabItem readSeparator(Element element, MTabFolder tabFolder) throws Exception {
        String id = element.getAttribute(ATTR_ID);
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("No id for page.");
        }
        MTabItem item = new MTabItem(tabFolder, 2);
        item.setData(DATA_ID, (Object)id);
        String width = element.getAttribute(ATTR_WIDTH);
        if (VAL_FILL.equals(width)) {
            item.setWidth(-2);
        } else if (width != null && !"".equals(width)) {
            try {
                int widthValue = Integer.parseInt(width, 10);
                item.setWidth(widthValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String color = element.getAttribute(ATTR_COLOR);
        if (color != null && !"".equals(color)) {
            item.setColor(color);
        }
        return item;
    }

    private void readCommandParameter(Element element, MTabItem item) {
        String name = element.getAttribute(ATTR_NAME);
        String value = element.getAttribute(ATTR_VALUE);
        if (name == null || "".equals(name) || value == null || "".equals(value)) {
            return;
        }
        Properties parameters = (Properties)item.getData(DATA_PARAMETERS);
        if (parameters == null) {
            return;
        }
        parameters.put(name, value);
    }

    private ImageDescriptor readIcon(Element element) throws MalformedURLException {
        String iconURI = element.getAttribute(ATTR_ICON_URI);
        ImageDescriptor icon = iconURI == null || "".equals(iconURI) ? null : ImageDescriptor.createFromURL((URL)new URL(iconURI));
        return icon;
    }

    private String readLabel(Element element) {
        String nativeLabel;
        String label = element.getAttribute(ATTR_LABEL);
        if (label.startsWith("%") && (nativeLabel = this.nlsProperties.getProperty(label.substring(1))) != null) {
            label = nativeLabel;
        }
        return label;
    }

    private String readTooltip(Element element) {
        String nativeTooltip;
        String tooltip = element.getAttribute(ATTR_TOOLTIP);
        if (tooltip.startsWith("%") && (nativeTooltip = this.nlsProperties.getProperty(tooltip.substring(1))) != null) {
            tooltip = nativeTooltip;
        }
        return tooltip;
    }

    private MTabItem findPrimarySelection() {
        MTabItem item;
        String lastPageId = this.part.getPersistedState(STATE_SELECTED_PAGE_ID);
        if (lastPageId != null && (item = this.getItemById(lastPageId)) != null) {
            return item;
        }
        int itemCount = this.tabFolder.getItemCount();
        int i = 0;
        while (i < itemCount) {
            MTabItem item2 = this.tabFolder.getItem(i);
            if ((item2.getStyle() & 0x10) != 0) {
                return item2;
            }
            ++i;
        }
        return null;
    }

    public MTabItem getItemById(String pageId) {
        if (pageId == null) {
            return null;
        }
        int itemCount = this.tabFolder.getItemCount();
        int i = 0;
        while (i < itemCount) {
            MTabItem item = this.tabFolder.getItem(i);
            if (pageId.equals(item.getData(DATA_ID))) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public String getItemId(MTabItem item) {
        return (String)item.getData(DATA_ID);
    }

    public IDashboardPage getDashboardPage(MTabItem item) {
        Object data = item.getData();
        return data instanceof IDashboardPage ? (IDashboardPage)data : null;
    }

    protected void handlePageSelected(IDashboardPage page) {
        ISelectionProvider selectionProvider = CathyPlugin.getAdapter(page, ISelectionProvider.class);
        this.part.setSelectionProvider(selectionProvider);
    }
}

