/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.ui.internal.utils.CommandUtils;
import org.xmind.ui.resources.ColorUtils;

public class XEditorStackRenderer
extends StackRenderer {
    private ResourceManager resources;
    private Composite nullContent;

    public Object createWidget(MUIElement element, Object parent) {
        final CTabFolder ctf = (CTabFolder)super.createWidget(element, parent);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)ctf);
        this.nullContent = this.createNullContentTipArea(ctf);
        this.nullContent.moveBelow(null);
        ctf.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                XEditorStackRenderer.this.nullContent.moveBelow(null);
                if (ctf.getItemCount() == 0) {
                    ctf.setFocus();
                }
            }
        });
        ctf.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XEditorStackRenderer.this.nullContent.setBounds(ctf.getClientArea());
            }

            public void controlMoved(ControlEvent e) {
                XEditorStackRenderer.this.nullContent.setBounds(ctf.getClientArea());
            }
        });
        return ctf;
    }

    private Composite createNullContentTipArea(CTabFolder parent) {
        Composite composite = new Composite((Composite)parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Composite centerArea = new Composite(composite, 0);
        centerArea.setBackground(composite.getBackground());
        centerArea.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.verticalSpacing = 40;
        centerArea.setLayout((Layout)layout2);
        this.createTopArea(centerArea);
        this.createBottomArea(centerArea);
        return composite;
    }

    private void createTopArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setBackground(composite.getBackground());
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        imageLabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/views/null_editor_tip.png")));
    }

    private void createBottomArea(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(WorkbenchMessages.XStackRenderer_BottomArea_Add_button);
        GridData layoutData = new GridData(0x1000000, 0x1000000, false, false);
        layoutData.widthHint = Math.max(128, button.computeSize((int)-1, (int)-1).x + 10);
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandUtils.executeCommand((String)"org.xmind.ui.command.newWorkbook", (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        });
    }
}

