/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util;

import com.openstego.desktop.OpenStegoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class UserPreferences {
    private static final String PREF_FILENAME = "openstego.ini";
    private static final String DEFAULT_PREF_FILENAME = "openstego.default.ini";
    private static Properties prefs = null;

    protected UserPreferences() {
    }

    public static void init() throws OpenStegoException {
        if (prefs != null) {
            return;
        }
        prefs = new Properties();
        String userHome = System.getProperty("user.home");
        File prefFile = new File(userHome, PREF_FILENAME);
        if (!prefFile.exists()) {
            try {
                prefFile.createNewFile();
            }
            catch (IOException e) {
                throw new OpenStegoException(e);
            }
            try (InputStream tmplIS = UserPreferences.class.getResourceAsStream("/openstego.default.ini");
                 FileOutputStream prefFileOS = new FileOutputStream(prefFile);){
                int len;
                byte[] buff = new byte[1024];
                while ((len = tmplIS.read(buff)) >= 0) {
                    ((OutputStream)prefFileOS).write(buff, 0, len);
                }
            }
            catch (IOException e) {
                throw new OpenStegoException(e);
            }
        }
        try (FileInputStream prefFileIS = new FileInputStream(prefFile);){
            prefs.load(prefFileIS);
        }
        catch (IOException e) {
            throw new OpenStegoException(e);
        }
    }

    public static String getString(String key) {
        String val = prefs.getProperty(key);
        if (val == null) {
            return null;
        }
        return val.trim();
    }

    public static Integer getInteger(String key) throws OpenStegoException {
        String val = UserPreferences.getString(key);
        if (val == null) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new OpenStegoException(null, "OpenStego", 17, key);
        }
    }

    public static Float getFloat(String key) throws OpenStegoException {
        String val = UserPreferences.getString(key);
        if (val == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(val));
        }
        catch (NumberFormatException e) {
            throw new OpenStegoException(null, "OpenStego", 18, key);
        }
    }

    public static Boolean getBoolean(String key) throws OpenStegoException {
        String val = UserPreferences.getString(key);
        if (val == null) {
            return null;
        }
        if ("t".equals(val = val.toLowerCase()) || "true".equals(val) || "y".equals(val) || "yes".equals(val) || "1".equals(val)) {
            return true;
        }
        if ("f".equals(val) || "false".equals(val) || "n".equals(val) || "no".equals(val) || "0".equals(val)) {
            return false;
        }
        throw new OpenStegoException(null, "OpenStego", 19, key);
    }
}

